/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.completion.SqlCompletionContributor;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.options.SqlCodeCompletionSettings;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlJoinSmartCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(2);
        }
        SqlJoinSmartCompletionProvider.suggestJoinStuff(parameters, result2);
    }

    public static boolean suggestJoinStuff(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiFile file;
        if (parameters == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(4);
        }
        if (!((file = parameters.getOriginalFile()) instanceof SqlFile)) {
            return true;
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent2 = position.getParent();
        if (parent2.getNextSibling() != null) {
            return true;
        }
        PsiElement grandPa = parent2.getParent();
        if (grandPa instanceof SqlReferenceExpression && ((SqlReferenceExpression)grandPa).getQualifierExpression() != null) {
            return true;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        LinkedHashSet tables = ContainerUtil.newLinkedHashSet(SqlJoinSmartCompletionProvider.collectTablesForJoin(parent2, dialect));
        for (TableInfo table : tables) {
            SqlCompletionUtil.addLookupElement(dialect, table.table, (Consumer<? super LookupElement>)result2, false, 90.0);
        }
        SqlJoinSmartCompletionProvider.suggestJoinConditions(parent2, dialect, tables, (Consumer<String>)((Consumer)statement -> {
            if (result2 == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(52);
            }
            SqlJoinSmartCompletionProvider.addFkItem(result2, statement);
        }), null);
        SqlJoinSmartCompletionProvider.suggestJoinUsing(parent2, dialect, result2);
        return false;
    }

    @NotNull
    private static Collection<TableInfo> collectTablesForJoin(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx dialect) {
        SqlJoinExpression join2;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(5);
        }
        if (dialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(6);
        }
        if ((join2 = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlJoinExpression.class)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        PsiElement parent2 = position.getParent();
        if (parent2 == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        ASTNode joinNode = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)parent2.getNode());
        if (joinNode == null || joinNode.getElementType() != SqlCommonKeywords.SQL_JOIN && joinNode.getElementType() != SqlCommonTokens.SQL_COMMA) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (!(parent2 instanceof SqlReferenceExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        PsiReference reference = parent2.getReference();
        if (!(reference instanceof SqlReferenceImpl)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(11);
            }
            return list;
        }
        HashSet fromLeft = ContainerUtil.newHashSet();
        SqlJoinExpression topmost = (SqlJoinExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)join2, SqlJoinExpression.class);
        SqlJoinExpression mainJoin = topmost == null ? join2 : topmost;
        Collection<TableInfo> collection = SqlJoinSmartCompletionProvider.collectTablesForJoin(dialect, parent2, (SqlReferenceImpl)reference, fromLeft, (PsiElement)mainJoin);
        if (collection == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    public static Collection<TableInfo> collectTablesForJoin(@NotNull SqlLanguageDialectEx dialect, PsiElement parent2, SqlReferenceImpl reference, final Collection<DasTable> fromLeft, final PsiElement mainJoin) {
        if (dialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(13);
        }
        mainJoin.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element2) {
                ContainerUtil.addAllNotNull((Collection)fromLeft, (Object[])new DasTable[]{SqlCompletionContributor.retrieveTable(element2)});
                super.visitElement(element2);
            }
        });
        final HashSet fks = ContainerUtil.newHashSet();
        for (DasTable table : fromLeft) {
            Iterables.addAll((Collection)fks, (Iterable)DasUtil.getForeignKeys((DasTable)table));
        }
        final ArrayList result2 = ContainerUtil.newArrayList();
        reference.processResolveVariants(new SqlScopeProcessor(null, dialect, SqlImplUtil.getDataSources(parent2), parent2){

            @Override
            public boolean isResultEmpty() {
                return false;
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element2, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element2 instanceof DasTable) {
                    this.addLookupElement((DasTable)element2);
                }
                return true;
            }

            private void addLookupElement(@NotNull DasTable table) {
                if (table == null) {
                    2.$$$reportNull$$$0(2);
                }
                for (DasForeignKey fk : fks) {
                    if (!SqlJoinSmartCompletionProvider.cheapEquals(table, fk) || !table.equals(fk.getRefTable())) continue;
                    result2.add(new TableInfo(table, ObjectName.plain((String)this.suggestAlias(table, mainJoin)), null));
                    return;
                }
                for (DasForeignKey fk : DasUtil.getForeignKeys((DasTable)table)) {
                    DasTable info = (DasTable)ContainerUtil.find((Iterable)fromLeft, info1 -> SqlJoinSmartCompletionProvider.cheapEquals(info1, fk));
                    if (info == null || !fromLeft.contains(fk.getRefTable())) continue;
                    result2.add(new TableInfo(table, ObjectName.plain((String)this.suggestAlias(table, mainJoin)), null));
                    return;
                }
            }

            @Nullable
            private String suggestAlias(@NotNull DasTable table, @NotNull PsiElement element2) {
                if (table == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (element2 == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (!SqlCodeCompletionSettings.getInstance().isUseAliasInJoinCompletion()) {
                    return null;
                }
                String tableName = table.getName();
                Collection<String> existingNames = SqlNamesGenerator.collectExistingNamesForContainingStatement(element2);
                existingNames.add(tableName);
                return SqlNamesGenerator.suggestAliasName(element2, existingNames, tableName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "executeTarget";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addLookupElement";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "suggestAlias";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static boolean cheapEquals(@NotNull DasTable table, @NotNull DasForeignKey fk) {
        if (table == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(15);
        }
        if (fk == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(16);
        }
        return !(!Comparing.strEqual((String)table.getName(), (String)fk.getRefTableName(), (boolean)false) || !StringUtil.isEmpty((String)DasUtil.getSchema((DasObject)table)) && !StringUtil.isEmpty((String)fk.getRefTableSchema()) && !Comparing.strEqual((String)DasUtil.getSchema((DasObject)table), (String)fk.getRefTableSchema(), (boolean)false) || !StringUtil.isEmpty((String)DasUtil.getCatalog((DasObject)table)) && !StringUtil.isEmpty((String)fk.getRefTableCatalog()) && !Comparing.strEqual((String)DasUtil.getCatalog((DasObject)table), (String)fk.getRefTableCatalog(), (boolean)false));
    }

    private static void collectTables(@Nullable SqlExpression e, @NotNull Collection<TableInfo> tables) {
        if (tables == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(17);
        }
        if (e instanceof SqlJoinExpression) {
            SqlJoinSmartCompletionProvider.collectTables(((SqlJoinExpression)e).getLOperand(), tables);
            SqlJoinSmartCompletionProvider.collectTables(((SqlJoinExpression)e).getROperand(), tables);
            return;
        }
        ContainerUtil.addAllNotNull(tables, (Object[])new TableInfo[]{SqlJoinSmartCompletionProvider.retrieveTable(e)});
    }

    private static TableInfo retrieveTable(@Nullable SqlExpression o) {
        SqlAsExpression asExpr = (SqlAsExpression)ObjectUtils.tryCast((Object)o, SqlAsExpression.class);
        return asExpr != null ? SqlJoinSmartCompletionProvider.retrieveTable(asExpr.getExpression(), DbSqlUtil.getName((DasObject)asExpr)) : SqlJoinSmartCompletionProvider.retrieveTable(o, null);
    }

    @Nullable
    private static TableInfo retrieveTable(@Nullable SqlExpression place, @Nullable ObjectName alias) {
        DasTable table = SqlCompletionContributor.retrieveTable((PsiElement)place);
        return table == null ? null : new TableInfo(table, alias, place);
    }

    public static void suggestJoinConditions(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull Collection<TableInfo> right, @NotNull Consumer<String> result2, @Nullable Collection<TableInfo> left) {
        boolean appendTable;
        PsiElement parent2;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(18);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(19);
        }
        if (right == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(20);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(21);
        }
        if ((parent2 = position.getParent()) == null) {
            return;
        }
        ASTNode sibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)parent2.getNode());
        IElementType type = sibling == null ? null : sibling.getElementType();
        boolean appendCondition = type == SqlCommonKeywords.SQL_ON;
        boolean bl = appendTable = left != null || type == SqlCommonKeywords.SQL_JOIN;
        if (!appendCondition && !appendTable) {
            return;
        }
        SqlJoinExpression join2 = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlJoinExpression.class);
        if (left == null && join2 == null) {
            return;
        }
        if (join2 != null) {
            left = ContainerUtil.newLinkedHashSet();
            SqlJoinSmartCompletionProvider.collectTables(join2.getLOperand(), left);
        }
        if (!appendTable) {
            SqlJoinSmartCompletionProvider.collectTables(join2.getROperand(), right);
        }
        Project project = position.getProject();
        SqlJoinSmartCompletionProvider.processTables(project, left, right, sqlDialect, result2, join2 == null ? null : join2.getLOperand());
    }

    @Nullable
    public static String collectUsingCandidatesAndGetStatement(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull Map<String, PsiElement> toColumn, @NotNull List<String> usingCandidates) {
        String name;
        int i2;
        SqlUsingClause using;
        SqlJoinExpression join2;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(22);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(23);
        }
        if (toColumn == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(24);
        }
        if (usingCandidates == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(25);
        }
        SqlJoinExpression sqlJoinExpression = join2 = (using = (SqlUsingClause)PsiTreeUtil.getParentOfType((PsiElement)position, SqlUsingClause.class)) == null ? null : (SqlJoinExpression)ObjectUtils.tryCast((Object)using.getParent(), SqlJoinExpression.class);
        if (join2 == null) {
            return null;
        }
        SqlReferenceList refs = using.getReferenceList();
        if (refs == null || !PsiTreeUtil.isContextAncestor((PsiElement)refs, (PsiElement)position, (boolean)false)) {
            return null;
        }
        SqlExpression right = join2.getROperand();
        SqlTableType ltype = (SqlTableType)ObjectUtils.tryCast((Object)join2.getLOperand().getSqlType(), SqlTableType.class);
        SqlTableType rtype = (SqlTableType)ObjectUtils.tryCast((Object)(right == null ? null : right.getSqlType()), SqlTableType.class);
        if (ltype == null || rtype == null) {
            return null;
        }
        Set lnames = DasUtil.newCaseAwareSet((boolean)false);
        Set rnames = DasUtil.newCaseAwareSet((boolean)false);
        HashSet exluded = ContainerUtil.newHashSet();
        for (i2 = 0; i2 < ltype.getColumnCount(); ++i2) {
            name = ltype.getColumnName(i2);
            toColumn.put(name, ltype.getColumnElement(i2));
            if (lnames.add(name)) continue;
            exluded.add(name);
        }
        for (i2 = 0; i2 < rtype.getColumnCount(); ++i2) {
            name = rtype.getColumnName(i2);
            if (rnames.add(name)) continue;
            exluded.add(name);
        }
        for (i2 = 0; i2 < ltype.getColumnCount(); ++i2) {
            name = ltype.getColumnName(i2);
            if (!rnames.contains(name) || exluded.contains(name)) continue;
            usingCandidates.add(name);
        }
        if (usingCandidates.size() >= 2 || refs.getReferenceList().size() > 1) {
            DdlBuilder builder = new DdlBuilder().withDialect(sqlDialect.getDatabaseDialect()).applyCodeStyle(position.getProject());
            for (String candidate : usingCandidates) {
                if (!builder.isEmpty()) {
                    builder.symbol(", ");
                }
                builder.columnRef(candidate);
            }
            return builder.getStatement();
        }
        return null;
    }

    private static void suggestJoinUsing(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull CompletionResultSet result2) {
        ArrayList usingCandidates;
        HashMap toColumn;
        String statement;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(26);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(27);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(28);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(statement = SqlJoinSmartCompletionProvider.collectUsingCandidatesAndGetStatement(position, sqlDialect, toColumn = ContainerUtil.newHashMap(), usingCandidates = ContainerUtil.newArrayList())))) {
            result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)statement).withIcon(DatabaseIcons.ColBlueKey), (double)90.0));
        }
        for (String candidate : usingCandidates) {
            SqlCompletionUtil.addLookupElement(sqlDialect, toColumn.get(candidate), null, (Consumer<? super LookupElement>)result2, false, 90.0, PsiTreeUtil.getParentOfType((PsiElement)position, SqlReferenceExpression.class));
        }
    }

    private static void processForeignKeys(@NotNull Project project, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull TableInfo first, @NotNull TableInfo second, @NotNull Consumer<String> result2, @Nullable SqlExpression lOperand) {
        if (project == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(29);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(30);
        }
        if (first == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(31);
        }
        if (second == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(32);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(33);
        }
        SqlJoinSmartCompletionProvider.foreignKeyStatements(project, sqlDialect, first, second, lOperand).forEach(arg_0 -> result2.consume(arg_0));
    }

    private static void addFkItem(@NotNull CompletionResultSet result2, String s) {
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(34);
        }
        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)s).withIcon(DatabaseIcons.ColBlueKey), (double)91.0));
    }

    private static Iterable<String> foreignKeyStatements(@NotNull Project project, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull TableInfo firstTable, @NotNull TableInfo secondTable, @Nullable SqlExpression lOperand) {
        if (project == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(35);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(36);
        }
        if (firstTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(37);
        }
        if (secondTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(38);
        }
        DatabaseDialectEx dialect = sqlDialect.getDatabaseDialect();
        boolean ancestor = secondTable.place != null && PsiTreeUtil.isContextAncestor((PsiElement)lOperand, (PsiElement)secondTable.place, (boolean)false);
        boolean leftToRight = ancestor ^ SqlCodeCompletionSettings.getInstance().isInvertOrderInOnClause();
        ArrayList result2 = ContainerUtil.newArrayList();
        for (DasForeignKey key2 : DasUtil.getForeignKeys((DasTable)secondTable.table)) {
            if (!firstTable.table.equals(key2.getRefTable())) continue;
            MultiRef cols = key2.getColumnsRef();
            MultiRef refCols = key2.getRefColumns();
            if (cols.size() != refCols.size()) continue;
            DdlBuilder builder = new DdlBuilder().withDialect(dialect).applyCodeStyle(project);
            if (firstTable.place == null) {
                SqlJoinSmartCompletionProvider.appendTableReference(builder, firstTable);
            } else if (secondTable.place == null) {
                SqlJoinSmartCompletionProvider.appendTableReference(builder, secondTable);
            }
            boolean first = true;
            Iterator<ObjectName> refIt = SqlJoinSmartCompletionProvider.iterateNames((MultiRef<? extends DasObject>)refCols);
            for (ObjectName name : JBIterable.once(SqlJoinSmartCompletionProvider.iterateNames((MultiRef<? extends DasObject>)cols))) {
                if (first) {
                    first = false;
                } else {
                    builder.space().keyword("and").space();
                }
                ObjectName refName = refIt.next();
                Runnable leftPart = () -> {
                    if (secondTable == null) {
                        SqlJoinSmartCompletionProvider.$$$reportNull$$$0(51);
                    }
                    SqlJoinSmartCompletionProvider.appendJoinPart(name, secondTable, key2.getTable(), builder);
                };
                Runnable rightPart = () -> {
                    if (firstTable == null) {
                        SqlJoinSmartCompletionProvider.$$$reportNull$$$0(50);
                    }
                    SqlJoinSmartCompletionProvider.appendJoinPart(refName, firstTable, key2.getRefTable(), builder);
                };
                (leftToRight ? leftPart : rightPart).run();
                builder.space().symbol("=").space();
                (leftToRight ? rightPart : leftPart).run();
            }
            result2.add(builder.getStatement());
        }
        return result2;
    }

    private static Iterator<ObjectName> iterateNames(MultiRef<? extends DasObject> ref) {
        final MultiRef.It it = ref.iterate();
        return new JBIterator<ObjectName>(){

            protected ObjectName nextImpl() {
                if (!it.hasNext()) {
                    return (ObjectName)this.stop();
                }
                String name = (String)it.next();
                DasObject obj2 = (DasObject)it.resolve();
                return obj2 == null ? ObjectName.plain((String)name) : DbSqlUtil.getName(obj2);
            }
        };
    }

    private static void appendTableReference(@NotNull DdlBuilder builder, @NotNull TableInfo info) {
        if (builder == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(39);
        }
        if (info == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(40);
        }
        builder.identifier((DasObject)info.table).space();
        if (info.alias != null) {
            builder.identifier(info.alias, ObjectKind.TABLE).space();
        }
        builder.keyword("on").space();
    }

    private static void appendJoinPart(@NotNull ObjectName columnName, @NotNull TableInfo info, @NotNull DasTable relatedTable, @NotNull DdlBuilder builder) {
        if (columnName == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(41);
        }
        if (info == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(42);
        }
        if (relatedTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(43);
        }
        if (builder == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(44);
        }
        (info.alias == null ? builder.identifier((DasObject)relatedTable) : builder.identifier(info.alias, ObjectKind.TABLE)).symbol(".").identifier(columnName, ObjectKind.COLUMN);
    }

    private static void processTables(@NotNull Project project, @NotNull Collection<TableInfo> left, @NotNull Collection<TableInfo> right, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull Consumer<String> result2, @Nullable SqlExpression lOperand) {
        if (project == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(45);
        }
        if (left == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(46);
        }
        if (right == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(47);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(48);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(49);
        }
        for (TableInfo r : right) {
            if (left.contains(r)) continue;
            for (TableInfo l : left) {
                SqlJoinSmartCompletionProvider.processForeignKeys(project, sqlDialect, r, l, result2, lOperand);
                SqlJoinSmartCompletionProvider.processForeignKeys(project, sqlDialect, l, r, result2, lOperand);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 21: 
            case 28: 
            case 33: 
            case 34: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 18: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fk";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 19: 
            case 23: 
            case 27: 
            case 30: 
            case 36: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlDialect";
                break;
            }
            case 20: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toColumn";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usingCandidates";
                break;
            }
            case 29: 
            case 35: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 37: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstTable";
                break;
            }
            case 38: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondTable";
                break;
            }
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedTable";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTablesForJoin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suggestJoinStuff";
                break;
            }
            case 5: 
            case 6: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectTablesForJoin";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cheapEquals";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectTables";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "suggestJoinConditions";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectUsingCandidatesAndGetStatement";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "suggestJoinUsing";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processForeignKeys";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addFkItem";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "foreignKeyStatements";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "appendTableReference";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "appendJoinPart";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processTables";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$foreignKeyStatements$2";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$foreignKeyStatements$1";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$suggestJoinStuff$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TableInfo {
        final DasTable table;
        final ObjectName alias;
        final SqlExpression place;
        @NotNull
        private final String qualifiedName;

        public TableInfo(@NotNull DasTable table, @Nullable ObjectName alias, @Nullable SqlExpression place) {
            if (table == null) {
                TableInfo.$$$reportNull$$$0(0);
            }
            this.table = table;
            this.alias = alias;
            this.place = place;
            this.qualifiedName = QNameUtil.getQualifiedName((DasObject)table);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableInfo info = (TableInfo)o;
            return this.qualifiedName.equals(info.qualifiedName);
        }

        public int hashCode() {
            return Objects.hash(this.qualifiedName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$TableInfo", "<init>"));
        }
    }
}

