/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DataConverter;
import com.intellij.database.data.types.PointSet;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversionGraph {
    private static final Function<Object, Object> IDENTITY = o -> o;
    private static final ConversionGraph INSTANCE = new ConversionGraph();
    private final MultiMap<PointSet, Node> myMap = new MultiMap<PointSet, Node>(){

        @NotNull
        protected Collection<Node> createCollection() {
            LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
            if (linkedHashSet == null) {
                1.$$$reportNull$$$0(0);
            }
            return linkedHashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/ConversionGraph$1", "createCollection"));
        }
    };

    ConversionGraph() {
    }

    @Nullable
    private List<Node> shortestPath(@NotNull PointSet from, @NotNull PointSet to) {
        if (from == null) {
            ConversionGraph.$$$reportNull$$$0(0);
        }
        if (to == null) {
            ConversionGraph.$$$reportNull$$$0(1);
        }
        JBTreeTraverser traverser2 = JBTreeTraverser.from(node -> this.myMap.get((Object)((Node)node).pointSet));
        TreeTraversal.TracingIt iterator = (TreeTraversal.TracingIt)((JBTreeTraverser)traverser2.withRoots((Iterable)this.myMap.get((Object)from))).tracingBfsTraversal().unique(node -> ((Node)node).pointSet).typedIterator();
        Ref parent2 = Ref.create((Object)from);
        HashMap path = ContainerUtil.newHashMap();
        iterator.forEachRemaining(node -> {
            Node itParent = (Node)iterator.parent();
            if (itParent != null && itParent.pointSet != parent2.get()) {
                parent2.set((Object)itParent.pointSet);
            }
            path.put(((Node)node).pointSet, parent2.get());
        });
        return path.containsKey(to) && path.containsKey(from) ? this.flat(path, from, to) : null;
    }

    @NotNull
    private List<Node> flat(@NotNull Map<PointSet, PointSet> path, @NotNull PointSet start, @NotNull PointSet end) {
        if (path == null) {
            ConversionGraph.$$$reportNull$$$0(2);
        }
        if (start == null) {
            ConversionGraph.$$$reportNull$$$0(3);
        }
        if (end == null) {
            ConversionGraph.$$$reportNull$$$0(4);
        }
        ArrayList nodes2 = ContainerUtil.newArrayList();
        while (path.get(end) != null) {
            PointSet previous = path.get(end);
            PointSet current = end;
            Node node = (Node)ContainerUtil.find((Iterable)this.myMap.get((Object)previous), currentNode -> Comparing.equal((Object)((Node)currentNode).pointSet, (Object)current));
            if (node == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    ConversionGraph.$$$reportNull$$$0(5);
                }
                return list;
            }
            nodes2.add(node);
            if ((end = path.get(end)) != start) continue;
            break;
        }
        List list = ContainerUtil.reverse((List)nodes2);
        if (list == null) {
            ConversionGraph.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public static Function<Object, Object> getConverter(@Nullable Object o, @NotNull Domain from, @NotNull Domain to) {
        if (from == null) {
            ConversionGraph.$$$reportNull$$$0(7);
        }
        if (to == null) {
            ConversionGraph.$$$reportNull$$$0(8);
        }
        DataConverter.init();
        ConversionPoint<?> startPoint = o == null ? from.getPoint() : from.getPoint().withClass(o.getClass());
        ConversionPoint endPoint = to.getPoint();
        Function<Object, Object> resultFunction = ConversionGraph.getConverter(startPoint, endPoint);
        return resultFunction == null ? null : Functions.compose(resultFunction, obj2 -> {
            if (to == null) {
                ConversionGraph.$$$reportNull$$$0(12);
            }
            return obj2 == null ? null : to.trim(obj2);
        });
    }

    @Nullable
    public static Function<Object, Object> getConverter(@NotNull ConversionPoint<?> startPoint, @NotNull ConversionPoint<?> endPoint) {
        if (startPoint == null) {
            ConversionGraph.$$$reportNull$$$0(9);
        }
        if (endPoint == null) {
            ConversionGraph.$$$reportNull$$$0(10);
        }
        DataConverter.init();
        PointSet start = PointSet.of(startPoint);
        PointSet end = PointSet.of(endPoint);
        List<Node> nodes2 = INSTANCE.shortestPath(start, end);
        if (nodes2 == null) {
            return null;
        }
        List functions = ContainerUtil.map(nodes2, node -> ((Node)node).function);
        Function resultFunction = null;
        for (Function function2 : functions) {
            if (resultFunction == null) {
                resultFunction = function2;
                continue;
            }
            resultFunction = Functions.compose((Function)resultFunction, (Function)function2);
        }
        return resultFunction;
    }

    public static void register(@NotNull DataConverter converter) {
        if (converter == null) {
            ConversionGraph.$$$reportNull$$$0(11);
        }
        PointSet start = converter.getStart();
        PointSet end = converter.getEnd();
        ConversionGraph.INSTANCE.myMap.putValue(start, (Object)new Node(end, converter::convert));
        ConversionGraph.INSTANCE.myMap.putValue(end, (Object)new Node(start, converter::convertReverse));
        ConversionGraph.INSTANCE.myMap.putValue(start, (Object)new Node(start, IDENTITY));
        ConversionGraph.INSTANCE.myMap.putValue(end, (Object)new Node(end, IDENTITY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/ConversionGraph";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endPoint";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/ConversionGraph";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "flat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shortestPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "flat";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConverter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getConverter$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Node {
        private final PointSet pointSet;
        private final Function<Object, Object> function;

        private Node(@NotNull PointSet pointSet, @Nullable Function<Object, Object> function2) {
            if (pointSet == null) {
                Node.$$$reportNull$$$0(0);
            }
            this.pointSet = pointSet;
            this.function = function2;
        }

        public boolean equals(Object obj2) {
            return obj2 instanceof Node && this.pointSet.equals(((Node)obj2).pointSet) && this.function == ((Node)obj2).function;
        }

        public int hashCode() {
            return this.pointSet.hashCode() + Objects.hashCode(this.function);
        }

        public String toString() {
            return this.pointSet.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointSet", "com/intellij/database/data/types/ConversionGraph$Node", "<init>"));
        }
    }
}

