/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.resolve.CssInclusionContext;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;

public class RailsInclusionContext
extends CssInclusionContext {
    @NotNull
    public PsiFile[] getContextFiles(@NotNull PsiFile current) {
        RailsApp app;
        if (current == null) {
            RailsInclusionContext.$$$reportNull$$$0(0);
        }
        if ((app = RailsApp.fromPsiElement((PsiElement)current)) == null) {
            if (PsiFile.EMPTY_ARRAY == null) {
                RailsInclusionContext.$$$reportNull$$$0(1);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        Collection<PsiFileSystemItem> contexts = RailsInclusionContext.getContexts(current);
        HashSet files = new HashSet();
        for (PsiFileSystemItem context : contexts) {
            VirtualFile stylesheets;
            VirtualFile virtualFile = context.getVirtualFile();
            if (virtualFile == null || (stylesheets = virtualFile.findChild("stylesheets")) == null) continue;
            ModuleRootManager manager = ModuleRootManager.getInstance((Module)app.getModule());
            PsiManager psiManager = current.getManager();
            manager.getFileIndex().iterateContentUnderDirectory(stylesheets, fileOrDir -> {
                PsiFile psiFile = psiManager.findFile(fileOrDir);
                if (psiFile != null && SprocketsUtil.isStylesheet((PsiElement)psiFile)) {
                    files.add(psiFile);
                }
                return true;
            });
        }
        PsiFile[] psiFileArray = files.isEmpty() ? PsiFile.EMPTY_ARRAY : files.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            RailsInclusionContext.$$$reportNull$$$0(2);
        }
        return psiFileArray;
    }

    private static Collection<PsiFileSystemItem> getContexts(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            RailsInclusionContext.$$$reportNull$$$0(3);
        }
        if ((virtualFile = file.getOriginalFile().getVirtualFile()) != null) {
            PsiDirectory directory;
            FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
            ArrayList<PsiFileSystemItem> list = new ArrayList<PsiFileSystemItem>();
            Project project = file.getProject();
            for (FileReferenceHelper helper : helpers) {
                if (!helper.isMine(project, virtualFile)) continue;
                list.addAll(helper.getContexts(project, virtualFile));
            }
            if (list.size() > 0) {
                return list;
            }
            VirtualFile parent = virtualFile.getParent();
            if (parent != null && (directory = file.getManager().findDirectory(parent)) != null) {
                return Collections.singleton(directory);
            }
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsInclusionContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsInclusionContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextFiles";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

