/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexUtil;
import org.joni.Matcher;

public class Searcher {
    private final Matcher myMatcher;
    private final String myString;
    private int currentPosition = 0;
    private int currentCharPosition = 0;
    private final byte[] myStringBytes;

    Searcher(String string, byte[] stringBytes, Matcher matcher) {
        this.myString = string;
        this.myStringBytes = stringBytes;
        this.myMatcher = matcher;
    }

    public boolean search() {
        if (this.currentPosition < 0) {
            return false;
        }
        int searchResult = this.myMatcher.search(this.currentPosition, this.myStringBytes.length, 256);
        if (searchResult > -1) {
            this.setCurrentPosition(this.myMatcher.getEagerRegion().end[0]);
        } else {
            this.setCurrentPosition(searchResult);
        }
        return this.currentPosition > -1;
    }

    private void setCurrentPosition(int currentPosition) {
        this.currentPosition = currentPosition;
        this.currentCharPosition = currentPosition > 0 ? RegexUtil.charOffsetByByteOffset(this.myStringBytes, currentPosition) : currentPosition;
    }

    public int getCurrentCharPosition() {
        return this.currentCharPosition;
    }

    public MatchData getCurrentMatchData() {
        return MatchData.fromRegion(this.myString, this.myMatcher.getEagerRegion());
    }
}

