/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public final class StripeButtonUI
extends MetalToggleButtonUI {
    private final Rectangle myIconRect = new Rectangle();
    private final Rectangle myTextRect = new Rectangle();
    private final Rectangle myViewRect = new Rectangle();
    private Insets ourViewInsets = JBUI.emptyInsets();
    private static final Color BACKGROUND_COLOR = JBColor.namedColor((String)"ToolWindow.Button.hoverBackground", (Color)new JBColor(Gray.x55.withAlpha(40), Gray.x0F.withAlpha(40)));
    private static final Color SELECTED_BACKGROUND_COLOR = JBColor.namedColor((String)"ToolWindow.Button.selectedBackground", (Color)new JBColor(Gray.x55.withAlpha(85), Gray.x0F.withAlpha(85)));
    private static final Color SELECTED_FOREGROUND_COLOR = JBColor.namedColor((String)"ToolWindow.Button.selectedForeground", (Color)new JBColor((Color)Gray.x00, (Color)Gray.xFF));

    public static ComponentUI createUI(JComponent c) {
        return new StripeButtonUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AnchoredButton button = (AnchoredButton)c;
        Dimension dim = super.getPreferredSize(button);
        dim.width = (int)((float)JBUI.scale((int)4) + (float)dim.width * 1.1f);
        dim.height += JBUI.scale((int)2);
        ToolWindowAnchor anchor2 = button.getAnchor();
        if (ToolWindowAnchor.LEFT == anchor2 || ToolWindowAnchor.RIGHT == anchor2) {
            return new Dimension(dim.height, dim.width);
        }
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Graphics g, JComponent c) {
        Icon icon;
        AnchoredButton button = (AnchoredButton)c;
        String text = button.getText();
        Icon icon2 = icon = button.isEnabled() ? button.getIcon() : button.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = button.getFontMetrics(button.getFont());
        this.ourViewInsets = c.getInsets(this.ourViewInsets);
        this.myViewRect.x = this.ourViewInsets.left;
        this.myViewRect.y = this.ourViewInsets.top;
        ToolWindowAnchor anchor2 = button.getAnchor();
        if (ToolWindowAnchor.RIGHT == anchor2 || ToolWindowAnchor.LEFT == anchor2) {
            this.myViewRect.height = c.getWidth() - (this.ourViewInsets.left + this.ourViewInsets.right);
            this.myViewRect.width = c.getHeight() - (this.ourViewInsets.top + this.ourViewInsets.bottom);
        } else {
            this.myViewRect.height = c.getHeight() - (this.ourViewInsets.left + this.ourViewInsets.right);
            this.myViewRect.width = c.getWidth() - (this.ourViewInsets.top + this.ourViewInsets.bottom);
        }
        this.myIconRect.height = 0;
        this.myIconRect.width = 0;
        this.myIconRect.y = 0;
        this.myIconRect.x = 0;
        this.myTextRect.height = 0;
        this.myTextRect.width = 0;
        this.myTextRect.y = 0;
        this.myTextRect.x = 0;
        String clippedText = SwingUtilities.layoutCompoundLabel(c, fm, text, icon, button.getVerticalAlignment(), button.getHorizontalAlignment(), button.getVerticalTextPosition(), button.getHorizontalTextPosition(), this.myViewRect, this.myIconRect, this.myTextRect, button.getText() == null ? 0 : button.getIconTextGap());
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            ButtonModel model = button.getModel();
            int off = JBUI.scale((int)1);
            this.myIconRect.x -= JBUI.scale((int)2);
            this.myTextRect.x -= JBUI.scale((int)2);
            if (model.isArmed() && model.isPressed() || model.isSelected() || model.isRollover()) {
                if (anchor2 == ToolWindowAnchor.LEFT) {
                    g2.translate(-off, 0);
                }
                if (anchor2.isHorizontal()) {
                    g2.translate(0, -off);
                }
                g2.setColor(model.isSelected() ? SELECTED_BACKGROUND_COLOR : BACKGROUND_COLOR);
                g2.fillRect(0, 0, button.getWidth(), button.getHeight());
                if (anchor2 == ToolWindowAnchor.LEFT) {
                    g2.translate(off, 0);
                }
                if (anchor2.isHorizontal()) {
                    g2.translate(0, off);
                }
            }
            if (ToolWindowAnchor.RIGHT == anchor2 || ToolWindowAnchor.LEFT == anchor2) {
                if (ToolWindowAnchor.RIGHT == anchor2) {
                    if (icon != null) {
                        icon.paintIcon(c, g2, this.myIconRect.y, this.myIconRect.x);
                    }
                    g2.rotate(1.5707963267948966);
                    g2.translate(0, -c.getWidth());
                } else {
                    if (icon != null) {
                        icon.paintIcon(c, g2, this.myIconRect.y, c.getHeight() - this.myIconRect.x - icon.getIconHeight());
                    }
                    g2.rotate(-1.5707963267948966);
                    g2.translate(-c.getHeight(), 0);
                }
            } else if (icon != null) {
                icon.paintIcon(c, g2, this.myIconRect.x, this.myIconRect.y);
            }
            UISettings.setupAntialiasing((Graphics)g2);
            if (text != null) {
                if (model.isEnabled()) {
                    g2.setColor(model.isSelected() ? SELECTED_FOREGROUND_COLOR : c.getForeground());
                } else {
                    g2.setColor(this.getDisabledTextColor());
                }
                BasicGraphicsUtils.drawString(g2, clippedText, button.getMnemonic2(), this.myTextRect.x, this.myTextRect.y + fm.getAscent());
            }
        }
        finally {
            g2.dispose();
        }
    }
}

