/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.util.Alarm;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.plugins.remotesdk.RemoteSdkCredentialsProducerImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.remote.RemoteRubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.remote.RubyCreateRemoteInterpreterDialog;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkConfigurator;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkTransfer;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class RubyRemoteInterpreterManagerImpl
extends RubyRemoteInterpreterManager {
    private static final Logger LOG = Logger.getInstance(RubyRemoteInterpreterManagerImpl.class);
    private final MergingUpdateQueue myTaskQueue = new MergingUpdateQueue("Updating remote sdk", 500, true, null, (Disposable)ApplicationManager.getApplication(), null, Alarm.ThreadToUse.POOLED_THREAD);

    private RubyRemoteInterpreterManagerImpl() {
    }

    public Sdk addRemoteSdk(@Nullable Project project, @NotNull Collection<Sdk> existingSdks, @NotNull SdkType[] sdkTypes) {
        RubyCreateRemoteInterpreterDialog dialog;
        if (existingSdks == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(0);
        }
        if (sdkTypes == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(1);
        }
        return (dialog = new RubyCreateRemoteInterpreterDialog(project, existingSdks, sdkTypes)).showAndGet() ? dialog.getSdk() : null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isRemoteSdk(@Nullable String interpreterPath) {
        return RemoteSdkCredentialsHolder.isRemoteSdk((String)interpreterPath);
    }

    private static void prepareSdkRoots(@NotNull RubyRemoteSdkAdditionalData data) {
        if (data == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (data == null) {
                RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(19);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (data == null) {
                    RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(20);
                }
                PathMappingSettings mappingSettings = data.getPathMappings();
                for (PathMappingSettings.PathMapping pm : mappingSettings.getPathMappings()) {
                    try {
                        VfsUtil.createDirectories((String)pm.getLocalRoot());
                    }
                    catch (IOException iOException) {}
                }
            });
        });
    }

    public void updateGemsCopy(final @NotNull Sdk sdk, final @Nullable Module module, boolean asynchronous) {
        if (sdk == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(3);
        }
        if (!this.isRemoteSdk(sdk)) {
            return;
        }
        RubySdkAdditionalData data = RubySdkUtil.getRubySdkAdditionalData((Sdk)sdk);
        assert (data instanceof RubyRemoteSdkAdditionalData);
        final RubyRemoteSdkAdditionalData remoteData = (RubyRemoteSdkAdditionalData)data;
        RubyRemoteInterpreterManagerImpl.prepareSdkRoots(remoteData);
        final String progressTitle = RBundle.message((String)"downloading.gems.title");
        if (!asynchronous) {
            ProgressIndicatorBase indicator = new ProgressIndicatorBase();
            indicator.setText(progressTitle);
            ProgressManager.getInstance().executeProcessUnderProgress(() -> this.lambda$updateGemsCopy$2(sdk, remoteData, module, (ProgressIndicator)indicator), (ProgressIndicator)indicator);
            return;
        }
        this.myTaskQueue.queue(new Update(sdk){

            public void run() {
                PerformInBackgroundOption option = new PerformInBackgroundOption(){

                    public boolean shouldStartInBackground() {
                        return true;
                    }
                };
                Ref indicatorRef = new Ref();
                ApplicationManager.getApplication().invokeAndWait(() -> indicatorRef.set((Object)new BackgroundableProcessIndicator(null, progressTitle, option, "Cancel", null, true)), ModalityState.any());
                ProgressManager.getInstance().runProcess(() -> {
                    if (sdk == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    RubyRemoteInterpreterManagerImpl.this.doUpdateGemsCopy(sdk, remoteData, module, (ProgressIndicator)indicatorRef.get());
                }, (ProgressIndicator)indicatorRef.get());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/plugins/ruby/remote/RubyRemoteInterpreterManagerImpl$1", "lambda$run$1"));
            }
        });
    }

    public void updateHelpers(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(4);
        }
        if (!this.isRemoteSdk(sdk)) {
            return;
        }
        RubySdkAdditionalData data = RubySdkUtil.getRubySdkAdditionalData((Sdk)sdk);
        assert (data instanceof RubyRemoteSdkAdditionalData);
        RubyRemoteSdkAdditionalData remoteData = (RubyRemoteSdkAdditionalData)data;
        try {
            LOG.info("Uploading helpers for " + sdk + " at " + Thread.currentThread());
            this.getRemoteTransfer(null, remoteData).uploadHelpers();
            LOG.info("Helpers uploaded for " + sdk + " at " + Thread.currentThread());
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public RemoteSdkCredentialsProducer<RemoteSdkCredentials> getRemoteSdkCredentialsProducer(@NotNull Function<RemoteCredentials, RemoteSdkCredentials> credentialsTransformer, @NotNull RemoteConnectionCredentialsWrapper connectionWrapper) {
        if (credentialsTransformer == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(5);
        }
        if (connectionWrapper == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(6);
        }
        RemoteSdkCredentialsProducerImpl remoteSdkCredentialsProducerImpl = new RemoteSdkCredentialsProducerImpl(credentialsTransformer, connectionWrapper, Registry.is((String)"rubymine.use.vagrant.credential.cache", (boolean)true));
        if (remoteSdkCredentialsProducerImpl == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(7);
        }
        return remoteSdkCredentialsProducerImpl;
    }

    @NotNull
    public RubyRunner getRunner(@NotNull RubyRemoteSdkAdditionalData data, @Nullable Module module) {
        if (data == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(8);
        }
        RubyAbstractRunner rubyAbstractRunner = RubySdkConfigurator.from((SdkAdditionalData)data).buildRunner((RubySdkAdditionalData)data, module);
        if (rubyAbstractRunner == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(9);
        }
        return rubyAbstractRunner;
    }

    @NotNull
    public RubyRemoteSdkTransfer getRemoteTransfer(@Nullable Project project, @NotNull RubyRemoteSdkAdditionalData sdkAdditionalData) throws ExecutionException, InterruptedException {
        if (sdkAdditionalData == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(10);
        }
        RubySdkConfigurator configurator = RubySdkConfigurator.from((SdkAdditionalData)sdkAdditionalData);
        assert (configurator instanceof RubyRemoteSdkConfigurator) : "Got " + configurator + " instead of remote configurator ";
        RubyRemoteSdkTransfer rubyRemoteSdkTransfer = ((RubyRemoteSdkConfigurator)configurator).buildRemoteTransfer(project, sdkAdditionalData);
        if (rubyRemoteSdkTransfer == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(11);
        }
        return rubyRemoteSdkTransfer;
    }

    @NotNull
    public RubySdkSystemAccessor getRubySdkSystemAccessor(@NotNull RubyRemoteSdkAdditionalData data) {
        if (data == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(12);
        }
        RemoteRubySdkSystemAccessor remoteRubySdkSystemAccessor = new RemoteRubySdkSystemAccessor(data);
        if (remoteRubySdkSystemAccessor == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(13);
        }
        return remoteRubySdkSystemAccessor;
    }

    private void doUpdateGemsCopy(@NotNull Sdk sdk, @NotNull RubyRemoteSdkAdditionalData remoteData, @Nullable Module module, @NotNull ProgressIndicator indicator) {
        if (sdk == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(14);
        }
        if (remoteData == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(16);
        }
        LOG.info("Updating gems for " + sdk);
        try {
            this.getRemoteTransfer(null, remoteData).updateLocalGemsCopy(sdk, RubyRemoteInterpreterManagerImpl.getMappingsToCopy(remoteData, module), indicator);
            GemManager.getInstance().refresh(sdk);
            LOG.info("Gems for " + sdk + " updated");
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ProcessCanceledException e) {
            LOG.warn("Gems copying has been canceled");
        }
        catch (Exception e) {
            LOG.error("Can't copy gems", (Throwable)e);
        }
    }

    private static List<PathMappingSettings.PathMapping> getMappingsToCopy(@NotNull RubyRemoteSdkAdditionalData remoteData, @Nullable Module module) {
        if (remoteData == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(17);
        }
        List gemMappings = remoteData.getGemsMappings().getPathMappings();
        if (module == null) {
            return gemMappings;
        }
        String lockFilePath = BundlerUtil.getLockFilePath((Module)module);
        PathMappingSettings projectMappings = remoteData.getRunnerMappings(module);
        if (lockFilePath == null || !projectMappings.canReplaceLocal(lockFilePath)) {
            return gemMappings;
        }
        ArrayList mappings = Lists.newArrayList((Iterable)gemMappings);
        mappings.add(new PathMappingSettings.PathMapping(lockFilePath, projectMappings.convertToRemote(lockFilePath)));
        return mappings;
    }

    private /* synthetic */ void lambda$updateGemsCopy$2(@NotNull Sdk sdk, RubyRemoteSdkAdditionalData remoteData, @Nullable Module module, ProgressIndicator indicator) {
        if (sdk == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(18);
        }
        this.doUpdateGemsCopy(sdk, remoteData, module, indicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypes";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsTransformer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionWrapper";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/remote/RubyRemoteInterpreterManagerImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteData";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/RubyRemoteInterpreterManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkCredentialsProducer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteTransfer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubySdkSystemAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRemoteSdk";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareSdkRoots";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateGemsCopy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateHelpers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkCredentialsProducer";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRunner";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteTransfer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRubySdkSystemAccessor";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateGemsCopy";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsToCopy";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateGemsCopy$2";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareSdkRoots$1";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

