/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.WeakInterner;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectPath {
    private static final WeakInterner<ObjectPath> ourInterner = new WeakInterner();
    public final ObjectPath parent;
    public final ObjectKind kind;
    public final String name;

    private ObjectPath(@NotNull String name, @NotNull ObjectKind kind, @Nullable ObjectPath parent) {
        if (name == null) {
            ObjectPath.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(1);
        }
        this.name = name;
        this.kind = kind;
        this.parent = parent;
    }

    public boolean isQuoted() {
        return true;
    }

    @Nullable
    public String getIdentity() {
        return null;
    }

    @NotNull
    public ObjectPath append(@NotNull String name, @NotNull ObjectKind kind) {
        if (name == null) {
            ObjectPath.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(3);
        }
        ObjectPath objectPath = ObjectPath.create(name, kind, true, null, this);
        if (objectPath == null) {
            ObjectPath.$$$reportNull$$$0(4);
        }
        return objectPath;
    }

    public ObjectPath append(@NotNull String name, @NotNull ObjectKind kind, boolean quoted, String identity) {
        if (name == null) {
            ObjectPath.$$$reportNull$$$0(5);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(6);
        }
        return ObjectPath.create(name, kind, quoted, identity, this);
    }

    public int getSize() {
        int result = 0;
        ObjectPath p = this;
        while (p != null) {
            ++result;
            p = p.parent;
        }
        return result;
    }

    @Nullable
    public ObjectPath getParent(int steps) {
        ObjectPath result = this;
        for (int i = steps; i > 0 && result != null; --i) {
            result = result.parent;
        }
        return result;
    }

    @Nullable
    public ObjectPath findParent(ObjectKind kind, boolean strict) {
        ObjectPath p;
        ObjectPath objectPath = p = strict ? this.parent : this;
        while (p != null) {
            if (p.kind == kind) {
                return p;
            }
            p = p.parent;
        }
        return null;
    }

    public boolean isAncestorOf(@Nullable ObjectPath child, boolean strict) {
        if (strict && this == child) {
            return false;
        }
        while (child != null && child != this) {
            child = child.parent;
        }
        return this == child;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.reduce(new StringBuilder(), (sb, p) -> (sb.length() > 0 && p.name.length() > 0 ? sb.append(".") : sb).append(p.name)).toString();
        if (string == null) {
            ObjectPath.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            ObjectPath.$$$reportNull$$$0(8);
        }
        return string;
    }

    public <T> T reduce(T t, @NotNull PairFunction<T, ObjectPath, T> reducer) {
        if (reducer == null) {
            ObjectPath.$$$reportNull$$$0(9);
        }
        T result = t;
        if (this.parent != null) {
            result = this.parent.reduce(t, reducer);
        }
        return (T)reducer.fun(result, (Object)this);
    }

    @NotNull
    public static ObjectPath create(@NotNull String name, @NotNull ObjectKind kind) {
        if (name == null) {
            ObjectPath.$$$reportNull$$$0(10);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(11);
        }
        ObjectPath objectPath = ObjectPath.create(name, kind, true, null, null);
        if (objectPath == null) {
            ObjectPath.$$$reportNull$$$0(12);
        }
        return objectPath;
    }

    public static ObjectPath create(@NotNull String name, @NotNull ObjectKind kind, boolean quoted, @Nullable String identity, @Nullable ObjectPath parent) {
        if (name == null) {
            ObjectPath.$$$reportNull$$$0(13);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(14);
        }
        return (ObjectPath)ourInterner.intern((Object)ObjectPath.createInner(name, kind, quoted, identity, parent));
    }

    @NotNull
    private static ObjectPath createInner(@NotNull String name, @NotNull ObjectKind kind, final boolean quoted, final @Nullable String identity, @Nullable ObjectPath parent) {
        if (name == null) {
            ObjectPath.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(16);
        }
        if (quoted && identity == null) {
            ObjectPath objectPath = new ObjectPath(name, kind, parent);
            if (objectPath == null) {
                ObjectPath.$$$reportNull$$$0(17);
            }
            return objectPath;
        }
        if (identity == null) {
            ObjectPath objectPath = new ObjectPath(name, kind, parent){

                @Override
                public boolean isQuoted() {
                    return false;
                }
            };
            if (objectPath == null) {
                ObjectPath.$$$reportNull$$$0(18);
            }
            return objectPath;
        }
        if (quoted) {
            new ObjectPath(name, kind, parent){

                @Override
                public String getIdentity() {
                    return identity;
                }
            };
        }
        ObjectPath objectPath = new ObjectPath(name, kind, parent){

            @Override
            public boolean isQuoted() {
                return quoted;
            }

            @Override
            public String getIdentity() {
                return identity;
            }
        };
        if (objectPath == null) {
            ObjectPath.$$$reportNull$$$0(19);
        }
        return objectPath;
    }

    @NotNull
    public static ObjectPath create(@NotNull ObjectKind kind, @NotNull Iterable<String> names) {
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(20);
        }
        if (names == null) {
            ObjectPath.$$$reportNull$$$0(21);
        }
        ObjectPath result = null;
        Iterator<String> it = names.iterator();
        while (it.hasNext()) {
            result = ObjectPath.create(it.next(), !it.hasNext() ? kind : ObjectKind.NONE, true, null, result);
        }
        ObjectPath objectPath = (ObjectPath)ObjectUtils.notNull(result);
        if (objectPath == null) {
            ObjectPath.$$$reportNull$$$0(22);
        }
        return objectPath;
    }

    public <T extends Throwable> void forEach(@NotNull ThrowableConsumer<ObjectPath, T> r) throws T {
        if (r == null) {
            ObjectPath.$$$reportNull$$$0(23);
        }
        ObjectPath.forEachInner(this, r);
    }

    private static <T extends Throwable> void forEachInner(@NotNull ObjectPath p, @NotNull ThrowableConsumer<ObjectPath, T> r) throws T {
        if (p == null) {
            ObjectPath.$$$reportNull$$$0(24);
        }
        if (r == null) {
            ObjectPath.$$$reportNull$$$0(25);
        }
        if (p.parent != null) {
            ObjectPath.forEachInner(p.parent, r);
        }
        r.consume((Object)p);
    }

    public String toString() {
        String id = this.getIdentity();
        return (this.parent != null ? this.parent + "/" : "") + (this.kind == ObjectKind.NONE ? "" : this.kind.name() + ":") + this.name + (id == null ? "" : "@" + id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectPath path = (ObjectPath)o;
        if (this.parent != path.parent) {
            return false;
        }
        if (!this.kind.equals(path.kind)) {
            return false;
        }
        if (!this.name.equals(path.name)) {
            return false;
        }
        if (!Comparing.equal((Object)this.isQuoted(), (Object)path.isQuoted())) {
            return false;
        }
        return Comparing.equal((String)this.getIdentity(), (String)path.getIdentity());
    }

    public int hashCode() {
        int result = System.identityHashCode(this.parent);
        result = 31 * result + this.kind.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Boolean.hashCode(this.isQuoted());
        result = 31 * result + Comparing.hashcode((Object)this.getIdentity());
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/ObjectPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reducer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/ObjectPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createInner";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "forEachInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

