/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim;

import com.intellij.embedding.EmbeddingUtil;
import com.intellij.embedding.TemplateMasqueradingLexer;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyLexer;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.slim.psi.EmbeddedSlimElementType;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;

public class RubySlimLexer
extends TemplateMasqueradingLexer {
    private static final Pattern CODE_START_MARKER_PREFIX = Pattern.compile("((-)|(=[=']?<?>?)).*", 32);

    public RubySlimLexer(Lexer rubyLexer) {
        super((Lexer)new MySlimRubyLexer(0, rubyLexer));
    }

    public RubySlimLexer(ASTNode node) {
        super((Lexer)new MySlimRubyLexer(EmbeddingUtil.calcBaseIndent((ASTNode)node), (Lexer)new RubyLexer(LanguageLevel.DEFAULT)));
    }

    @Nullable
    public IElementType getMasqueTokenType() {
        IElementType type = this.getTokenType();
        if (type == MINUS_TYPE) {
            return null;
        }
        if (type == SlimTokenTypes.WHITESPACE) {
            return RubyTokenTypes.tEOL;
        }
        if (type == EmbeddedSlimElementType.INSTANCE) {
            return RubyTokenTypes.tSEMICOLON;
        }
        return type;
    }

    @Nullable
    public String getMasqueTokenText() {
        IElementType type = this.getTokenType();
        if (type == MINUS_TYPE) {
            return null;
        }
        if (type == SlimTokenTypes.WHITESPACE) {
            return "\n";
        }
        if (type == EmbeddedSlimElementType.INSTANCE) {
            return ";";
        }
        return this.myDelegate.getTokenText();
    }

    private static class MySlimRubyLexer
    extends TemplateMasqueradingLexer.MyLexer {
        MySlimRubyLexer(int indent, Lexer delegateLexer) {
            super(indent, delegateLexer);
        }

        protected int getDelegateState(int state) {
            return 0;
        }

        protected IElementType getIndentTokenType() {
            return SlimTokenTypes.WHITESPACE;
        }

        protected IElementType getEmbeddedContentTokenType() {
            return EmbeddedSlimElementType.INSTANCE;
        }

        protected int getEmbeddedCodeStartMarkerLength() {
            int prefixLength = Math.min(this.myBuffer.length(), this.myTokenStart + CODE_START_MARKER_PREFIX.pattern().length());
            String prefix = this.myBuffer.subSequence(this.myTokenStart, prefixLength).toString();
            Matcher m = CODE_START_MARKER_PREFIX.matcher(prefix);
            if (m.matches()) {
                return m.group(1).length();
            }
            return 0;
        }

        private static boolean isWhitespace(char c) {
            return c == ' ' || c == '\t';
        }

        private boolean isIndentBeforeEmbeddedCode() {
            if (this.myTokenStart > 0 && this.myBuffer.charAt(this.myTokenStart - 1) == '\n') {
                int indent;
                int i;
                for (i = this.myTokenStart; i < this.myBuffer.length() && MySlimRubyLexer.isWhitespace(this.myBuffer.charAt(i)); ++i) {
                }
                if (i > this.myTokenStart && i < this.myBuffer.length() && (indent = i - this.myTokenStart) > this.myIndent) {
                    return true;
                }
            }
            return false;
        }

        public void advance() {
            if (this.myState == 1) {
                this.myDelegate.advance();
                if (this.myDelegate.getTokenType() == null) {
                    this.myState = 0;
                    this.myTokenEnd = this.myDelegate.getBufferEnd();
                    this.advance();
                }
            } else {
                if (this.myTokenEnd == this.myEndOffset) {
                    this.myState = 3;
                    return;
                }
                this.myTokenStart = this.myTokenEnd;
                if (this.isIndentBeforeEmbeddedCode()) {
                    this.myTokenType = this.getEmbeddedContentTokenType();
                    this.myTokenEnd = this.findEndByIndent(this.myTokenStart + 1);
                    return;
                }
                if (StringUtil.isWhiteSpace((char)this.myBuffer.charAt(this.myTokenStart))) {
                    this.myTokenType = this.getIndentTokenType();
                    this.myTokenEnd = this.findNonWhitespace(this.myTokenStart);
                    return;
                }
                int embeddedCodeStartMarkerLength = this.getEmbeddedCodeStartMarkerLength();
                if (embeddedCodeStartMarkerLength > 0) {
                    this.myTokenType = TemplateMasqueradingLexer.MINUS_TYPE;
                    this.myTokenEnd = this.myTokenStart + embeddedCodeStartMarkerLength;
                } else {
                    this.myTokenEnd = this.findEolForRubyCode(this.myTokenStart);
                    this.myDelegate.start(this.myBuffer, this.myTokenStart, this.myTokenEnd, this.getDelegateState(this.myDelegate.getState()));
                    this.myState = 1;
                }
            }
        }

        protected int findNonWhitespace(int offset) {
            int initialOffset = offset;
            while (offset < this.myEndOffset && StringUtil.isWhiteSpace((char)this.myBuffer.charAt(offset))) {
                ++offset;
            }
            if (offset < this.myEndOffset) {
                int i;
                for (i = offset - 1; i >= initialOffset && this.myBuffer.charAt(i) != '\n'; --i) {
                }
                if (i >= initialOffset) {
                    offset = i + 1;
                }
            }
            return offset;
        }

        protected int findEolForRubyCode(int offset) {
            while (offset < this.myEndOffset) {
                if (this.myBuffer.charAt(offset) == '\n' && offset > 0 && this.myBuffer.charAt(offset - 1) != '\\') {
                    int i;
                    for (i = offset - 1; i >= 0 && StringUtil.isWhiteSpace((char)this.myBuffer.charAt(i)); --i) {
                    }
                    if (this.myBuffer.charAt(i) != ',') {
                        return offset;
                    }
                }
                ++offset;
            }
            return offset;
        }
    }
}

