/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.locales;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.indexes.I18nTranslationKeysIndex;
import org.jetbrains.plugins.ruby.i18n.indexes.I18nYAMLPossibleLocaleIndex;
import org.jetbrains.plugins.ruby.i18n.indexes.I18nYAMLTranslationIndex;
import org.jetbrains.plugins.ruby.i18n.locales.YamlKeyFakePsiElement;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLValue;

public class I18nYAMLAdapter {
    @NotNull
    private final YAMLFile myYamlFile;
    @NotNull
    private final String myLocaleName;

    public I18nYAMLAdapter(@NotNull YAMLFile yamlFile) {
        if (yamlFile == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(0);
        }
        this.myYamlFile = yamlFile;
        this.myLocaleName = (String)ReadAction.compute(() -> this.calculateLocale());
    }

    @NotNull
    public PsiFile getPsiFile() {
        YAMLFile yAMLFile = this.myYamlFile;
        if (yAMLFile == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(1);
        }
        return yAMLFile;
    }

    @NotNull
    public String getLocale() {
        String string = this.myLocaleName;
        if (string == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private String calculateLocale() {
        String withoutExtension = this.myYamlFile.getVirtualFile().getNameWithoutExtension();
        List result = FileBasedIndex.getInstance().getValues(I18nYAMLPossibleLocaleIndex.KEY, (Object)SingleEntryFileBasedIndexExtension.getFileKey((VirtualFile)this.myYamlFile.getVirtualFile()), GlobalSearchScope.fileScope((PsiFile)this.myYamlFile));
        if (result.size() != 1) {
            Logger.getInstance(I18nYAMLAdapter.class).error("There should be only one list of locations in " + this.myYamlFile.getVirtualFile().getPath() + " but the index has " + result.size());
            String string = withoutExtension;
            if (string == null) {
                I18nYAMLAdapter.$$$reportNull$$$0(3);
            }
            return string;
        }
        List localesFromThisFile = (List)result.get(0);
        String string = localesFromThisFile.size() == 1 ? (String)localesFromThisFile.get(0) : withoutExtension;
        if (string == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public PsiElement getRecord(@NotNull String k) {
        if (k == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(5);
        }
        Object[] fullKey = this.getFullRecordPath(k);
        String thisLocalePath = String.join((CharSequence)".", (CharSequence[])fullKey);
        String keyText = (String)ArrayUtil.getLastElement((Object[])fullKey);
        List translations = FileBasedIndex.getInstance().getValues(I18nYAMLTranslationIndex.KEY, (Object)thisLocalePath, GlobalSearchScope.fileScope((PsiFile)this.myYamlFile));
        return translations.isEmpty() ? null : new YamlKeyFakePsiElement(this.myYamlFile, thisLocalePath, StringUtil.notNullize((String)keyText, (String)k));
    }

    @NotNull
    public List<String> getAllKeys() {
        List result = (List)ReadAction.compute(() -> FileBasedIndex.getInstance().getValues(I18nTranslationKeysIndex.KEY, (Object)SingleEntryFileBasedIndexExtension.getFileKey((VirtualFile)this.myYamlFile.getVirtualFile()), GlobalSearchScope.fileScope((PsiFile)this.myYamlFile)));
        if (result.size() != 1) {
            Logger.getInstance(I18nYAMLAdapter.class).error("There should be only one list of key list in " + this.myYamlFile.getVirtualFile().getPath() + " but the index has " + result.size());
            List<String> list = Collections.emptyList();
            if (list == null) {
                I18nYAMLAdapter.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = (List)result.get(0);
        if (list == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public YAMLKeyValue createI18nRecord(@NotNull String k, @NotNull String text) {
        if (k == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(8);
        }
        if (text == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(9);
        }
        String[] fullKey = this.getFullRecordPath(k);
        String formatedText = StringUtil.wrapWithDoubleQuote((String)text.trim().replaceAll("\\s+", " "));
        YAMLKeyValue record = YAMLUtil.getQualifiedKeyInFile((YAMLFile)this.myYamlFile, (String[])fullKey);
        YAMLFile dummyFile = YAMLElementGenerator.getInstance((Project)this.myYamlFile.getProject()).createDummyYamlWithText(formatedText);
        YAMLValue topLevelValue = ((YAMLDocument)dummyFile.getDocuments().get(0)).getTopLevelValue();
        if (topLevelValue != null && record != null) {
            record.setValue(topLevelValue);
            return record;
        }
        return YAMLUtil.createI18nRecord((YAMLFile)this.myYamlFile, (String[])fullKey, (String)formatedText);
    }

    public static boolean isTranslationElement(@NotNull PsiElement element) {
        if (element == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(10);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (element == null) {
                I18nYAMLAdapter.$$$reportNull$$$0(16);
            }
            if (element instanceof YamlKeyFakePsiElement) {
                return true;
            }
            if (!(element.isValid() && element instanceof YAMLKeyValue && I18nProvider.isLocaleFile((PsiFile)element.getContainingFile()))) {
                return false;
            }
            return I18nYAMLAdapter.getTranslation(element) != null;
        });
    }

    @Nullable
    @Contract(value="null -> null")
    public static String getTranslation(@Nullable PsiElement element) {
        PsiFile file;
        String path;
        if (element instanceof YAMLKeyValue) {
            YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
            path = YAMLUtil.getConfigFullName((YAMLPsiElement)yamlKeyValue);
            file = yamlKeyValue.getContainingFile();
        } else if (element instanceof YamlKeyFakePsiElement) {
            YamlKeyFakePsiElement fake = (YamlKeyFakePsiElement)element;
            path = fake.getFullKeyPath();
            file = fake.getYamlFile();
        } else {
            return null;
        }
        List translations = (List)ReadAction.compute(() -> FileBasedIndex.getInstance().getValues(I18nYAMLTranslationIndex.KEY, (Object)path, GlobalSearchScope.fileScope((PsiFile)file)));
        return translations.isEmpty() ? null : (String)translations.get(0);
    }

    @NotNull
    public static String getI18nKeyPath(@NotNull PsiElement element) {
        String fullPath;
        if (element == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(11);
        }
        if (element instanceof YAMLKeyValue) {
            YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
            fullPath = YAMLUtil.getConfigFullName((YAMLPsiElement)yamlKeyValue);
        } else if (element instanceof YamlKeyFakePsiElement) {
            YamlKeyFakePsiElement fake = (YamlKeyFakePsiElement)element;
            fullPath = fake.getFullKeyPath();
        } else {
            if ("" == null) {
                I18nYAMLAdapter.$$$reportNull$$$0(12);
            }
            return "";
        }
        String string = StringUtil.notNullize((String)StringUtil.substringAfter((String)fullPath, (String)"."));
        if (string == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private String[] getFullRecordPath(@NotNull String keyStr) {
        if (keyStr == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(14);
        }
        Object[] key = keyStr.length() == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : keyStr.split("\\.");
        String[] stringArray = (String[])ArrayUtil.prepend((Object)this.myLocaleName, (Object[])key);
        if (stringArray == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/locales/I18nYAMLAdapter";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/locales/I18nYAMLAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateLocale";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getI18nKeyPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullRecordPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRecord";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createI18nRecord";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTranslationElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getI18nKeyPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFullRecordPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isTranslationElement$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

