/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.introduce.field;

import b.h.la;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RNamespace;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RFieldHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.IntroduceValidator;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.NamesSuggestor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceSettings;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.variable.RubyIntroduceVariableHandler;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementElement;

public class RubyIntroduceFieldHandler
extends RubyIntroduceHandlerBase {
    @NotNull
    public static final String HELP_ID = "refactoring.introduceField";
    private static final long b = la.a(128499466149803654L, -7403009763794462981L, MethodHandles.lookup().lookupClass()).a(132852915520522L);

    @Override
    protected String getHelpId() {
        long l2 = b ^ 0x77CE3877E950L;
        return HELP_ID;
    }

    @Override
    protected String getTitle() {
        long l2 = b ^ 0x3091E634CF72L;
        return RefactoringBundle.message((String)"introduce.field.title");
    }

    @Override
    protected String getFeatureID() {
        long l2 = b ^ 0x5DF90C0D2DE7L;
        return HELP_ID;
    }

    @Override
    protected IntroduceValidator createValidator(PsiElement element, List<PsiElement> occurrences) {
        return new MyValidator(element, occurrences);
    }

    @Override
    protected RPsiElement getSearchScope(PsiElement expression) {
        return RefactoringPsiHelper.getClassOrModuleOrFile(expression);
    }

    @Override
    protected List<String> getSuggestedNames(PsiElement expression, IntroduceValidator validator) {
        long l2 = b ^ 0x17D35C8C70C5L;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : NamesSuggestor.getSuggestedNames(expression)) {
            String string2 = "@" + string;
            String string3 = "@@" + string;
            if (validator.checkPossibleName(string2) == null) {
                arrayList.add(string2);
            }
            if (validator.checkPossibleName(string3) != null) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    @Override
    protected PsiElement insertDeclaration(String name, PsiElement declaration, PsiElement expression, List<PsiElement> occurrences, boolean replaceAll) {
        PsiElement psiElement;
        long l2 = b ^ 0x7564A48F847CL;
        if (name.startsWith("@@")) {
            return RubyIntroduceFieldHandler.insertDeclaration(declaration, expression);
        }
        BiFunction<RCompoundStatement, RCompoundStatement, RCompoundStatement> biFunction = !replaceAll || occurrences.isEmpty() ? RubyIntroduceVariableHandler.STANDARD_BODY_PRODUCER : (!(PsiTreeUtil.getParentOfType((PsiElement)(psiElement = occurrences.get(0)), RFieldHolder.class) instanceof RNamespace) || Context.getContext(psiElement).getAccess() == Access.CLASS ? RubyIntroduceVariableHandler.STANDARD_BODY_PRODUCER : ConstructorSelector.a);
        return RubyIntroduceVariableHandler.insertDeclaration(declaration, expression, occurrences, replaceAll, biFunction);
    }

    @Override
    protected void performAction(Project project, Editor editor, PsiFile file, @Nullable String name, boolean replaceAll, int position) {
        RIdentifier rIdentifier;
        PsiElement psiElement;
        PsiElement psiElement2;
        long l2 = b ^ 0x6AA8A67BB9BEL;
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            psiElement = psiElement2 = file.findElementAt(editor.getCaretModel().getOffset());
        } else {
            rIdentifier = RefactoringPsiHelper.getSelectedElements(editor, file);
            psiElement = (PsiElement)rIdentifier.first;
            psiElement2 = (PsiElement)rIdentifier.second;
        }
        if (psiElement == null || psiElement2 == null || !RubyPsiUtil.isBefore(psiElement, psiElement2) || psiElement.getParent() instanceof RInstanceVariable) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.introduce.selection.error"), (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        if (psiElement == psiElement2 && (rIdentifier = (RIdentifier)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RIdentifier.class)) != null) {
            if (rIdentifier.isMethodParameterDeclaration()) {
                this.a(project, rIdentifier, name, replaceAll);
                return;
            }
            if (rIdentifier.getUseScope() instanceof LocalSearchScope) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                linkedHashSet.add("@" + rIdentifier.getName());
                new VariableInplaceRenamer((PsiNamedElement)rIdentifier, editor).performInplaceRefactoring(linkedHashSet);
                return;
            }
        }
        super.performAction(project, editor, file, name, replaceAll, position);
    }

    @Nullable
    private PsiElement a(Project project, RIdentifier rIdentifier, String string, boolean bl2) {
        RPsiElement rPsiElement = this.getSearchScope((PsiElement)rIdentifier);
        List<PsiElement> list2 = RubyRefactoringUtil.getOccurrences((RPsiElement)rIdentifier, rPsiElement);
        Pair<String, Boolean> pair = this.getParametersForRefactoring(project, (PsiElement)rIdentifier, list2, string, bl2);
        String string2 = (String)pair.first;
        Boolean bl3 = (Boolean)pair.second;
        if (string2 == null || bl3 == null) {
            return null;
        }
        RExpression rExpression = this.createDeclaration(project, new RubyReplacementElement((PsiElement)rIdentifier, (RPsiElement)rIdentifier, this.getSearchScope((PsiElement)rIdentifier)), string2, this.isSplatAllowed());
        Ref ref = new Ref();
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> WriteAction.run(() -> ref.set((Object)RubyIntroduceFieldHandler.a(project, rExpression, rIdentifier, string2, list2, bl3)))), this.getTitle(), null);
        return (PsiElement)ref.get();
    }

    private static PsiElement a(Project project, RExpression rExpression, RIdentifier rIdentifier, String string, List<PsiElement> list2, boolean bl2) {
        PsiElement psiElement;
        RContainer rContainer = rIdentifier.getParentContainer();
        assert (rContainer != null);
        List list3 = rContainer.getStatements();
        if (list3.isEmpty()) {
            psiElement = rContainer.getCompoundStatement().add((PsiElement)rExpression);
        } else {
            RPsiElement rPsiElement = (RPsiElement)list3.get(0);
            psiElement = rPsiElement.getParent().addBefore((PsiElement)rExpression, (PsiElement)rPsiElement);
        }
        if (bl2) {
            for (PsiElement psiElement2 : list2) {
                RefactoringPsiHelper.replaceExpressionWithText(project, psiElement2, string);
            }
        }
        return psiElement;
    }

    private static class ConstructorSelector
    implements BiFunction<RCompoundStatement, RCompoundStatement, RCompoundStatement> {
        private static final ConstructorSelector a;
        private static final long b;

        private ConstructorSelector() {
        }

        @Override
        public RCompoundStatement apply(RCompoundStatement body1, RCompoundStatement body2) {
            RMethod rMethod = RubyPsiUtil.getContainingRMethod((PsiElement)body1);
            RMethod rMethod2 = RubyPsiUtil.getContainingRMethod((PsiElement)body2);
            if (rMethod == null || rMethod2 == null || rMethod == rMethod2) {
                return RubyIntroduceVariableHandler.STANDARD_BODY_PRODUCER.apply(body1, body2);
            }
            if (rMethod.isConstructor()) {
                return rMethod.getCompoundStatement();
            }
            if (rMethod2.isConstructor()) {
                return rMethod2.getCompoundStatement();
            }
            RContainer rContainer = RubyPsiUtil.getContainingRClassOrModule((PsiElement)rMethod);
            if (rContainer instanceof RClass) {
                RPsiStructureElement rPsiStructureElement2 = (RPsiStructureElement)ContainerUtil.find((Iterable)rContainer.getStructureElements(), rPsiStructureElement -> rPsiStructureElement instanceof RMethod && ((RMethod)rPsiStructureElement).isConstructor());
                if (rPsiStructureElement2 == null) {
                    rPsiStructureElement2 = ConstructorSelector.a(rContainer);
                }
                return ((RMethod)rPsiStructureElement2).getCompoundStatement();
            }
            return RubyPsiUtil.isBefore((PsiElement)rMethod, (PsiElement)rMethod2) ? rMethod.getCompoundStatement() : rMethod2.getCompoundStatement();
        }

        @NotNull
        private static RMethod a(RContainer rContainer) {
            long l2 = b ^ 0x53939BA0A2EFL;
            RMethod rMethod = (RMethod)RubyElementFactory.createElementFromText((PsiElement)rContainer, "def initialize\nend");
            Optional<RPsiStructureElement> optional = rContainer.getStructureElements().stream().filter(rPsiStructureElement -> rPsiStructureElement instanceof RMethod).min(Comparator.comparingInt(PsiElement::getTextOffset));
            assert (optional.isPresent());
            RMethod rMethod2 = (RMethod)rContainer.getCompoundStatement().addBefore((PsiElement)rMethod, (PsiElement)optional.get());
            if (rMethod2 == null) {
                ConstructorSelector.a(0);
            }
            return rMethod2;
        }

        static {
            b = la.a(5986719884015004027L, -1008761168535158500L, MethodHandles.lookup().lookupClass()).a(244638310435770L);
            a = new ConstructorSelector();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x2A8821289F0EL;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/field/RubyIntroduceFieldHandler$ConstructorSelector", "generateConstructor"));
        }
    }

    private static class MyValidator
    extends IntroduceValidator {
        private final Symbol b;
        private Set<String> a;
        private static final long c = la.a(-3831494559427362492L, 1058819243203856886L, MethodHandles.lookup().lookupClass()).a(11661389372287L);

        protected MyValidator(PsiElement element, List<PsiElement> occurrences) {
            super(element, occurrences);
            RContainer rContainer = RefactoringPsiHelper.getClassOrModuleOrFile(element);
            this.b = SymbolUtil.getSymbolByContainer((RElementWithFQN)rContainer);
            assert (this.b != null);
        }

        @Override
        public String check(RubyIntroduceSettings settings) {
            Object object;
            long l2 = c ^ 0x7555704B6F92L;
            boolean bl2 = false;
            boolean bl3 = false;
            if (settings.doReplaceAllOccurrences()) {
                for (PsiElement psiElement : this.myOccurrences) {
                    Access access = Context.getContext(psiElement).getAccess();
                    bl2 |= access == Access.INSTANCE;
                    bl3 |= access == Access.CLASS;
                }
            } else {
                object = Context.getContext(this.myElement).getAccess();
                bl2 = object == Access.INSTANCE;
                boolean bl4 = bl3 = object == Access.CLASS;
            }
            if (bl2 && bl3) {
                return RBundle.message((String)"refactoring.introduce.field.context.error");
            }
            object = settings.getName();
            if (bl3 && ((String)object).startsWith("@@")) {
                return RBundle.message((String)"refactoring.introduce.field.class.context.error");
            }
            return this.checkPossibleName((String)object);
        }

        @Override
        public boolean isNameValid(String name) {
            return name != null && TextUtil.isField(name);
        }

        @Override
        public String checkPossibleName(String name) {
            long l2 = c ^ 0x71BDA288DECEL;
            if (this.a == null) {
                this.a = new HashSet<String>();
                SymbolFilter symbolFilter = Types.FIELDS.getFilter();
                SymbolUtil.processMembers(this.b, symbolFilter, this.myElement, (Processor<Symbol>)((Processor)symbol -> {
                    long l2 = c ^ 0x1F5D4F217E66L;
                    String string = (symbol.getType() == Type.CLASS_FIELD ? "@@" : "@") + symbol.getName();
                    this.a.add(string);
                    return true;
                }));
            }
            return this.a.contains(name) ? RBundle.message((String)"refactoring.introduce.field.scope.error") : null;
        }
    }
}

