/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable;

import b.h.la;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.CollectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.FullyQualifiedType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.HashType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.QualifiedType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeKind;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.UnionType;

public class SerializableTypeUtil {
    public static final SerializableType EMPTY;
    public static final SerializableType TRUE;
    public static final SerializableType FALSE;
    public static final SerializableType NIL;
    public static final SerializableType STRING;
    public static final SerializableType BOOLEAN;
    private static final long a;

    private SerializableTypeUtil() {
    }

    @NotNull
    public static SerializableType createFullyQualifiedType(@NotNull String fqn) {
        if (fqn == null) {
            SerializableTypeUtil.a(0);
        }
        FullyQualifiedType fullyQualifiedType = new FullyQualifiedType(fqn);
        if (fullyQualifiedType == null) {
            SerializableTypeUtil.a(1);
        }
        return fullyQualifiedType;
    }

    @NotNull
    public static SerializableType createQualifiedType(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            SerializableTypeUtil.a(2);
        }
        QualifiedType qualifiedType = new QualifiedType(qualifiedName);
        if (qualifiedType == null) {
            SerializableTypeUtil.a(3);
        }
        return qualifiedType;
    }

    @NotNull
    public static SerializableType createUnionType(@NotNull Collection<SerializableType> serializableTypes) {
        if (serializableTypes == null) {
            SerializableTypeUtil.a(4);
        }
        if (serializableTypes.size() == 1) {
            SerializableType serializableType = serializableTypes.iterator().next();
            if (serializableType == null) {
                SerializableTypeUtil.a(5);
            }
            return serializableType;
        }
        UnionType unionType = new UnionType(serializableTypes);
        if (unionType == null) {
            SerializableTypeUtil.a(6);
        }
        return unionType;
    }

    @NotNull
    public static SerializableType createCollectionType(@NotNull SerializableType collectionType, @NotNull SerializableType elementType) {
        if (collectionType == null) {
            SerializableTypeUtil.a(7);
        }
        if (elementType == null) {
            SerializableTypeUtil.a(8);
        }
        if (elementType == EMPTY) {
            SerializableType serializableType = collectionType;
            if (serializableType == null) {
                SerializableTypeUtil.a(9);
            }
            return serializableType;
        }
        CollectionType collectionType2 = new CollectionType(collectionType, elementType);
        if (collectionType2 == null) {
            SerializableTypeUtil.a(10);
        }
        return collectionType2;
    }

    @NotNull
    public static SerializableType createHashType(@NotNull SerializableType hashType, @NotNull SerializableType keyType, @NotNull SerializableType valueType) {
        if (hashType == null) {
            SerializableTypeUtil.a(11);
        }
        if (keyType == null) {
            SerializableTypeUtil.a(12);
        }
        if (valueType == null) {
            SerializableTypeUtil.a(13);
        }
        if (keyType == EMPTY && valueType == EMPTY) {
            SerializableType serializableType = hashType;
            if (serializableType == null) {
                SerializableTypeUtil.a(14);
            }
            return serializableType;
        }
        HashType hashType2 = new HashType(hashType, keyType, valueType);
        if (hashType2 == null) {
            SerializableTypeUtil.a(15);
        }
        return hashType2;
    }

    @NotNull
    public static SerializableType deserialize(@NotNull StubInputStream stubInputStream) throws IOException {
        long l2 = a ^ 0x5DC34C87653BL;
        if (stubInputStream == null) {
            SerializableTypeUtil.a(16);
        }
        SerializableTypeKind serializableTypeKind = SerializableTypeKind.valueOf((int)stubInputStream.readVarInt());
        switch (serializableTypeKind) {
            case FULLY_QUALIFIED: {
                String string = Objects.requireNonNull(stubInputStream.readNameString());
                if (string.isEmpty()) {
                    SerializableType serializableType = EMPTY;
                    if (serializableType == null) {
                        SerializableTypeUtil.a(17);
                    }
                    return serializableType;
                }
                if (string.equals("TrueClass")) {
                    SerializableType serializableType = TRUE;
                    if (serializableType == null) {
                        SerializableTypeUtil.a(18);
                    }
                    return serializableType;
                }
                if (string.equals("FalseClass")) {
                    SerializableType serializableType = FALSE;
                    if (serializableType == null) {
                        SerializableTypeUtil.a(19);
                    }
                    return serializableType;
                }
                if (string.equals("NilClass")) {
                    SerializableType serializableType = NIL;
                    if (serializableType == null) {
                        SerializableTypeUtil.a(20);
                    }
                    return serializableType;
                }
                if (string.equals("String")) {
                    SerializableType serializableType = STRING;
                    if (serializableType == null) {
                        SerializableTypeUtil.a(21);
                    }
                    return serializableType;
                }
                FullyQualifiedType fullyQualifiedType = new FullyQualifiedType(string);
                if (fullyQualifiedType == null) {
                    SerializableTypeUtil.a(22);
                }
                return fullyQualifiedType;
            }
            case QUALIFIED: {
                QualifiedType qualifiedType = new QualifiedType(Objects.requireNonNull(stubInputStream.readNameString()));
                if (qualifiedType == null) {
                    SerializableTypeUtil.a(23);
                }
                return qualifiedType;
            }
            case UNION: {
                int n2 = stubInputStream.readVarInt();
                ArrayList<SerializableType> arrayList = new ArrayList<SerializableType>();
                for (int i10 = 0; i10 < n2; ++i10) {
                    arrayList.add(SerializableTypeUtil.deserialize(stubInputStream));
                }
                UnionType unionType = new UnionType(arrayList);
                if (unionType == null) {
                    SerializableTypeUtil.a(24);
                }
                return unionType;
            }
            case COLLECTION: {
                CollectionType collectionType = new CollectionType(SerializableTypeUtil.deserialize(stubInputStream), SerializableTypeUtil.deserialize(stubInputStream));
                if (collectionType == null) {
                    SerializableTypeUtil.a(25);
                }
                return collectionType;
            }
            case HASH: {
                HashType hashType = new HashType(SerializableTypeUtil.deserialize(stubInputStream), SerializableTypeUtil.deserialize(stubInputStream), SerializableTypeUtil.deserialize(stubInputStream));
                if (hashType == null) {
                    SerializableTypeUtil.a(26);
                }
                return hashType;
            }
        }
        throw new IllegalArgumentException(serializableTypeKind.toString());
    }

    public static void serialize(@NotNull StubOutputStream stream2, @NotNull SerializableType type) throws IOException {
        if (stream2 == null) {
            SerializableTypeUtil.a(27);
        }
        if (type == null) {
            SerializableTypeUtil.a(28);
        }
        stream2.writeVarInt(type.getKind().getOrder());
        switch (type.getKind()) {
            case FULLY_QUALIFIED: {
                stream2.writeName(((FullyQualifiedType)type).getType());
                break;
            }
            case QUALIFIED: {
                stream2.writeName(((QualifiedType)type).getType());
                break;
            }
            case UNION: {
                UnionType unionType = (UnionType)type;
                stream2.writeVarInt(unionType.getTypes().size());
                for (SerializableType serializableType : unionType.getTypes()) {
                    SerializableTypeUtil.serialize(stream2, serializableType);
                }
                break;
            }
            case COLLECTION: {
                CollectionType collectionType = (CollectionType)type;
                SerializableTypeUtil.serialize(stream2, collectionType.getCollectionType());
                SerializableTypeUtil.serialize(stream2, collectionType.getElementType());
                break;
            }
            case HASH: {
                HashType hashType = (HashType)type;
                SerializableTypeUtil.serialize(stream2, hashType.getHashType());
                SerializableTypeUtil.serialize(stream2, hashType.getKeyType());
                SerializableTypeUtil.serialize(stream2, hashType.getValueType());
            }
        }
    }

    static {
        a = la.a(-6629344956933569637L, -684354674888993952L, MethodHandles.lookup().lookupClass()).a(277637647865973L);
        long l2 = a ^ 0x5426FAD86FB9L;
        EMPTY = new FullyQualifiedType("");
        TRUE = new FullyQualifiedType("TrueClass");
        FALSE = new FullyQualifiedType("FalseClass");
        NIL = new FullyQualifiedType("NilClass");
        STRING = new FullyQualifiedType("String");
        BOOLEAN = new UnionType(ContainerUtil.list((Object[])new SerializableType[]{TRUE, FALSE}));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x350865BDA699L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/serializable/SerializableTypeUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializableTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubInputStream";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/serializable/SerializableTypeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFullyQualifiedType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnionType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollectionType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashType";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFullyQualifiedType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUnionType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCollectionType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createHashType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

