/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.exception;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RRescueBlock;

public class ExceptionCompletionFilter
implements ElementFilter {
    public static boolean isInRescueExceptionsList(PsiElement element) {
        RRescueBlock rRescueBlock = (RRescueBlock)PsiTreeUtil.getParentOfType((PsiElement)element, RRescueBlock.class);
        if (rRescueBlock == null) {
            return false;
        }
        RPsiElement rPsiElement = rRescueBlock.getException();
        return PsiTreeUtil.isAncestor((PsiElement)rPsiElement, (PsiElement)element, (boolean)false);
    }

    public static boolean isInRescueBody(PsiElement element) {
        RRescueBlock rRescueBlock = (RRescueBlock)PsiTreeUtil.getParentOfType((PsiElement)element, RRescueBlock.class);
        if (rRescueBlock == null) {
            return false;
        }
        RCompoundStatement rCompoundStatement = rRescueBlock.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)rCompoundStatement, (PsiElement)element, (boolean)false) && !(PsiTreeUtil.skipWhitespacesBackward((PsiElement)rCompoundStatement) instanceof PsiErrorElement);
    }

    public static boolean isInRescue(PsiElement element) {
        RRescueBlock rRescueBlock = (RRescueBlock)PsiTreeUtil.getParentOfType((PsiElement)element, RRescueBlock.class);
        return rRescueBlock != null;
    }

    public boolean isAcceptable(Object element, @Nullable PsiElement context) {
        if (!(element instanceof PsiElement)) {
            return false;
        }
        PsiElement psiElement = (PsiElement)element;
        return ExceptionCompletionFilter.isInRescueExceptionsList(psiElement);
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }
}

