/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.migrations;

import b.h.la;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.VersionComparatorUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.ActiveRecordType;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.migrations.MigrationField;
import org.jetbrains.plugins.ruby.rails.migrations.a;
import org.jetbrains.plugins.ruby.ruby.RubyPsiManager;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public class MigrationParser
implements Disposable {
    private static final Logger a;
    public static final String CREATE_TABLE = "create_table";
    private final Object c = new Object();
    private final Module f;
    private VirtualFile g;
    private VirtualFile h;
    private boolean d;
    public static final Pattern MIGRATION_FILE_NAME_WITHOUT_EXT;
    private final Alarm e = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    public static final Topic<MigrationListener> MIGRATIONS_CHANGED_TOPIC;
    private Map<String, TableDefinitionAndFields> b;
    private static final long i;

    public static boolean matchesToMigrationFileNameTemplate(@NotNull VirtualFile file) {
        if (file == null) {
            MigrationParser.a(0);
        }
        return MIGRATION_FILE_NAME_WITHOUT_EXT.matcher(file.getNameWithoutExtension()).matches();
    }

    public static MigrationParser getInstance(Module module) {
        return (MigrationParser)ModuleServiceManager.getService((Module)module, MigrationParser.class);
    }

    public MigrationParser(Module module) {
        this.f = module;
        Disposer.register((Disposable)module, (Disposable)this);
        this.parseAllMigrations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupForNextTest() {
        this.d = false;
        Object object = this.c;
        synchronized (object) {
            this.g = null;
            this.h = null;
        }
        object = this;
        synchronized (object) {
            this.b = null;
        }
    }

    public void dispose() {
        this.h = null;
        this.g = null;
    }

    public void parseAllMigrations() {
        PsiDirectory psiDirectory = this.h();
        if (psiDirectory == null) {
            return;
        }
        this.c((PsiElement)psiDirectory);
        this.d = true;
        this.b();
    }

    private void c(PsiElement psiElement2) {
        RubyPsiManager.getInstance(this.f.getProject()).addChangeWatcher(psiElement2, psiElement -> {
            long l2 = i ^ 0x5E175305C303L;
            boolean bl2 = false;
            if (psiElement instanceof PsiDirectory) {
                bl2 = true;
            } else {
                PsiFile psiFile = psiElement.getContainingFile();
                String string = psiFile.getName();
                if (psiFile instanceof RFile && RubyVirtualFileScanner.isRubyFile(string)) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if ("schema.rb".equals(string) || virtualFile != null && MigrationParser.matchesToMigrationFileNameTemplate(virtualFile)) {
                        bl2 = true;
                    }
                }
            }
            if (bl2) {
                this.g();
            }
        });
    }

    private void g() {
        if (this.e.isDisposed()) {
            return;
        }
        this.e.cancelAllRequests();
        Runnable runnable = () -> {
            this.b();
            ((MigrationListener)this.f.getMessageBus().syncPublisher(MIGRATIONS_CHANGED_TOPIC)).migrationsChanged(this.f);
        };
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.e.addRequest(runnable, 500);
        } else {
            runnable.run();
        }
    }

    private void b() {
        ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile virtualFile;
            PsiDirectory psiDirectory;
            RFile rFile3;
            Object object;
            long l2 = i ^ 0x1ADB3EC7E770L;
            if (this.f.isDisposed()) {
                return;
            }
            Object object2 = this.c;
            synchronized (object2) {
                if (this.g == null || !this.g.isValid()) {
                    this.g = this.a();
                }
                if (this.h == null || !this.h.isValid()) {
                    this.h = this.c();
                }
                object = PsiManager.getInstance((Project)this.f.getProject());
                rFile3 = this.h != null ? (RFile)ObjectUtils.tryCast((Object)object.findFile(this.h), RFile.class) : null;
                psiDirectory = this.g != null ? object.findDirectory(this.g) : null;
            }
            if (rFile3 != null) {
                if (!this.a((PsiElement)rFile3)) {
                    return;
                }
                object2 = MigrationParser.a(rFile3);
            } else {
                object2 = null;
            }
            object = new ArrayList();
            if (psiDirectory != null) {
                for (PsiElement object3 : psiDirectory.getChildren()) {
                    String string;
                    if (!(object3 instanceof RFile)) continue;
                    virtualFile = ((RFile)object3).getVirtualFile();
                    assert (virtualFile != null);
                    if (!MigrationParser.matchesToMigrationFileNameTemplate(virtualFile) || (string = MigrationParser.getMigrationVersion(virtualFile)) == null || object2 != null && VersionComparatorUtil.compare((String)object2, (String)string) >= 0) continue;
                    if (this.a(object3)) {
                        object.add((RFile)object3);
                        continue;
                    }
                    return;
                }
            }
            long l3 = System.currentTimeMillis();
            MigrationParser migrationParser = this;
            synchronized (migrationParser) {
                this.b = new HashMap<String, TableDefinitionAndFields>();
                Collections.sort(object, (rFile, rFile2) -> VersionComparatorUtil.compare((String)rFile.getName(), (String)rFile2.getName()));
                if (object2 != null) {
                    this.d(rFile3);
                }
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    virtualFile = (RFile)iterator.next();
                    this.c((RFile)virtualFile);
                }
            }
            long l4 = System.currentTimeMillis() - l3;
            a.debug("Reparsed " + object.size() + " migration files" + (object2 != null ? " and schema.rb (vers." + (String)object2 + ")" : "") + " in " + l4 + " ms");
        });
    }

    @Nullable
    public static String getMigrationVersion(VirtualFile migrationFile) {
        String string;
        String string2 = migrationFile.getName();
        int n2 = string2.indexOf(95);
        if (n2 > 0 && TextUtil.isInteger(string = string2.substring(0, n2))) {
            return string;
        }
        return null;
    }

    private boolean a(PsiElement psiElement) {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)psiElement.getProject());
        Document document = psiDocumentManager.getCachedDocument((PsiFile)((RFile)psiElement));
        if (document != null && psiDocumentManager.isUncommited(document)) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    psiDocumentManager.commitDocument(document);
                    this.g();
                });
            }
            return false;
        }
        return true;
    }

    private void c(RFile rFile) {
        List list2 = rFile.getStructureElements();
        for (RPsiStructureElement rPsiStructureElement : list2) {
            if (!(rPsiStructureElement instanceof RClass)) continue;
            this.a((RClass)rPsiStructureElement);
        }
    }

    private void d(RFile rFile) {
        RBlockCall rBlockCall = MigrationParser.b(rFile);
        if (rBlockCall != null) {
            this.a(rBlockCall);
        }
    }

    @Nullable
    private static String a(RFile rFile) {
        long l2 = i ^ 0x64723E7E7736L;
        RBlockCall rBlockCall = MigrationParser.b(rFile);
        if (rBlockCall == null) {
            return null;
        }
        RPossibleCall rPossibleCall = rBlockCall.getCall();
        List list2 = rPossibleCall.getArguments();
        for (RPsiElement rPsiElement : list2) {
            RAssoc rAssoc;
            if (!(rPsiElement instanceof RAssoc) || !StringUtil.equals((CharSequence)"version", (CharSequence)(rAssoc = (RAssoc)rPsiElement).getKeyText())) continue;
            RPsiElement rPsiElement2 = rAssoc.getValue();
            if (rPsiElement2 != null) {
                String string = RubyPsiUtil.getElementText((PsiElement)rPsiElement2).replaceAll("_", "");
                if (TextUtil.isInteger(string)) {
                    return string;
                }
                a.warn("Schema version number expected but found: " + string);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static RBlockCall b(RFile rFile) {
        long l2 = i ^ 0x19A1865A16D5L;
        List list2 = rFile.getStructureElements();
        for (RPsiElement rPsiElement : list2) {
            String string;
            RBlockCall rBlockCall;
            if (rPsiElement instanceof RBlockCall) {
                rBlockCall = (RBlockCall)rPsiElement;
            } else {
                if (!(rPsiElement.getParent() instanceof RBlockCall)) continue;
                rBlockCall = (RBlockCall)rPsiElement.getParent();
            }
            if ((string = rBlockCall.getCommand()) == null || !string.endsWith(".define")) continue;
            return rBlockCall;
        }
        return null;
    }

    private void a(RBlockCall rBlockCall) {
        RCodeBlock rCodeBlock = rBlockCall.getBlock();
        new RubyPsiInterpreter(true).interpret((PsiElement)rCodeBlock, new MigrationCallable(null));
    }

    private void a(RClass rClass) {
        long l2 = i ^ 0x524388F7DAD1L;
        List list2 = rClass.getStructureElements();
        RMethod rMethod = null;
        RMethod rMethod2 = null;
        RMethod rMethod3 = null;
        for (RPsiStructureElement rPsiStructureElement : list2) {
            if (!(rPsiStructureElement instanceof RMethod)) continue;
            RMethod rMethod4 = (RMethod)rPsiStructureElement;
            if ("up".equals(rMethod4.getName())) {
                rMethod = rMethod4;
            } else if ("down".equals(rMethod4.getName())) {
                rMethod2 = rMethod4;
            }
            if (!"change".equals(rMethod4.getName())) continue;
            rMethod3 = rMethod4;
        }
        if (rMethod != null && rMethod2 != null) {
            this.a(rMethod);
        } else if (rMethod3 != null) {
            this.a(rMethod3);
        }
    }

    private static void d(RCallArguments rCallArguments) {
        rCallArguments.interpretBlock(new PsiCallable[0]);
    }

    private void a(String string, String string2, RCallArguments rCallArguments) {
        long l2 = i ^ 0x5EF655C254EEL;
        if ("timestamps".equals(string2)) {
            TableDefinitionAndFields tableDefinitionAndFields = this.b.get(string);
            if (tableDefinitionAndFields != null) {
                tableDefinitionAndFields.addField(new MigrationField("created_at", "timestamp", rCallArguments.getRCallElement()));
                tableDefinitionAndFields.addField(new MigrationField("updated_at", "timestamp", rCallArguments.getRCallElement()));
            }
        } else if ("column".equals(string2)) {
            this.b(new ColumnCallParser(rCallArguments, null).withTableName(string));
        } else if (ActiveRecordType.COLUMN_TYPES_SET.contains(string2)) {
            this.b(new ColumnCallParser(rCallArguments, null).withTableName(string).withDataType(string2));
        } else if ("belongs_to".equals(string2) || "references".equals(string2)) {
            RPsiElement rPsiElement;
            for (int i10 = 0; i10 < rCallArguments.getArguments().size() && ((rPsiElement = rCallArguments.getArguments().get(i10)) instanceof RSymbol || rPsiElement instanceof RBaseString); ++i10) {
                TableDefinitionAndFields tableDefinitionAndFields;
                String string3 = rCallArguments.evaluateArgument(i10);
                if (string3 == null || (tableDefinitionAndFields = this.b.get(string)) == null) continue;
                tableDefinitionAndFields.addField(new MigrationField(string3 + "_id", "integer", rCallArguments.getRCallElement()));
                if (rCallArguments.getOptionValue("polymorphic") == null) continue;
                tableDefinitionAndFields.addField(new MigrationField(string3 + "_type", "string", rCallArguments.getRCallElement()));
            }
        }
    }

    private void a(RMethod rMethod) {
        new RubyPsiInterpreter(true).interpret((PsiElement)rMethod, new MigrationCallable(null));
    }

    private void b(RCallArguments rCallArguments) {
        String string = rCallArguments.evaluateArgument(0);
        if (string != null) {
            this.a(string, rCallArguments);
            rCallArguments.interpretBlock(new TableCallable(string, null));
        }
    }

    private void a(String string, @NonNls RCallArguments rCallArguments) {
        long l2 = i ^ 0x7B3005F2A39EL;
        boolean bl2 = "false".equals(rCallArguments.getOptionValue("id"));
        String string2 = rCallArguments.getOptionValue("primary_key", "id");
        if (!this.b.containsKey(string)) {
            TableDefinitionAndFields tableDefinitionAndFields = new TableDefinitionAndFields(rCallArguments.getArguments().get(0));
            if (!bl2) {
                tableDefinitionAndFields.addField(new MigrationField(string2, "integer", rCallArguments.getRCallElement()));
            }
            this.b.put(string, tableDefinitionAndFields);
        }
    }

    private void a(RCallArguments rCallArguments) {
        TableDefinitionAndFields tableDefinitionAndFields;
        String string = rCallArguments.evaluateArgument(0);
        String string2 = rCallArguments.evaluateArgument(1);
        if (string != null && string2 != null && (tableDefinitionAndFields = this.b.get(string)) != null) {
            this.b.remove(string);
            this.b.put(string2, tableDefinitionAndFields);
        }
    }

    private void c(RCallArguments rCallArguments) {
        String string = rCallArguments.evaluateArgument(0);
        if (string != null) {
            rCallArguments.interpretBlock(new ChangeTableCallable(string, null));
        }
    }

    private void b(ColumnCallParser columnCallParser) {
        String string = columnCallParser.getTableName();
        TableDefinitionAndFields tableDefinitionAndFields = this.b.get(string);
        if (tableDefinitionAndFields == null) {
            return;
        }
        String string2 = columnCallParser.a();
        String string3 = columnCallParser.getDataType();
        tableDefinitionAndFields.addField(new MigrationField(string2, string3, columnCallParser.getCall()));
    }

    private void d(ColumnCallParser columnCallParser) {
        String string = columnCallParser.getTableName();
        String string2 = columnCallParser.a();
        String string3 = columnCallParser.a();
        MigrationField migrationField = this.a(string, string2);
        if (migrationField != null) {
            migrationField.setName(string3);
            migrationField.addDeclaration(columnCallParser.getCall());
        }
    }

    private void a(ColumnCallParser columnCallParser) {
        List<MigrationField> list2;
        long l2 = i ^ 0x26E4CAA081E2L;
        String string = columnCallParser.getTableName();
        TableDefinitionAndFields tableDefinitionAndFields = this.b.get(string);
        List<MigrationField> list3 = list2 = tableDefinitionAndFields != null ? tableDefinitionAndFields.getFields() : null;
        if (list2 != null) {
            String string2 = columnCallParser.a();
            while (string2 != null) {
                Iterator<MigrationField> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    MigrationField migrationField = iterator.next();
                    if (!Comparing.equal((String)migrationField.getName(), (String)string2)) continue;
                    iterator.remove();
                    break;
                }
                string2 = columnCallParser.a();
            }
        } else {
            a.info("Could not find list of fields for table " + string);
        }
    }

    private void c(ColumnCallParser columnCallParser) {
        String string = columnCallParser.getTableName();
        String string2 = columnCallParser.a();
        String string3 = columnCallParser.a();
        MigrationField migrationField = this.a(string, string2);
        if (migrationField != null) {
            migrationField.setDataType(string3);
            migrationField.addDeclaration(columnCallParser.getCall());
        }
    }

    @Nullable
    private MigrationField a(String string, String string2) {
        long l2 = i ^ 0x6E8542403EB0L;
        if (string2 == null) {
            return null;
        }
        TableDefinitionAndFields tableDefinitionAndFields = this.b.get(string);
        if (tableDefinitionAndFields != null) {
            return tableDefinitionAndFields.findFieldByName(string2);
        }
        a.info("Could not find list of fields for table " + string);
        return null;
    }

    @Nullable
    public Collection<MigrationField> getFieldsByTableName(String tableName) {
        return MigrationParser.a(tableName, this.e());
    }

    @Nullable
    public PsiElement getTableDef(@NotNull String tableName) {
        if (tableName == null) {
            MigrationParser.a(1);
        }
        return MigrationParser.b(tableName, this.e());
    }

    @Nullable
    private static Collection<MigrationField> a(String string, Map<String, TableDefinitionAndFields> map) {
        if (map == null) {
            return null;
        }
        TableDefinitionAndFields tableDefinitionAndFields = map.get(string);
        if (tableDefinitionAndFields == null) {
            return null;
        }
        return new ArrayList<MigrationField>(tableDefinitionAndFields.getFields());
    }

    @Nullable
    private static PsiElement b(String string, Map<String, TableDefinitionAndFields> map) {
        if (map == null) {
            return null;
        }
        TableDefinitionAndFields tableDefinitionAndFields = map.get(string);
        return tableDefinitionAndFields != null ? tableDefinitionAndFields.getTableDef() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, TableDefinitionAndFields> e() {
        boolean bl2;
        MigrationParser migrationParser = this;
        synchronized (migrationParser) {
            bl2 = this.b == null;
        }
        if (bl2) {
            if (this.d) {
                this.b();
            } else {
                this.parseAllMigrations();
            }
        }
        migrationParser = this;
        synchronized (migrationParser) {
            return this.b;
        }
    }

    public Map<String, TableDefinitionAndFields> getTable2FieldsMap() {
        return this.e();
    }

    @NotNull
    public String[] getAllTables() {
        Map<String, TableDefinitionAndFields> map = this.e();
        if (map == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                MigrationParser.a(2);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Set<String> set = map.keySet();
        String[] stringArray = ArrayUtil.toStringArray(set);
        if (stringArray == null) {
            MigrationParser.a(3);
        }
        return stringArray;
    }

    public boolean containsTable(@Nullable String tableName) {
        if (tableName == null) {
            return false;
        }
        Map<String, TableDefinitionAndFields> map = this.e();
        return map != null && map.keySet().contains(tableName);
    }

    public Map<String, MigrationField> getFieldMap(String tableName) {
        HashMap<String, MigrationField> hashMap = new HashMap<String, MigrationField>();
        if (tableName != null) {
            List<MigrationField> list2;
            TableDefinitionAndFields tableDefinitionAndFields = this.e().get(tableName);
            List<MigrationField> list3 = list2 = tableDefinitionAndFields != null ? tableDefinitionAndFields.getFields() : null;
            if (list2 != null) {
                for (MigrationField migrationField : list2) {
                    hashMap.put(migrationField.getName(), migrationField);
                }
            }
        }
        return hashMap;
    }

    @Nullable
    private VirtualFile a() {
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(this.f);
        if (standardRailsPaths == null) {
            return null;
        }
        String string = standardRailsPaths.getMigrationsRootURL();
        VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string);
        if (virtualFile != null && virtualFile.isDirectory()) {
            return virtualFile;
        }
        return null;
    }

    @Nullable
    private VirtualFile c() {
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(this.f);
        if (standardRailsPaths == null) {
            return null;
        }
        String string = StandardRailsPaths.buildDBSchemaUrl(standardRailsPaths.getRailsApplicationHomeURL());
        VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string);
        if (virtualFile != null && virtualFile.getFileType() == RubyFileType.RUBY) {
            return virtualFile;
        }
        return null;
    }

    @Nullable
    private PsiDirectory h() {
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(this.f);
        if (standardRailsPaths == null) {
            return null;
        }
        String string = StandardRailsPaths.buildDBFolderUrl(standardRailsPaths.getRailsApplicationHomeURL());
        VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string);
        if (virtualFile != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.f.getProject());
            return psiManager.findDirectory(virtualFile);
        }
        return null;
    }

    static {
        i = la.a(-4206810818902039419L, -5439141332684060703L, MethodHandles.lookup().lookupClass()).a(179937170140862L);
        long l2 = i ^ 0x27A5E2F78FBDL;
        a = Logger.getInstance(MigrationParser.class);
        MIGRATION_FILE_NAME_WITHOUT_EXT = Pattern.compile("\\d+_\\w+");
        MIGRATIONS_CHANGED_TOPIC = Topic.create((String)"migrations changed", MigrationListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x4CDB97CA786DL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/migrations/MigrationParser";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/migrations/MigrationParser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTables";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchesToMigrationFileNameTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTableDef";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TableDefinitionAndFields {
        private final List<MigrationField> a;
        private final SmartPsiElementPointer b;
        private static final long c = la.a(8541545364535891495L, -4623895049751234604L, MethodHandles.lookup().lookupClass()).a(241183177619933L);

        public TableDefinitionAndFields(@NotNull RPsiElement createTableCall) {
            if (createTableCall == null) {
                TableDefinitionAndFields.a(0);
            }
            this.a = new ArrayList<MigrationField>();
            this.b = MigrationField.createPointerFor((PsiElement)createTableCall);
        }

        public void addField(@NotNull MigrationField migrationField) {
            if (migrationField == null) {
                TableDefinitionAndFields.a(1);
            }
            this.a.add(migrationField);
        }

        @Nullable
        public MigrationField findFieldByName(@NotNull String name) {
            if (name == null) {
                TableDefinitionAndFields.a(2);
            }
            if (this.a != null) {
                for (MigrationField migrationField : this.a) {
                    if (!name.equals(migrationField.getName())) continue;
                    return migrationField;
                }
            }
            return null;
        }

        @NotNull
        public List<MigrationField> getFields() {
            List<MigrationField> list2 = this.a;
            if (list2 == null) {
                TableDefinitionAndFields.a(3);
            }
            return list2;
        }

        @Nullable
        public PsiElement getTableDef() {
            return this.b.getElement();
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x23999495C8A8L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "createTableCall";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migrationField";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/migrations/MigrationParser$TableDefinitionAndFields";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/migrations/MigrationParser$TableDefinitionAndFields";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFields";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addField";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findFieldByName";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ColumnCallParser {
        private int d = 0;
        private String b;
        private String a;
        private final RCallArguments c;

        private ColumnCallParser(RCallArguments arguments) {
            this.c = arguments;
        }

        ColumnCallParser withTableName(String tableName) {
            this.b = tableName;
            return this;
        }

        ColumnCallParser withDataType(String dataType) {
            this.a = dataType;
            return this;
        }

        public PsiElement getCall() {
            return this.c.getRCallElement();
        }

        @Nullable
        String getTableName() {
            if (this.b != null) {
                return this.b;
            }
            return this.a();
        }

        @Nullable
        String getDataType() {
            if (this.a != null) {
                return this.a;
            }
            return this.a();
        }

        @Nullable
        private String a() {
            return this.c.evaluateArgument(this.d++);
        }

        /* synthetic */ ColumnCallParser(RCallArguments x0, a x1) {
            this(x0);
        }
    }

    private class ChangeTableCallable
    implements PsiCallable {
        private final String a;
        private static final long b = la.a(5062952775435318048L, 2577716015046032071L, MethodHandles.lookup().lookupClass()).a(108587161259393L);

        private ChangeTableCallable(String tableName) {
            this.a = tableName;
        }

        @Override
        public void processCall(RCallArguments arguments) {
            long l2 = b ^ 0xD8DF7C864B6L;
            String string = arguments.getCommand();
            if ("rename".equals(string)) {
                MigrationParser.this.d(new ColumnCallParser(arguments, null).withTableName(this.a));
            } else if ("remove".equals(string)) {
                MigrationParser.this.a(new ColumnCallParser(arguments, null).withTableName(this.a));
            } else if ("change".equals(string)) {
                MigrationParser.this.c(new ColumnCallParser(arguments, null).withTableName(this.a));
            } else {
                MigrationParser.this.a(this.a, string, arguments);
            }
        }

        /* synthetic */ ChangeTableCallable(String x1, a x2) {
            this(x1);
        }
    }

    private class TableCallable
    implements PsiCallable {
        private final String a;

        private TableCallable(String tableName) {
            this.a = tableName;
        }

        @Override
        public void processCall(RCallArguments arguments) {
            String string = arguments.getCommand();
            MigrationParser.this.a(this.a, string, arguments);
        }

        /* synthetic */ TableCallable(String x1, a x2) {
            this(x1);
        }
    }

    private class MigrationCallable
    implements PsiCallable {
        private static final long a = la.a(9166480012542085034L, -8626597954798811610L, MethodHandles.lookup().lookupClass()).a(24049663715510L);

        private MigrationCallable() {
        }

        @Override
        public void processCall(RCallArguments arguments) {
            long l2 = a ^ 0x10FA7078C3C2L;
            String string = arguments.getCommand();
            if (string.equals(MigrationParser.CREATE_TABLE)) {
                MigrationParser.this.b(arguments);
            } else if (string.equals("change_table")) {
                MigrationParser.this.c(arguments);
            } else if (string.equals("rename_table")) {
                MigrationParser.this.a(arguments);
            } else if (string.equals("add_column")) {
                MigrationParser.this.b(new ColumnCallParser(arguments, null));
            } else if (string.equals("rename_column")) {
                MigrationParser.this.d(new ColumnCallParser(arguments, null));
            } else if (string.equals("remove_column") || string.equals("remove_columns")) {
                MigrationParser.this.a(new ColumnCallParser(arguments, null));
            } else if (string.equals("change_column")) {
                MigrationParser.this.c(new ColumnCallParser(arguments, null));
            } else if (string.equals("transaction")) {
                MigrationParser.d(arguments);
            }
        }

        /* synthetic */ MigrationCallable(a x1) {
            this();
        }
    }

    public static interface MigrationListener {
        public void migrationsChanged(Module var1);
    }
}

