/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.gem;

import b.h.la;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.Console;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.gem.GemListParser;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsChangeWatcher;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunner;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyScriptRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public class GemRunner {
    public static final String CANCELLED = "Cancelled";
    private static final Logger d;
    @NonNls
    private static final String m = "gem";
    @NonNls
    private static final String g = "gem.bat";
    @NonNls
    private static final String o = "jgem";
    @NonNls
    private static final String c = "igem";
    @NonNls
    private static final String n = "gem19";
    @NonNls
    private static final String l = "gem1.9";
    @NonNls
    private static final String p = "gem18";
    @NonNls
    private static final String b = "gem1.8";
    @NonNls
    private static final String f = "macgem";
    @NonNls
    private static final String i = "ERROR: ";
    @NonNls
    private static final Pattern k;
    private static final String j = ".9";
    private static final String a = ".8";
    private static final String e = "macruby";
    private static final String h = "-x";
    public static final int GEM_PATH_TIMEOUT = 30;
    private static final long q;

    private GemRunner() {
    }

    public static void bundle(@Nullable Module module, @NotNull Sdk sdk, @Nullable String action, @Nullable String customAction, @Nullable VirtualFile customWorkingDirectory, @Nullable Runnable postFlightAction, @Nullable String additionalOptions, boolean askForSudo) {
        String string;
        long l2 = q ^ 0x4A9F17E2BE4EL;
        if (sdk == null) {
            GemRunner.a(0);
        }
        if (action == null) {
            string = GemRunner.a(sdk, RubySdkAdditionalData.getInterpreterDir(sdk));
            action = customAction == null ? "bundle" : customAction;
        } else {
            string = BundlerUtil.getBundlerScriptPath(sdk, module);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (additionalOptions != null && additionalOptions.contains("--path") && JRubySdkUtil.isJRubySDK(sdk) && !JRubySdkUtil.isJRubyGreaterThan17(sdk)) {
            arrayList.add("-r");
            arrayList.add("openssl");
        }
        if (string != null) {
            arrayList.add(RubySdkUtil.getDefaultPathMappings(sdk, module).convertToRemote(RubyVersionManagerHandler.notNullFrom(sdk).getAdjustedGemScriptPathForExecution(string)));
        }
        arrayList.add(action);
        if (!StringUtil.isEmpty((String)additionalOptions)) {
            Collections.addAll(arrayList, ParametersList.parse((String)additionalOptions));
        }
        GemRunner.a(module, sdk, postFlightAction, customWorkingDirectory, askForSudo, ArrayUtil.toStringArray(arrayList));
    }

    @Nullable
    public static String getRawEnvironment(@Nullable Module module, @NotNull Sdk sdk) {
        ProcessOutput processOutput;
        long l2 = q ^ 0x18AEB915FA80L;
        if (sdk == null) {
            GemRunner.a(1);
        }
        if ((processOutput = GemRunner.a(sdk, module, null, Collections.singletonList("environment"), RBundle.message((String)"gems.reading.environment", (Object[])new Object[]{sdk}), 30)) == null) {
            return null;
        }
        String string = processOutput.getStdout();
        if (StringUtil.isEmpty((String)string)) {
            if (StringUtil.isNotEmpty((String)processOutput.getStderr())) {
                d.warn("Error getting raw environment for " + sdk + ": " + processOutput.getStderr());
            } else {
                d.warn("Environment is empty for " + sdk);
            }
            return null;
        }
        return !string.contains("LoadError") ? string.trim() : null;
    }

    @Nullable
    public static String version(@Nullable Module module, Sdk sdk, @Nullable Function<Object, Boolean> shouldCancelFun) {
        long l2 = q ^ 0xA1B0826F58AL;
        ProcessOutput processOutput = GemRunner.a(sdk, module, shouldCancelFun, Collections.singletonList("--version"), RBundle.message((String)"gems.checking.version"), -1);
        if (processOutput == null) {
            return null;
        }
        String string = processOutput.getStdout();
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        return !string.contains("LoadError") ? string.trim() : null;
    }

    @Nullable
    public static String list(@Nullable Module module, @NotNull Sdk sdk, @Nullable String url, @Nullable Function<Object, Boolean> shouldCancelFun, @NotNull String gemVersion) {
        String string;
        String string2;
        boolean bl2;
        long l2 = q ^ 0x126D860F2789L;
        if (sdk == null) {
            GemRunner.a(2);
        }
        if (gemVersion == null) {
            GemRunner.a(3);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("list");
        arrayList.add("--remote");
        arrayList.addAll(GemRunner.a());
        if (VersionComparatorUtil.compare((String)gemVersion, (String)"1.1.0") >= 0) {
            arrayList.add("--all");
        }
        GemRunner.a(gemVersion, arrayList);
        boolean bl3 = bl2 = VersionComparatorUtil.compare((String)gemVersion, (String)"1.2.0") < 0;
        if (bl2) {
            arrayList.add("--details");
        }
        if (!StringUtil.isEmpty((String)url)) {
            arrayList.add("--source");
            arrayList.add(url);
            string2 = RBundle.message((String)"gems.gem.listing.remote.url", (Object[])new Object[]{url});
        } else {
            string2 = RBundle.message((String)"gems.gem.listing.remote");
        }
        ProcessOutput processOutput = GemRunner.a(sdk, module, shouldCancelFun, arrayList, string2, -1);
        if (processOutput == null) {
            return null;
        }
        String string3 = processOutput.getStderr();
        if (!StringUtil.isEmpty((String)string3)) {
            if (GemRunner.a(string3)) {
                return GemRunner.list(module, sdk, url, shouldCancelFun, "1.3.3");
            }
            if (module != null && !module.isDisposed()) {
                string = string3.replace(i, "");
                if ((string = string.replace("While executing gem ...", "")).contains("Invalid gemspec")) {
                    string = GemRunner.b(string);
                }
                string = (string = string.replace("\n", "<br>")).contains("stack level too deep (SystemStackError)") ? string + "Please consider running <code>gem update --system</code>" : string + "<br>Please check proxy settings and gem urls";
                Notifications.Bus.notify((Notification)new InvalidGemsNotification("Gem Manager", "Failed to load remote gems " + url, string, NotificationType.WARNING, module.getProject()), (Project)module.getProject());
            }
        }
        if (StringUtil.isEmpty((String)(string = processOutput.getStdout()))) {
            return null;
        }
        return string;
    }

    private static String b(String string) {
        long l2 = q ^ 0x1F6626AE1F2FL;
        String[] stringArray = string.split("\\n");
        StringBuilder stringBuilder = new StringBuilder();
        Pattern pattern = Pattern.compile("Invalid gemspec in\\s\\[(.*)\\]: invalid (\\w+) format in specification.*");
        for (String string2 : stringArray) {
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.matches()) continue;
            GemspecError gemspecError = new GemspecError(matcher.group(1), matcher.group(2));
            stringBuilder.append(string2).append("\n").append("<a href=\"").append(gemspecError.getPath()).append(" ").append(gemspecError.getAttribute()).append("\">Fix gemspec</a>\n");
        }
        return stringBuilder.toString();
    }

    private static boolean a(String string) {
        long l2 = q ^ 0x782CD6EF157L;
        return string.contains("Prereleases not supported on legacy repositories") || string.contains("bad response") && string.contains("prerelease_specs");
    }

    private static void a(String string, List<String> list2) {
        long l2 = q ^ 0x61268DDF169AL;
        if (VersionComparatorUtil.compare((String)string, (String)"1.3.4") >= 0) {
            list2.add("--prerelease");
        }
    }

    @NotNull
    public static List<GemInfo> query(@Nullable Module module, @NotNull Sdk sdk, @Nullable String url, @Nullable Function<Object, Boolean> shouldCancelFun, @Nullable String gemName) {
        String string;
        long l2 = q ^ 0x7D3B5322AAEDL;
        if (sdk == null) {
            GemRunner.a(4);
        }
        String string2 = GemRunner.version(module, sdk, shouldCancelFun);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("query");
        arrayList.add("--remote");
        arrayList.addAll(GemRunner.a());
        arrayList.add("--details");
        arrayList.add("--all");
        GemRunner.a(string2, arrayList);
        arrayList.add("--name-matches");
        arrayList.add("^" + gemName + "$");
        if (!StringUtil.isEmpty((String)url)) {
            arrayList.add("--source");
            arrayList.add(url);
            string = RBundle.message((String)"gems.gem.listing.remote.url", (Object[])new Object[]{url});
        } else {
            string = RBundle.message((String)"gems.gem.listing.remote");
        }
        ProcessOutput processOutput = GemRunner.a(sdk, module, shouldCancelFun, arrayList, string, -1);
        if (processOutput == null) {
            List<GemInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                GemRunner.a(5);
            }
            return list2;
        }
        String string3 = processOutput.getStdout();
        if (StringUtil.isEmpty((String)string3)) {
            List<GemInfo> list3 = Collections.emptyList();
            if (list3 == null) {
                GemRunner.a(6);
            }
            return list3;
        }
        List<GemInfo> list4 = GemListParser.parse(string3, url != null ? url : "", true);
        if (list4 == null) {
            GemRunner.a(7);
        }
        return list4;
    }

    private static List<String> a() {
        long l2 = q ^ 0x2FCD64646E0FL;
        String string = GemRunner.getCurrentHttpProxy();
        if (string == null) {
            return Collections.emptyList();
        }
        return Arrays.asList("--http-proxy", string);
    }

    @Nullable
    public static String getCurrentHttpProxy() {
        long l2 = q ^ 0x68DB0B5C560CL;
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        if (httpConfigurable == null || !httpConfigurable.USE_HTTP_PROXY) {
            return null;
        }
        String string = httpConfigurable.PROXY_HOST;
        int n2 = httpConfigurable.PROXY_PORT;
        if (!StringUtil.isEmpty((String)string)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(URLUtil.containsScheme((String)string) ? "" : "http://");
            if (httpConfigurable.PROXY_AUTHENTICATION) {
                stringBuilder.append(httpConfigurable.getProxyLogin());
                String string2 = httpConfigurable.getPlainProxyPassword();
                if (!StringUtil.isEmpty((String)string2)) {
                    stringBuilder.append(":").append(string2);
                }
                stringBuilder.append("@");
            }
            stringBuilder.append(string);
            if (n2 > 0) {
                stringBuilder.append(":").append(n2);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    @Nullable
    private static ProcessOutput a(@NotNull Sdk sdk, @Nullable Module module, @Nullable Function<Object, Boolean> function, @NonNls @NotNull List<String> list2, @NotNull String string, int n2) {
        long l2 = q ^ 0x748AECB03483L;
        if (sdk == null) {
            GemRunner.a(8);
        }
        if (list2 == null) {
            GemRunner.a(9);
        }
        if (string == null) {
            GemRunner.a(10);
        }
        try {
            String string2;
            String string3;
            ExecutionModes.SameThreadMode sameThreadMode = new ExecutionModes.SameThreadMode(n2 <= 0, string, n2);
            if (function != null) {
                sameThreadMode.setShouldCancelFun(function);
            }
            if (!GemRunner.a(sdk, string3 = RubySdkAdditionalData.getInterpreterDir(sdk), string2 = GemRunner.a(sdk, string3))) {
                return null;
            }
            RubyRunner rubyRunner = RubySdkUtil.getRubySdkAdditionalData(sdk).getRunner(module);
            PathMappingSettings pathMappingSettings = rubyRunner.addDefaultMappings(null);
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)(list2.size() + 1));
            if (!GemRunner.b(sdk) && !ShimsBasedVersionManagerHandler.is(sdk)) {
                arrayList.add(RubySdkAdditionalData.getInterpreterPathFor(sdk));
                if (GemRunner.a(sdk)) {
                    arrayList.add(h);
                }
            }
            arrayList.add(pathMappingSettings.convertToRemote(RubyVersionManagerHandler.notNullFrom(sdk).getAdjustedGemScriptPathForExecution(string2)));
            arrayList.addAll(list2);
            return rubyRunner.execute((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(sdk, (List<String>)arrayList).withExecutionMode((ExecutionMode)sameThreadMode)).withModule(module)).withWorkingDirPath(pathMappingSettings.convertToRemote(string3)));
        }
        catch (ProcessCanceledException processCanceledException) {
            d.debug("process canceled", (Throwable)processCanceledException);
        }
        catch (RemoteSdkException remoteSdkException) {
            d.warn((Throwable)remoteSdkException);
            Notifications.Bus.notify((Notification)new Notification("Gem Manager", PlatformUtils.isRubyMine() ? "RubyMine Gem Manager" : "Ruby Plugin Gem Manager", "Failed to run remote command: " + remoteSdkException.getMessage(), NotificationType.WARNING), (Project)RModuleUtil.getInstance().getProject(module));
        }
        catch (Exception exception) {
            d.error((Throwable)exception);
        }
        return null;
    }

    private static boolean a(@NotNull Sdk sdk, @NotNull String string, @NotNull String string2) {
        if (sdk == null) {
            GemRunner.a(11);
        }
        if (string == null) {
            GemRunner.a(12);
        }
        if (string2 == null) {
            GemRunner.a(13);
        }
        return RubyRemoteInterpreterManager.getInstance().isRemoteSdk(sdk) || new File(string).exists() && new File(string2).exists() && RubySdkUtil.isRubyInterpreterExist(sdk);
    }

    private static boolean b(Sdk sdk) {
        long l2 = q ^ 0x3FBBEF7188F9L;
        return RubySdkUtil.isRubinius(sdk) && VersionComparatorUtil.compare((String)RubyVersionUtil.getRubiniusShortVersion(sdk.getVersionString()), (String)"2.0.0pre") >= 0;
    }

    public static Pair<Boolean, String> install(@Nullable Module module, @NotNull Sdk sdk, @NotNull GemDependency dependency, @Nullable String url, boolean installDependencies, boolean generateDocs) {
        Object object;
        String string2;
        String string3;
        long l2 = q ^ 0x58015E60B55EL;
        if (sdk == null) {
            GemRunner.a(14);
        }
        if (dependency == null) {
            GemRunner.a(15);
        }
        String string4 = GemRunner.version(module, sdk, null);
        Ref ref = Ref.create((Object)Pair.create((Object)false, (Object)CANCELLED));
        String string5 = dependency.getName();
        boolean bl2 = GemInstallUtil.isRawGem(string5);
        if (bl2) {
            int n2 = string5.lastIndexOf(SystemInfo.isWindows ? 92 : 47);
            string3 = string5.substring(n2 + 1);
            string2 = n2 >= 0 ? string5.substring(0, n2) : null;
        } else {
            string3 = string5;
            string2 = (String)ObjectUtils.doIfNotNull((Object)RModuleUtil.getInstance().getFirstContentRoot(module), virtualFile -> virtualFile.getPath());
        }
        StringBuilder stringBuilder = new StringBuilder();
        PairConsumer pairConsumer = (progressIndicator, string) -> {
            String string2;
            long l2 = q ^ 0x2610E502337FL;
            StringBuilder stringBuilder2 = stringBuilder;
            synchronized (stringBuilder2) {
                stringBuilder.append(GemRunner.c(string));
                if (!string.endsWith("\n")) {
                    return;
                }
                string2 = stringBuilder.toString();
                stringBuilder.delete(0, stringBuilder.length());
            }
            stringBuilder2 = (Pair)ref.get();
            if (k.matcher(TextUtil.chomp(string2)).matches()) {
                if (((Pair)stringBuilder2).second != null && !CANCELLED.equals(((Pair)stringBuilder2).second)) {
                    d.warn("Some errors happened during successful install: \n" + (String)((Pair)stringBuilder2).second);
                }
                ref.set((Object)Pair.create((Object)true, (Object)null));
            } else if (!((Boolean)((Pair)stringBuilder2).first).booleanValue() && !CANCELLED.equals(((Pair)stringBuilder2).second)) {
                ref.set((Object)Pair.create((Object)false, (Object)((String)((Pair)stringBuilder2).second + " " + TextUtil.chomp(string2))));
            } else if (string2.contains(i)) {
                ref.set((Object)Pair.create((Object)stringBuilder2.getFirst(), (Object)string2.replaceFirst(i, "")));
            }
            if (!StringUtil.isEmpty((String)string2.trim())) {
                progressIndicator.setText2(string2);
            }
        };
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        if (!dependency.isAny()) {
            assert (dependency.size() == 1);
            arrayList.add("--version");
            object = dependency.getVersionString();
            arrayList.add(RubySdkUtil.isMaglev(sdk) ? object.replace(" ", "") : object);
        }
        if (!generateDocs) {
            if (VersionComparatorUtil.compare((String)string4, (String)"3.0.0") >= 0) {
                arrayList.add("--no-document");
            } else {
                arrayList.add("--no-rdoc");
                arrayList.add("--no-ri");
            }
        }
        if (!bl2) {
            arrayList.addAll(GemRunner.a());
        }
        if (!installDependencies) {
            arrayList.add("--ignore-dependencies");
        } else if (VersionComparatorUtil.compare((String)string4, (String)"0.9.5") < 0) {
            arrayList.add("--include-dependencies");
        }
        if (VersionComparatorUtil.compare((String)string4, (String)"1.3.6") >= 0 && !RubySdkAdditionalData.areGemsUserLocal(sdk)) {
            arrayList.add("--user-install");
        }
        if (!StringUtil.isEmpty((String)url)) {
            arrayList.add("--source");
            arrayList.add(url);
        }
        if ((object = GemRunner.a(sdk, string2, arrayList)) == null) {
            String string6 = RubySdkAdditionalData.getInterpreterPathFor(sdk);
            return Pair.create((Object)false, (Object)RBundle.message((String)"sdk.error.homepath.doesnt.exists", (Object[])new Object[]{string6, sdk.getName()}));
        }
        GemRunner.a(sdk, module, (PairConsumer<ProgressIndicator, String>)pairConsumer, "install", (RubyCommandLine)((Object)object), dependency.getDescription());
        return (Pair)ref.get();
    }

    private static int a(@NotNull Sdk sdk, @Nullable Module module, final PairConsumer<ProgressIndicator, String> pairConsumer, String string, @NotNull RubyCommandLine rubyCommandLine, String string2) {
        long l2 = q ^ 0x4ADE5071602BL;
        if (sdk == null) {
            GemRunner.a(16);
        }
        if (rubyCommandLine == null) {
            GemRunner.a(17);
        }
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setText(RBundle.message((String)"gems.gem.installing.gem", (Object[])new Object[]{string2}));
        progressIndicator.setText2(RBundle.message((String)"gems.gem.running.command", (Object[])new Object[]{rubyCommandLine.getCommandLineString()}));
        try {
            RubyAbstractRunner rubyAbstractRunner = (RubyAbstractRunner)RubySdkUtil.getRubySdkAdditionalData(sdk).getRunner(module);
            ProcessHandler processHandler = rubyAbstractRunner.createProcessHandler(rubyCommandLine, null);
            ProcessAdapter processAdapter = new ProcessAdapter(){
                private static final long a = la.a(-8537322343935415235L, 8588025574568660457L, MethodHandles.lookup().lookupClass()).a(81918137373950L);

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.a(0);
                    }
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.a(1);
                    }
                }

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    if (event == null) {
                        1.a(2);
                    }
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.a(3);
                    }
                    if (outputType == null) {
                        1.a(4);
                    }
                    String string = event.getText();
                    pairConsumer.consume((Object)progressIndicator, (Object)string);
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    long l2 = a ^ 0x76F8F8993ED6L;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/gem/GemRunner$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processWillTerminate";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            processHandler.addProcessListener((ProcessListener)processAdapter);
            rubyAbstractRunner.applyLastPatchTo(processHandler).startNotify();
            ExecutionHelper.executeExternalProcess((Project)RModuleUtil.getInstance().getProject(module), (ProcessHandler)processHandler, (ExecutionMode)new ExecutionModes.SameThreadMode(null), (GeneralCommandLine)rubyCommandLine);
        }
        catch (ExecutionException executionException) {
            d.error(MessageFormat.format(RBundle.message((String)"gems.running.command.error", (Object[])new Object[]{string}), string), (Throwable)executionException);
        }
        return -1;
    }

    @Nullable
    private static RubyCommandLine a(@NotNull Sdk sdk, @Nullable String string, List<String> list2) {
        Object object;
        HashMap<String, String> hashMap;
        String string2;
        String string3;
        long l2 = q ^ 0x13DE92D2A286L;
        if (sdk == null) {
            GemRunner.a(18);
        }
        if (!GemRunner.a(sdk, string3 = RubySdkAdditionalData.getInterpreterDir(sdk), string2 = GemRunner.a(sdk, string3))) {
            return null;
        }
        String string4 = RubySdkAdditionalData.getInterpreterPathFor(sdk);
        if (JRubySdkUtil.isJRubySDK(sdk) && string4.endsWith(".exe")) {
            hashMap = new HashMap<String, String>();
            object = FileUtil.toSystemDependentName((String)string4);
            hashMap.put("rake", (String)object + " -S rake");
        } else {
            hashMap = null;
        }
        object = RunnerUtil.getRunner(sdk, null);
        PathMappingSettings pathMappingSettings = object.addDefaultMappings(null);
        ArrayList<String> arrayList = new ArrayList<String>();
        RubyVersionManagerHandler rubyVersionManagerHandler = RubyVersionManagerHandler.notNullFrom(sdk);
        if (!ShimsBasedVersionManagerHandler.is(rubyVersionManagerHandler)) {
            arrayList.add(string4);
        }
        arrayList.add(pathMappingSettings.convertToRemote(rubyVersionManagerHandler.getAdjustedGemScriptPathForExecution(string2)));
        arrayList.add("install");
        arrayList.addAll(list2);
        return object.createCommandLine((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(sdk, arrayList).withWorkingDirPath(pathMappingSettings.convertToRemote(string == null ? string3 : string))).withAdditionalEnvs(hashMap));
    }

    @NotNull
    private static String a(@NotNull Sdk sdk, @Nullable String string) {
        String string2;
        String string3;
        long l2 = q ^ 0x2CABBF71937BL;
        if (sdk == null) {
            GemRunner.a(19);
        }
        RubySdkSystemAccessor rubySdkSystemAccessor = RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor();
        String string4 = string + rubySdkSystemAccessor.getFileSeparator();
        if (JRubySdkUtil.isJRubySDK(sdk) && (string3 = GemRunner.a(string4, o)) != null) {
            String string5 = string3;
            if (string5 == null) {
                GemRunner.a(20);
            }
            return string5;
        }
        if (RubySdkUtil.isIronRuby(sdk) && (string3 = GemRunner.a(string4, c)) != null) {
            String string6 = string3;
            if (string6 == null) {
                GemRunner.a(21);
            }
            return string6;
        }
        string3 = sdk.getVersionString();
        if (string3 != null && string3.contains(j)) {
            string2 = GemRunner.a(string4, n);
            if (string2 != null) {
                String string7 = string2;
                if (string7 == null) {
                    GemRunner.a(22);
                }
                return string7;
            }
            string2 = GemRunner.a(string4, l);
            if (string2 != null) {
                String string8 = string2;
                if (string8 == null) {
                    GemRunner.a(23);
                }
                return string8;
            }
            if (rubySdkSystemAccessor.isWindows() && (string2 = GemRunner.a(string4, g)) != null && GemRunner.a(string4, m) == null) {
                String string9 = string2;
                if (string9 == null) {
                    GemRunner.a(24);
                }
                return string9;
            }
        }
        if (string3 != null && string3.contains(a)) {
            string2 = GemRunner.a(string4, p);
            if (string2 != null) {
                String string10 = string2;
                if (string10 == null) {
                    GemRunner.a(25);
                }
                return string10;
            }
            string2 = GemRunner.a(string4, b);
            if (string2 != null) {
                String string11 = string2;
                if (string11 == null) {
                    GemRunner.a(26);
                }
                return string11;
            }
        }
        if (string3 != null && string3.toLowerCase(Locale.US).contains(e) && (string2 = GemRunner.a(string4, f)) != null) {
            String string12 = string2;
            if (string12 == null) {
                GemRunner.a(27);
            }
            return string12;
        }
        String string13 = string4 + m;
        if (string13 == null) {
            GemRunner.a(28);
        }
        return string13;
    }

    @Nullable
    private static String a(String string, String string2) {
        String string3 = string + string2;
        File file = new File(string3);
        return file.exists() && file.isFile() ? string3 : null;
    }

    private static boolean a(Sdk sdk) {
        return !JRubySdkUtil.isJRubySDK(sdk) && !RubySdkUtil.isIronRuby(sdk) && !RubySdkUtil.isMacRuby(sdk) && !RubySdkUtil.isRubinius(sdk) && !RubySdkUtil.isMaglev(sdk);
    }

    private static void a(final Module module, final @NotNull Sdk sdk, final @Nullable Runnable runnable, @Nullable VirtualFile virtualFile, boolean bl2, final String ... stringArray) {
        long l2 = q ^ 0x318D686F1667L;
        if (sdk == null) {
            GemRunner.a(29);
        }
        try {
            VirtualFile virtualFile2;
            FileDocumentManager.getInstance().saveAllDocuments();
            final Ref ref = new Ref();
            final VirtualFile virtualFile3 = BundlerUtil.getGemfile(module);
            VirtualFile virtualFile4 = virtualFile2 = virtualFile3 != null ? virtualFile3.getParent() : null;
            String string = virtualFile == null ? (virtualFile2 != null ? VfsUtilCore.urlToPath((String)virtualFile2.getUrl()) : null) : virtualFile.getPath();
            final VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (string == null && virtualFileArray.length > 0) {
                string = virtualFileArray[0].getPath();
            }
            ProcessAdapter processAdapter = new ProcessAdapter(){
                private static final long a = la.a(-1101459397894881779L, 6176148130034526468L, MethodHandles.lookup().lookupClass()).a(260183453761596L);

                public void startNotified(@NotNull ProcessEvent event) {
                    long l2 = a ^ 0x1268984B980DL;
                    if (event == null) {
                        2.a(0);
                    }
                    ref.set((Object)LocalHistory.getInstance().startAction("bundle " + StringUtil.join((String[])stringArray, (String)" ")));
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.a(1);
                    }
                    Set<String> set = GemUtil.determineGemUrlsForSDK(sdk);
                    RubyRemoteInterpreterManager.getInstance().updateGemsCopy(sdk, module, true);
                    Runnable runnable2 = () -> {
                        if (sdk == null) {
                            2.a(2);
                        }
                        if (event == null) {
                            2.a(3);
                        }
                        if (module.isDisposed()) {
                            return;
                        }
                        for (VirtualFile virtualFile2 : virtualFileArray) {
                            if (virtualFile2 == null) continue;
                            virtualFile2.refresh(false, true);
                        }
                        GemManager.getInstance().softRefreshRoots(sdk, set);
                        RbenvGemsetManager.refreshAttachedGemsetSdks(module);
                        if (virtualFile3 != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                            GemRequirementsChangeWatcher.getInstance(module).addFileScan(virtualFile3);
                        }
                        if (runnable != null && event.getExitCode() == 0) {
                            runnable.run();
                        }
                        GemManager.updateGemset(module);
                    };
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        ApplicationManager.getApplication().invokeLater(runnable2);
                    } else {
                        WriteAction.runAndWait(() -> runnable2.run());
                    }
                    ((LocalHistoryAction)ref.get()).finish();
                    ref.set(null);
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    long l2 = a ^ 0xFE444CD74C7L;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "sdk";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/gem/GemRunner$2";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$processTerminated$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            String string2 = module.getName() + ": bundler";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string3 = GemRunner.getCurrentHttpProxy();
            if (string3 != null) {
                hashMap.put("HTTP_PROXY", string3);
            }
            if (virtualFile3 != null) {
                BundlerUtil.addBundlerEnvironment(hashMap, sdk, module, virtualFile3);
            }
            MergingCommandLineArgumentsProvider mergingCommandLineArgumentsProvider = new MergingCommandLineArgumentsProvider(stringArray, null, null, hashMap, sdk);
            RubyScriptRunner.runRubyScriptInConsole((ProcessListener)processAdapter, null, null, ConsoleRunner.ProcessLaunchMode.BACKGROUND_TASK_WITH_PROGRESS, string2, mergingCommandLineArgumentsProvider, null, string, sdk, module, null, bl2);
        }
        catch (Exception exception) {
            RunnerUtil.showErrorMessage(module.getProject(), "Error running ", exception);
        }
    }

    private static String c(String string) {
        long l2 = q ^ 0x5F8270DA2287L;
        if (!SystemInfo.isWindows) {
            return string;
        }
        try {
            Method method = Console.class.getDeclaredMethod("encoding", new Class[0]);
            method.setAccessible(true);
            string = new String(string.getBytes(), (String)method.invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    static {
        q = la.a(-126458811821471968L, 3580493465587499982L, MethodHandles.lookup().lookupClass()).a(187710082239177L);
        long l2 = q ^ 0x3CAC5F8A437L;
        d = Logger.getInstance(GemRunner.class);
        k = Pattern.compile("\\d*\\s*gem[s]?\\s*installed");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = q ^ 0x1F859542F3C7L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemVersion";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/gem/GemRunner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/gem/GemRunner";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "query";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemExecutableName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bundle";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRawEnvironment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "query";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkPaths";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runInstall";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createGemInstallCommand";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getGemExecutableName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "runBundler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class GemspecError {
        private String b;
        private String a;

        GemspecError(String path, String attribute) {
            this.b = path;
            this.a = attribute;
        }

        GemspecError(String eventDescription) {
            String[] stringArray = eventDescription.split(" ");
            if (stringArray.length == 2) {
                this.b = stringArray[0];
                this.a = stringArray[1];
            }
        }

        public String getPath() {
            return this.b;
        }

        public String getAttribute() {
            return this.a;
        }
    }

    static class InvalidGemsNotification
    extends Notification {
        private static final long a = la.a(6502074187660238549L, 3989720458041320782L, MethodHandles.lookup().lookupClass()).a(141922570990732L);

        InvalidGemsNotification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content, @NotNull NotificationType type, final @NotNull Project project) {
            if (groupDisplayId == null) {
                InvalidGemsNotification.a(0);
            }
            if (title == null) {
                InvalidGemsNotification.a(1);
            }
            if (content == null) {
                InvalidGemsNotification.a(2);
            }
            if (type == null) {
                InvalidGemsNotification.a(3);
            }
            if (project == null) {
                InvalidGemsNotification.a(4);
            }
            super(groupDisplayId, title, content, type, new NotificationListener(){
                private static final long a = la.a(4671524807345323043L, 3966475509511869797L, MethodHandles.lookup().lookupClass()).a(23529389346599L);

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.a(0);
                    }
                    if (event == null) {
                        1.a(1);
                    }
                    String string = event.getDescription();
                    GemspecError gemspecError = new GemspecError(string);
                    String string2 = FileUtil.toCanonicalPath((String)gemspecError.getPath());
                    File file = new File(string2);
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                    if (virtualFile != null) {
                        String string3;
                        String string4;
                        int n2;
                        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, virtualFile);
                        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(openFileDescriptor, true);
                        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                        if (psiFile != null && (n2 = (string4 = psiFile.getText()).indexOf(string3 = gemspecError.getAttribute())) > 0 && editor != null) {
                            editor.getCaretModel().moveToOffset(n2);
                        }
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    long l2 = a ^ 0xBDB6897FC73L;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/ruby/gem/gem/GemRunner$InvalidGemsNotification$1";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x46759249E053L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groupDisplayId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/gem/gem/GemRunner$InvalidGemsNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

