/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui;

import b.h.la;
import com.intellij.application.Topics;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.remote.AuthType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.ui.SshUIUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshCredentialsEditor
extends SettingsEditor<MutableRemoteCredentials>
implements PanelWithAnchor {
    protected JPanel myMainPanel;
    protected JBLabel myHostLabel;
    protected JBLabel myPasswordLabel;
    protected JBCheckBox mySavePasswordCheckBox;
    protected JTextField myUsernameField;
    protected TextFieldWithBrowseButton myPrivateKeyFileField;
    protected JLabel myPassphraseLabel;
    protected JPasswordField myPassphraseField;
    protected JCheckBox mySavePassphraseCheckbox;
    protected JPasswordField myPasswordField;
    protected JLabel myPrivateKeyFileLabel;
    protected JComboBox<AuthType> myAuthTypeCombo;
    protected JTextField myHostField;
    protected JTextField myPortField;
    protected ActionLink myRSyncLink;
    protected JLabel myExternalToolsSuggestionLabel;
    private final Map<String, JComponent> a;
    private ParentComponent b;
    @Nullable
    private JComponent c;
    private static final long d = la.a(622126214521360248L, -2924504679425115585L, MethodHandles.lookup().lookupClass()).a(90276785780880L);

    public SshCredentialsEditor() {
        long l2 = d ^ 0x4D00BA564811L;
        this.a();
        this.myPasswordField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){
            private static final long a = la.a(-6605476993870780187L, -4095989459506776579L, MethodHandles.lookup().lookupClass()).a(271971032117123L);

            protected void textChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    1.a(0);
                }
                SshCredentialsEditor.this.d();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x7493E61EF0E8L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/ui/SshCredentialsEditor$1", "textChanged"));
            }
        });
        this.myPrivateKeyFileLabel.setLabelFor(this.myPrivateKeyFileField.getTextField());
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){
            private static final long a = la.a(8355002950355629950L, 4634135166840623690L, MethodHandles.lookup().lookupClass()).a(135349836633905L);

            protected void textChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    2.a(0);
                }
                SshCredentialsEditor.this.c();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x416FA24A4E0AL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/ui/SshCredentialsEditor$2", "textChanged"));
            }
        });
        this.myAuthTypeCombo.setModel((ComboBoxModel<AuthType>)new CollectionComboBoxModel(Arrays.asList(AuthType.PASSWORD, AuthType.KEY_PAIR, AuthType.OPEN_SSH), (Object)AuthType.PASSWORD));
        this.myAuthTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                SshCredentialsEditor.this.b();
                JTextField jTextField = SshCredentialsEditor.this.myAuthTypeCombo.getSelectedItem() == AuthType.PASSWORD ? SshCredentialsEditor.this.myPasswordField : SshCredentialsEditor.this.myPrivateKeyFileField.getTextField();
                IdeFocusManager.findInstanceByComponent((Component)jTextField).requestFocus((Component)jTextField, false);
            }
        });
        this.myAuthTypeCombo.setRenderer((ListCellRenderer<AuthType>)new ColoredListCellRenderer<AuthType>(){
            private static final long a = la.a(7442755001555152342L, 8435232513566569538L, MethodHandles.lookup().lookupClass()).a(71639543622832L);

            protected void customizeCellRenderer(@NotNull JList<? extends AuthType> list2, AuthType value, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    4.a(0);
                }
                SshUIUtil.append((ColoredTextContainer)this, value);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x363A61146126L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ssh/ui/SshCredentialsEditor$4", "customizeCellRenderer"));
            }
        });
        this.b();
        this.a = new HashMap<String, JComponent>();
        this.a.put("HOST", this.myHostField);
        this.a.put("PORT", this.myPortField);
        this.a.put("USERNAME", this.myUsernameField);
        this.a.put("PRIVATE_KEY_FILE", (JComponent)this.myPrivateKeyFileField);
        this.myExternalToolsSuggestionLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.d();
        Topics.subscribe((Topic)ApplicationActivationListener.TOPIC, (Disposable)this, (Object)new AppListener());
    }

    public void createUIComponents() {
        long l2 = d ^ 0x302E16E741F7L;
        this.myRSyncLink = new ActionLink("RSync", new AnAction(){
            private static final long a = la.a(-6971261441776715477L, 6351148559223651628L, MethodHandles.lookup().lookupClass()).a(255768075893502L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                long l2 = a ^ 0x6A2F8638FBB4L;
                if (e10 == null) {
                    5.a(0);
                }
                BrowserUtil.open((String)"https://confluence.jetbrains.com/display/RUBYDEV/Faster+Remote+Gem+Downloading+with+Rsync");
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0xF4BE8357D94L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/ui/SshCredentialsEditor$5", "actionPerformed"));
            }
        });
    }

    public void setContainer(ParentComponent container) {
        this.b = container;
        Disposable disposable = container.getDisposable();
        Disposer.register((Disposable)disposable, (Disposable)this);
    }

    private void c() {
        if (StringUtil.isNotEmpty((String)this.myPrivateKeyFileField.getText())) {
            boolean bl2 = true;
            File file = new File(this.myPrivateKeyFileField.getText());
            if (file.isFile() && file.canRead()) {
                try {
                    KeyPair keyPair = KeyPair.load((JSch)new JSch(), (String)file.getAbsolutePath());
                    bl2 = keyPair == null || keyPair.isEncrypted();
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
            }
            if (bl2) {
                if (!this.myPassphraseField.isEnabled()) {
                    this.myPassphraseField.setText(null);
                    this.myPassphraseField.setEnabled(true);
                    this.mySavePassphraseCheckbox.setEnabled(true);
                }
            } else {
                this.myPassphraseField.setText(null);
                this.myPassphraseField.setEnabled(false);
                this.mySavePassphraseCheckbox.setSelected(false);
                this.mySavePassphraseCheckbox.setEnabled(false);
            }
        } else {
            this.myPasswordField.setEnabled(true);
            this.mySavePasswordCheckBox.setEnabled(true);
        }
    }

    private void b() {
        if (this.myAuthTypeCombo.getSelectedItem() == AuthType.PASSWORD) {
            this.myPasswordLabel.setVisible(true);
            this.myPasswordField.setVisible(true);
            this.mySavePasswordCheckBox.setVisible(true);
            this.myPrivateKeyFileLabel.setVisible(false);
            this.myPrivateKeyFileField.setText("");
            int n2 = this.myPrivateKeyFileLabel.getPreferredSize().width;
            this.myPasswordLabel.setMinimumSize(new Dimension(n2, this.myPasswordLabel.getMinimumSize().height));
            this.myPrivateKeyFileField.setVisible(false);
            this.myPassphraseLabel.setVisible(false);
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setVisible(false);
            this.mySavePassphraseCheckbox.setVisible(false);
            this.mySavePassphraseCheckbox.setSelected(false);
        } else if (this.myAuthTypeCombo.getSelectedItem() == AuthType.KEY_PAIR) {
            this.myPasswordLabel.setVisible(false);
            this.myPasswordField.setText(null);
            this.myPasswordField.setVisible(false);
            this.mySavePasswordCheckBox.setSelected(false);
            this.mySavePasswordCheckBox.setVisible(false);
            this.myPrivateKeyFileLabel.setVisible(true);
            this.myPrivateKeyFileField.setVisible(true);
            this.myPassphraseLabel.setVisible(true);
            this.myPassphraseField.setVisible(true);
            this.mySavePassphraseCheckbox.setVisible(true);
            this.myPassphraseField.setEnabled(true);
            this.mySavePassphraseCheckbox.setEnabled(true);
        } else {
            this.myPasswordLabel.setVisible(false);
            this.myPasswordField.setText(null);
            this.myPasswordField.setVisible(false);
            this.mySavePasswordCheckBox.setSelected(false);
            this.mySavePasswordCheckBox.setVisible(false);
            this.myPrivateKeyFileLabel.setVisible(false);
            this.myPrivateKeyFileField.setText("");
            this.myPrivateKeyFileField.setVisible(false);
            this.myPassphraseLabel.setVisible(false);
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setVisible(false);
            this.mySavePassphraseCheckbox.setVisible(false);
            this.mySavePassphraseCheckbox.setSelected(false);
        }
        if (this.b != null) {
            this.b.updateSize();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myHostField;
    }

    private void a(@NotNull AuthType authType) {
        if (authType == null) {
            SshCredentialsEditor.a(0);
        }
        this.myAuthTypeCombo.setSelectedItem(authType);
        this.b();
    }

    public void resetEditorFrom(@NotNull MutableRemoteCredentials credentials) {
        if (credentials == null) {
            SshCredentialsEditor.a(1);
        }
        this.resetEditor((RemoteCredentials)credentials);
    }

    public void resetEditor(RemoteCredentials credentials) {
        this.myHostField.setText(credentials.getHost());
        this.myPortField.setText(credentials.getLiteralPort());
        this.myUsernameField.setText(credentials.getUserName());
        this.a(credentials.getAuthType());
        if (credentials.getAuthType() == AuthType.KEY_PAIR) {
            this.myPrivateKeyFileField.setText(credentials.getPrivateKeyFile());
            this.myPassphraseField.setText(credentials.getPassphrase());
            this.mySavePassphraseCheckbox.setSelected(credentials.isStorePassphrase());
        } else if (credentials.getAuthType() == AuthType.PASSWORD) {
            this.myPasswordField.setText(credentials.getPassword());
            this.mySavePasswordCheckBox.setSelected(credentials.isStorePassword());
        }
    }

    protected void applyEditorTo(@NotNull MutableRemoteCredentials credentials) {
        if (credentials == null) {
            SshCredentialsEditor.a(2);
        }
        credentials.setHost(this.myHostField.getText());
        credentials.setLiteralPort(this.myPortField.getText());
        String string = this.myUsernameField.getText();
        if (string != null) {
            string = string.trim();
        }
        credentials.setUserName(string);
        if (this.myAuthTypeCombo.getSelectedItem() == AuthType.KEY_PAIR) {
            credentials.setAuthType(AuthType.KEY_PAIR);
            credentials.setPassword(null);
            credentials.setStorePassword(false);
            credentials.setPassphrase(new String(this.myPassphraseField.getPassword()));
            credentials.setStorePassphrase(this.mySavePassphraseCheckbox.isSelected());
            credentials.setPrivateKeyFile(this.myPrivateKeyFileField.getText());
        } else if (this.myAuthTypeCombo.getSelectedItem() == AuthType.OPEN_SSH) {
            credentials.setAuthType(AuthType.OPEN_SSH);
            credentials.setPassword(null);
            credentials.setStorePassword(false);
            credentials.setPassphrase(null);
            credentials.setStorePassphrase(false);
            credentials.setPrivateKeyFile(null);
        } else {
            credentials.setAuthType(AuthType.PASSWORD);
            credentials.setPassword(new String(this.myPasswordField.getPassword()));
            credentials.setStorePassword(this.mySavePasswordCheckBox.isSelected());
            credentials.setPassphrase(null);
            credentials.setStorePassphrase(false);
            credentials.setPrivateKeyFile(null);
        }
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            SshCredentialsEditor.a(3);
        }
        return jPanel;
    }

    public void setEnabled(boolean enabled) {
        UIUtil.setEnabled((Component)this.myMainPanel, (boolean)enabled, (boolean)true);
    }

    private void d() {
        long l2 = d ^ 0x6FA04A6FA0D5L;
        List<String> list2 = RSyncUtil.externalToolSuggestion();
        String string = StringUtil.pluralize((String)"utility", (int)list2.size());
        this.myExternalToolsSuggestionLabel.setText(String.format("To reduce download time install %s:", string));
        this.myExternalToolsSuggestionLabel.setVisible(list2.size() > 0);
        this.myRSyncLink.setVisible(list2.contains("rsync"));
    }

    @Nullable
    public ValidationInfo createValidationInfo(@NotNull Pair<String, String> errorMessageAndField) {
        String string;
        if (errorMessageAndField == null) {
            SshCredentialsEditor.a(4);
        }
        JComponent jComponent = (string = (String)errorMessageAndField.getSecond()) == null ? null : this.a.get(string);
        return new ValidationInfo((String)errorMessageAndField.getFirst(), jComponent);
    }

    @Nullable
    public JComponent getAnchor() {
        return this.c;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.c = anchor;
        this.myHostLabel.setAnchor(anchor);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x2FB7E195317EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/SshCredentialsEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessageAndField";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/SshCredentialsEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setAuthTypeCombo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createValidationInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void a() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JPasswordField jPasswordField;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel3;
        JPasswordField jPasswordField2;
        JBLabel jBLabel;
        JTextField jTextField2;
        JTextField jTextField3;
        JBLabel jBLabel2;
        JPanel jPanel;
        long l2 = d ^ 0x12B0688825FDL;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myHostLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Host:");
        jBLabel2.setDisplayedMnemonic('H');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 3, 0, 3, 7, 3, null, null, null));
        this.myHostField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Port:");
        jLabel4.setDisplayedMnemonic('P');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 2, 1, 1, 8, 0, 2, 0, null, new Dimension(50, 22), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("User name:");
        jLabel5.setDisplayedMnemonic('U');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Authentication type:");
        jLabel6.setDisplayedMnemonic('Y');
        jLabel6.setDisplayedMnemonicIndex(16);
        jPanel.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myAuthTypeCombo = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this.myPasswordLabel = jBLabel = new JBLabel();
        jBLabel.setText("Password:");
        jBLabel.setDisplayedMnemonic('A');
        jBLabel.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel.add((Component)jPasswordField2, new GridConstraints(3, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPrivateKeyFileLabel = jLabel3 = new JLabel();
        jLabel3.setText("Private key file:");
        jLabel3.setDisplayedMnemonic('K');
        jLabel3.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrivateKeyFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        this.myPassphraseLabel = jLabel2 = new JLabel();
        jLabel2.setText("Passphrase:");
        jLabel2.setDisplayedMnemonic('A');
        jLabel2.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPassphraseField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(5, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, 22), null));
        this.myUsernameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, -1), null));
        this.mySavePasswordCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Save password");
        jBCheckBox.setMnemonic('E');
        jBCheckBox.setDisplayedMnemonicIndex(3);
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySavePassphraseCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Save passphrase");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(3);
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(6, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myExternalToolsSuggestionLabel = jLabel = new JLabel();
        jLabel.setText("To reduce download time install utilities:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ActionLink actionLink = this.myRSyncLink;
        actionLink.setText("RSync");
        jPanel3.add((Component)actionLink, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jBLabel2.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField);
        jLabel6.setLabelFor(jComboBox);
        jBLabel.setLabelFor(jPasswordField2);
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class AppListener
    implements ApplicationActivationListener {
        private static final long a = la.a(3037469722980651885L, 76179952170385218L, MethodHandles.lookup().lookupClass()).a(55064182111313L);

        private AppListener() {
        }

        public void applicationActivated(@NotNull IdeFrame ideFrame) {
            if (ideFrame == null) {
                AppListener.a(0);
            }
            SshCredentialsEditor.this.d();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x713EF76C6739L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/ssh/ui/SshCredentialsEditor$AppListener", "applicationActivated"));
        }
    }

    public static interface ParentComponent {
        public void updateSize();

        @NotNull
        public Disposable getDisposable();
    }
}

