/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import b.h.la;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesPresentationCache;
import com.intellij.dupLocator.DuplicatesProfileCache;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.ContentPanel;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.ExportHTMLAction;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.impl.SelectInEditorHandler;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesForm
implements Disposable {
    private final JLabel o;
    private final JLabel c;
    private final JPanel m;
    @NonNls
    private static final String f = "DuplicatesForm.SendToLeft";
    @NonNls
    private static final String a = "DuplicatesForm.SendToRight";
    @NonNls
    private static final String p = "find.locateDuplicates.result";
    private final JBSplitter h;
    private final Tree k;
    private final MyDuplicatesModelListener q;
    private final DupInfo i;
    private final Map<DuplicatesPresentation, DuplicatesView> n;
    private final Map<Editor, List<RangeHighlighter>> l;
    private DuplicatesModel e;
    private final Project j;
    private static final DataKey<DuplicatesModel> b;
    private static final String d = "DuplicatesForm.settings.scrollToSource";
    private final MyGlassPanePainter r;
    private static DupInfo g;
    private static final long s;

    private DuplicatesForm(Project project, DupInfo dupInfo) {
        long l2 = s ^ 0x73715EE4D878L;
        this.o = new JLabel(AllIcons.Duplicates.SendToTheLeft);
        this.c = new JLabel(AllIcons.Duplicates.SendToTheRight);
        this.m = new JPanel(new BorderLayout());
        this.k = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.q = new MyDuplicatesModelListener();
        this.n = new HashMap<DuplicatesPresentation, DuplicatesView>();
        this.l = new HashMap<Editor, List<RangeHighlighter>>();
        this.r = new MyGlassPanePainter();
        this.j = project;
        this.i = dupInfo;
        DataProvider dataProvider = new DataProvider(){
            private static final long a = la.a(5352676067125854125L, 7033587078567941460L, MethodHandles.lookup().lookupClass()).a(40301202581438L);

            public Object getData(@NotNull String dataId) {
                long l2 = a ^ 0x3004D75C9292L;
                if (dataId == null) {
                    1.a(0);
                }
                if (PlatformDataKeys.HELP_ID.is(dataId)) {
                    return DuplicatesForm.p;
                }
                if (b.is(dataId)) {
                    return DuplicatesForm.this.e;
                }
                if (DuplicatesForm.this.e == null) {
                    return null;
                }
                if (CommonDataKeys.NAVIGATABLE.getName().equals(dataId)) {
                    CodeNode codeNode = DuplicatesForm.this.e.getSelectedCodeNode();
                    return codeNode != null ? codeNode.getOpenFileDescriptorIfValid() : null;
                }
                return null;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x42A6A56B2D0DL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/dupLocator/resultUI/DuplicatesForm$1", "getData"));
            }
        };
        this.h = new MySplitter(this, dataProvider);
        this.h.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.k));
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.k);
        SelectInEditorHandler.installKeyListener((JComponent)this.k);
        this.b();
        this.k.setShowsRootHandles(true);
        this.k.setRootVisible(false);
        final MyColoredTreeCellRenderer myColoredTreeCellRenderer = new MyColoredTreeCellRenderer();
        this.k.setCellRenderer((TreeCellRenderer)myColoredTreeCellRenderer);
        PopupHandler.installUnknownPopupHandler((JComponent)this.k, (ActionGroup)DuplicatesForm.a(this.getComponent()), (ActionManager)ActionManager.getInstance());
        this.k.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e10) {
                int n2 = DuplicatesForm.this.k.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0) {
                    Rectangle rectangle = DuplicatesForm.this.k.getRowBounds(n2);
                    myColoredTreeCellRenderer.setBounds(rectangle);
                    if (!DuplicatesForm.this.a(e10, rectangle.getLocation(), DuplicatesForm.this.o, 0)) {
                        DuplicatesForm.this.a(e10, new Point(rectangle.x + DuplicatesForm.this.o.getWidth(), rectangle.y), DuplicatesForm.this.c, 1);
                    }
                }
            }
        });
        this.m.add((Component)this.o, "West");
        this.m.add((Component)this.c, "East");
        this.m.setBackground(UIUtil.getTreeBackground());
        IdeGlassPaneUtil.installPainter((JComponent)this.k, (Painter)this.r, (Disposable)this);
        this.k.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e10) {
                Object object;
                int n2 = DuplicatesForm.this.k.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0 && (object = DuplicatesForm.this.k.getPathForRow(n2).getLastPathComponent()) instanceof CodeNode) {
                    Rectangle rectangle = DuplicatesForm.this.k.getRowBounds(n2);
                    myColoredTreeCellRenderer.setBounds(rectangle);
                    Point point = e10.getPoint();
                    Rectangle rectangle2 = DuplicatesForm.this.o.getBounds();
                    rectangle2.setLocation(rectangle.getLocation());
                    Icon icon = null;
                    if (rectangle2.contains(point)) {
                        icon = AllIcons.Duplicates.SendToTheLeft;
                    } else {
                        rectangle2 = DuplicatesForm.this.c.getBounds();
                        rectangle2.setLocation(new Point(rectangle.x + AllIcons.Duplicates.SendToTheRight.getIconWidth(), rectangle.y));
                        if (rectangle2.contains(point)) {
                            icon = AllIcons.Duplicates.SendToTheRight;
                        }
                    }
                    if (icon != null) {
                        DuplicatesForm.this.r.setPaint(icon, rectangle2.getLocation());
                        return;
                    }
                }
                DuplicatesForm.this.r.setPaint(null, null);
            }
        });
    }

    private void b() {
        final EditSourceOnDoubleClickHandler.TreeMouseListener treeMouseListener = new EditSourceOnDoubleClickHandler.TreeMouseListener((JTree)this.k);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e10) {
                treeMouseListener.onDoubleClick(e10);
                CodeNode codeNode = DuplicatesForm.this.c();
                if (codeNode != null) {
                    PsiFragment psiFragment = codeNode.getFragment();
                    UsageInfo usageInfo = psiFragment.getUsageInfo();
                    if (usageInfo == null) {
                        return true;
                    }
                    PsiElement[] psiElementArray = psiFragment.getElements();
                    assert (psiElementArray.length > 0);
                    PsiElement psiElement = psiElementArray[0];
                    OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(DuplicatesForm.this.j, usageInfo.getVirtualFile(), psiElement.getTextOffset());
                    Editor editor = FileEditorManager.getInstance((Project)DuplicatesForm.this.j).openTextEditor(openFileDescriptor, false);
                    if (editor != null) {
                        HighlightManager highlightManager = HighlightManager.getInstance((Project)DuplicatesForm.this.j);
                        List list2 = (List)DuplicatesForm.this.l.get(editor);
                        if (list2 != null) {
                            for (RangeHighlighter rangeHighlighter : list2) {
                                highlightManager.removeSegmentHighlighter(editor, rangeHighlighter);
                            }
                        }
                        List<RangeHighlighter> list3 = DuplicatesForm.highlightPsiFragment(editor, psiFragment, highlightManager, 0);
                        DuplicatesForm.this.l.put(editor, list3);
                    }
                }
                return true;
            }
        }.installOn((Component)this.k);
    }

    private boolean a(MouseEvent mouseEvent, Point point, JLabel jLabel, int n2) {
        Point point2 = mouseEvent.getPoint();
        Rectangle rectangle = jLabel.getBounds();
        rectangle.setLocation(point);
        CodeNode codeNode = this.e.getSelectedCodeNode();
        if (codeNode != null && rectangle.contains(point2)) {
            this.e.setDiff(n2, codeNode);
            mouseEvent.consume();
            return true;
        }
        return false;
    }

    public JTree getDuplicatesTree() {
        return this.k;
    }

    private static DefaultActionGroup a(JComponent jComponent) {
        long l2 = s ^ 0x9182D84717FL;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        defaultActionGroup.add(actionManager.getAction("EditSource"));
        defaultActionGroup.add(actionManager.getAction("ViewSource"));
        defaultActionGroup.addSeparator();
        AnAction anAction = actionManager.getAction(f);
        anAction.registerCustomShortcutSet(anAction.getShortcutSet(), jComponent);
        defaultActionGroup.add(anAction);
        anAction = actionManager.getAction(a);
        anAction.registerCustomShortcutSet(anAction.getShortcutSet(), jComponent);
        defaultActionGroup.add(anAction);
        return defaultActionGroup;
    }

    public void addToolbarActionsTo(ContentPanel panel) {
        panel.addActionSeparator();
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){
            private static final long a = la.a(378830575578653795L, -6739356668649724544L, MethodHandles.lookup().lookupClass()).a(107242131544193L);

            protected boolean isAutoScrollMode() {
                long l2 = a ^ 0x27A185C660C6L;
                return PropertiesComponent.getInstance().getBoolean(DuplicatesForm.d);
            }

            protected void setAutoScrollMode(boolean state) {
                long l2 = a ^ 0x53F227F0A61L;
                PropertiesComponent.getInstance().setValue(DuplicatesForm.d, state);
            }
        };
        autoScrollToSourceHandler.install((JTree)this.k);
        panel.addAction((AnAction)autoScrollToSourceHandler.createToggleAction());
        if (DuplicatesForm.a()) {
            panel.addAction(new EliminateDuplicatesAction(this));
        }
        panel.addAction(new ExportHTMLAction(this.e.getRoot()));
    }

    private static boolean a() {
        for (int i10 = 0; i10 < g.getPatterns(); ++i10) {
            DuplicatesPresentation duplicatesPresentation = DuplicatesPresentationCache.getPresentation(g, i10);
            if (duplicatesPresentation == null || !duplicatesPresentation.isFixAbilityProvided()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private CodeNode c() {
        BasicTreeNode basicTreeNode;
        CodeNode codeNode = this.e.getSelectedCodeNode();
        if (codeNode != null) {
            return codeNode;
        }
        TreePath treePath = this.k.getSelectionPath();
        if (treePath != null && (basicTreeNode = (BasicTreeNode)treePath.getLastPathComponent()) instanceof GroupNode && basicTreeNode.getChildCount() > 0) {
            return (CodeNode)basicTreeNode.getChildAt(0);
        }
        return null;
    }

    private void a(DuplicatesModel duplicatesModel) {
        if (this.e != null) {
            this.e.removeListener(this.q);
        }
        this.e = duplicatesModel;
        this.k.setModel(duplicatesModel.getTreeModel());
        this.k.setSelectionModel(duplicatesModel.getSelectionModel());
        duplicatesModel.addListener(this.q);
        this.q.a();
    }

    public JComponent getComponent() {
        return this.h;
    }

    public static DuplicatesForm create(Project project, DupInfo duplicates) {
        g = duplicates;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DuplicatesForm duplicatesForm = new DuplicatesForm(project, duplicates);
        DuplicatesModel duplicatesModel = new DuplicatesModel(duplicates, project);
        duplicatesForm.a(duplicatesModel);
        return duplicatesForm;
    }

    public void dispose() {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.j);
        for (Editor editor : this.l.keySet()) {
            List<RangeHighlighter> list2 = this.l.get(editor);
            for (RangeHighlighter rangeHighlighter : list2) {
                highlightManager.removeSegmentHighlighter(editor, rangeHighlighter);
            }
        }
        DuplicatesProfileCache.clear(this.i);
        DuplicatesPresentationCache.clear(this.i);
    }

    public static List<RangeHighlighter> highlightPsiFragment(Editor editor, PsiFragment fragment, HighlightManager highlightManager, int firstOffset) {
        PsiElement[] psiElementArray = fragment.getElements();
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        TextAttributes textAttributes = editorColorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        ArrayList<RangeHighlighter> arrayList = new ArrayList<RangeHighlighter>();
        for (PsiElement psiElement : psiElementArray) {
            if (psiElement == null) continue;
            TextRange textRange = psiElement.getTextRange();
            int n2 = textRange.getStartOffset() - firstOffset;
            int n3 = textRange.getEndOffset() - firstOffset;
            highlightManager.addRangeHighlight(editor, n2, n3, textAttributes, false, arrayList);
        }
        return arrayList;
    }

    static {
        s = la.a(-7070008562506251495L, 5402077056481940364L, MethodHandles.lookup().lookupClass()).a(169591800024343L);
        long l2 = s ^ 0x1966A476F561L;
        b = DataKey.create((String)"DUPLICATES_MODEL");
    }

    private class EliminateDuplicatesAction
    extends AnAction {
        final /* synthetic */ DuplicatesForm this$0;
        private static final long a = la.a(5415758689424777137L, 524393026112037666L, MethodHandles.lookup().lookupClass()).a(76152084378174L);

        EliminateDuplicatesAction(DuplicatesForm duplicatesForm) {
            long l2 = a ^ 0x38F1313D1A59L;
            this.this$0 = duplicatesForm;
            super(DupLocatorBundle.message("eliminate.duplicates.action.text", new Object[0]), DupLocatorBundle.message("eliminate.duplicates.action.text", new Object[0]), AllIcons.Actions.Replace);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                EliminateDuplicatesAction.a(0);
            }
            CodeNode codeNode = this.this$0.c();
            assert (codeNode != null);
            DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
            assert (duplicatesPresentation != null);
            duplicatesPresentation.applyFix(codeNode);
        }

        public void update(@NotNull AnActionEvent e10) {
            CodeNode codeNode;
            boolean bl2;
            if (e10 == null) {
                EliminateDuplicatesAction.a(1);
            }
            boolean bl3 = bl2 = (codeNode = this.this$0.c()) != null;
            if (bl2) {
                DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
                bl2 = duplicatesPresentation != null && duplicatesPresentation.isFixAvailable(codeNode);
            }
            e10.getPresentation().setEnabled(bl2);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x4CBE664F74CAL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$EliminateDuplicatesAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyGlassPanePainter
    extends AbstractPainter {
        private Icon a;
        private Point b;

        private MyGlassPanePainter() {
        }

        public boolean setPaint(Icon icon, Point point) {
            this.a = (Icon)this.setNeedsRepaint(this.a, icon);
            this.b = (Point)this.setNeedsRepaint(this.b, point);
            return this.needsRepaint();
        }

        public void executePaint(Component component, Graphics2D g10) {
            if (this.a == null) {
                return;
            }
            this.a.paintIcon(component, g10, this.b.x, this.b.y);
        }
    }

    private class MyDuplicatesModelListener
    implements DuplicatesModel.Listener {
        private final Alarm a = new Alarm();

        private MyDuplicatesModelListener() {
        }

        @Override
        public void onSelectionChanged() {
            this.a.cancelAllRequests();
            DuplicatesModel duplicatesModel = DuplicatesForm.this.e;
            this.a.addRequest(() -> {
                if (duplicatesModel == DuplicatesForm.this.e && DuplicatesForm.this.h.isDisplayable()) {
                    this.a();
                }
            }, 200);
        }

        private void a() {
            JComponent jComponent;
            CodeNode codeNode = DuplicatesForm.this.e.getLeft();
            CodeNode codeNode2 = DuplicatesForm.this.e.getRight();
            if (codeNode == null || codeNode2 == null) {
                return;
            }
            DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
            DuplicatesView duplicatesView = null;
            if (duplicatesPresentation != null && (duplicatesView = (DuplicatesView)DuplicatesForm.this.n.get(duplicatesPresentation)) == null) {
                duplicatesView = duplicatesPresentation.createView(DuplicatesForm.this.j);
                Disposer.register((Disposable)DuplicatesForm.this, (Disposable)duplicatesView);
                DuplicatesForm.this.n.put(duplicatesPresentation, duplicatesView);
            }
            JComponent jComponent2 = DuplicatesForm.this.h.getSecondComponent();
            JComponent jComponent3 = jComponent = duplicatesView != null ? duplicatesView.getComponent() : null;
            if (jComponent != jComponent2) {
                if (jComponent2 != null) {
                    jComponent2.setVisible(false);
                }
                DuplicatesForm.this.h.setSecondComponent(jComponent);
                if (jComponent != null) {
                    jComponent.setMinimumSize((Dimension)JBUI.size((int)10));
                    jComponent.setVisible(true);
                }
            }
            if (duplicatesView != null) {
                duplicatesView.setContent(codeNode, codeNode2);
            }
            DuplicatesForm.this.k.repaint();
        }
    }

    private static class SendToAction
    extends AnAction {
        private final int a;
        private static final long b = la.a(-1919243017195452621L, -7176200115327118688L, MethodHandles.lookup().lookupClass()).a(189676220352250L);

        SendToAction(String text, String description, Icon icon, String actionId, int diffIndex) {
            super(text, description, icon);
            this.a = diffIndex;
            this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)actionId), null);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SendToAction.a(0);
            }
            DuplicatesModel duplicatesModel = (DuplicatesModel)b.getData(e10.getDataContext());
            duplicatesModel.setDiff(this.a, duplicatesModel.getSelectedCodeNode());
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SendToAction.a(1);
            }
            Presentation presentation = e10.getPresentation();
            DuplicatesModel duplicatesModel = (DuplicatesModel)b.getData(e10.getDataContext());
            if (duplicatesModel == null) {
                presentation.setEnabled(false);
                return;
            }
            CodeNode codeNode = duplicatesModel.getSelectedCodeNode();
            if (codeNode == null) {
                presentation.setEnabled(false);
                return;
            }
            presentation.setEnabled(true);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = b ^ 0x4C3ABF5B9478L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$SendToAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySplitter
    extends JBSplitter
    implements DataProvider {
        private final DataProvider a;
        final /* synthetic */ DuplicatesForm this$0;
        private static final long b = la.a(188415672581635693L, -1758764089883304512L, MethodHandles.lookup().lookupClass()).a(119634488502705L);

        MySplitter(DuplicatesForm duplicatesForm, DataProvider dataProvider) {
            long l2 = b ^ 0x722AE9981E71L;
            this.this$0 = duplicatesForm;
            super("DuplicatesForm.settings", 0.3f);
            this.a = dataProvider;
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MySplitter.a(0);
            }
            return this.a.getData(dataId);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x1B642A4AB43AL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/dupLocator/resultUI/DuplicatesForm$MySplitter", "getData"));
        }
    }

    private class MyColoredTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long a = la.a(1646973010715371532L, 7782782112374043929L, MethodHandles.lookup().lookupClass()).a(118389484315906L);

        private MyColoredTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            long l2 = a ^ 0x6B1561A69E06L;
            JPanel jPanel = new JPanel(new BorderLayout(5, 0));
            Color color = UIUtil.getTreeBackground((boolean)sel, (boolean)true);
            UIUtil.changeBackGround((Component)jPanel, (Color)color);
            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
            simpleColoredComponent.setOpaque(true);
            jPanel.add((Component)simpleColoredComponent, "Center");
            if (value instanceof GroupNode) {
                ((GroupNode)value).getTitle(sel).customize(simpleColoredComponent);
            } else if (value instanceof CodeNode) {
                CodeNode codeNode = (CodeNode)value;
                jPanel.add((Component)DuplicatesForm.this.m, "West");
                DuplicatesForm.this.o.setIcon(codeNode.isLeftInDiff() ? AllIcons.Duplicates.SendToTheLeft : AllIcons.Duplicates.SendToTheLeftGrayed);
                DuplicatesForm.this.c.setIcon(codeNode.isRightInDiff() ? AllIcons.Duplicates.SendToTheRight : AllIcons.Duplicates.SendToTheRightGrayed);
                codeNode.getTitle(sel).customize(simpleColoredComponent);
                jPanel.setToolTipText(DupLocatorBundle.message("tooltip.tree.text", new Object[0]));
            }
            return jPanel;
        }
    }

    public static class SendToLeftAction
    extends SendToAction {
        private static final long c = la.a(-4300908810093310388L, -4767198842913049948L, MethodHandles.lookup().lookupClass()).a(1419704313158L);

        public SendToLeftAction() {
            long l2 = c ^ 0x3422374722F8L;
            super(DupLocatorBundle.message("duplicates.send.to.left.action", new Object[0]), DupLocatorBundle.message("duplicates.send.to.left.action.description", new Object[0]), AllIcons.Duplicates.SendToTheLeft, DuplicatesForm.f, 0);
        }
    }

    public static class SendToRightAction
    extends SendToAction {
        private static final long c = la.a(-7789233503921239036L, -3236374503231146421L, MethodHandles.lookup().lookupClass()).a(265550618843317L);

        public SendToRightAction() {
            long l2 = c ^ 0x1D70D8514E46L;
            super(DupLocatorBundle.message("duplicates.send.to.right.action", new Object[0]), DupLocatorBundle.message("duplicates.send.to.right.action.description", new Object[0]), AllIcons.Duplicates.SendToTheRight, DuplicatesForm.a, 1);
        }
    }
}

