/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.util.tracer;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.util.tracer.IntervalStatistics;
import org.jetbrains.idea.perforce.util.tracer.Tracer;

class AverageByKindTimeStatistics<Kind extends Enum>
extends IntervalStatistics<Pair<Kind, Long>, Data<Kind>, Average<Kind>>
implements Tracer<Kind, Long> {
    AverageByKindTimeStatistics(long intervalInMillis, int historyQueueSize, @Nullable Runnable switchListener) {
        super(intervalInMillis, historyQueueSize, () -> new Data(), () -> new Average(), switchListener);
    }

    @Override
    public Long start(Kind kind, String presentation) {
        return System.currentTimeMillis();
    }

    @Override
    public void stop(@NotNull Long key, Kind kind, String presentation) {
        if (key == null) {
            AverageByKindTimeStatistics.$$$reportNull$$$0(0);
        }
        this.step(new Pair(kind, (Object)(System.currentTimeMillis() - key)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/idea/perforce/util/tracer/AverageByKindTimeStatistics", "stop"));
    }

    public static class Average<Kind>
    implements Consumer<Data<Kind>> {
        private final Map<Kind, Pair<BigDecimal, Long>> myMap = new HashMap<Kind, Pair<BigDecimal, Long>>();

        public void consume(Data<Kind> kindData) {
            Map<Kind, Pair<Long, Integer>> comingMap = kindData.getMap();
            for (Kind kind : comingMap.keySet()) {
                Pair<BigDecimal, Long> existing = this.myMap.get(kind);
                Pair<Long, Integer> comingValue = comingMap.get(kind);
                BigDecimal valueToAdd = new BigDecimal((Long)comingValue.getFirst());
                if (existing == null) {
                    this.myMap.put(kind, (Pair<BigDecimal, Long>)new Pair((Object)valueToAdd, (Object)((Integer)comingValue.getSecond()).longValue()));
                    continue;
                }
                this.myMap.put(kind, (Pair<BigDecimal, Long>)new Pair((Object)((BigDecimal)existing.getFirst()).add(valueToAdd), (Object)((Long)existing.getSecond() + (long)((Integer)comingValue.getSecond()).intValue())));
            }
        }

        public Map<Kind, Pair<BigDecimal, Long>> getMap() {
            return Collections.unmodifiableMap(this.myMap);
        }
    }

    public static class Data<Kind>
    implements Consumer<Pair<Kind, Long>> {
        private final Map<Kind, Pair<Long, Integer>> myMap = new HashMap<Kind, Pair<Long, Integer>>();

        public void consume(Pair<Kind, Long> kindLongPair) {
            Object kind = kindLongPair.getFirst();
            Pair<Long, Integer> current = this.myMap.get(kind);
            if (current == null) {
                this.myMap.put(kind, (Pair<Long, Integer>)new Pair(kindLongPair.getSecond(), (Object)1));
            } else {
                this.myMap.put(kind, (Pair<Long, Integer>)new Pair((Object)((Long)current.getFirst() + (Long)kindLongPair.getSecond()), (Object)((Integer)current.getSecond() + 1)));
            }
        }

        public Map<Kind, Pair<Long, Integer>> getMap() {
            return this.myMap;
        }
    }
}

