/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.highlighting.JSTextAttributeKeysProvider;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAttributeKeysProvider
extends JSTextAttributeKeysProvider {
    @Override
    public TextAttributesKey getTextAttributesKeyForClass() {
        return TypeScriptHighlighter.TS_CLASS;
    }

    @Override
    public TextAttributesKey getTextAttributesKeyForInstanceMethod() {
        return TypeScriptHighlighter.TS_INSTANCE_MEMBER_FUNCTION;
    }

    @Override
    public TextAttributesKey getTextAttributesKeyForInstanceField() {
        return TypeScriptHighlighter.TS_INSTANCE_MEMBER_VARIABLE;
    }

    @Override
    public TextAttributesKey getAttributesKeyForLocalVariable() {
        return TypeScriptHighlighter.TS_LOCAL_VARIABLE;
    }

    @Override
    public TextAttributesKey getAttributesKeyForGlobalVariable() {
        return TypeScriptHighlighter.TS_GLOBAL_VARIABLE;
    }

    @Override
    public TextAttributesKey getAttributesKeyForParameter() {
        return TypeScriptHighlighter.TS_PARAMETER;
    }

    @Override
    @Nullable
    public JSSemanticHighlightingUtil.TextAttributeKeyInfo getTextAttributeKeyInfoForResolveResult(@NotNull PsiElement resolve, JSHighlighter highlighter) {
        if (resolve == null) {
            TypeScriptAttributeKeysProvider.$$$reportNull$$$0(0);
        }
        if (resolve instanceof TypeScriptModule) {
            return new JSSemanticHighlightingUtil.TextAttributeKeyInfo(TypeScriptHighlighter.TS_MODULE_NAME, "moduleName");
        }
        if (resolve instanceof TypeScriptPropertySignature) {
            return new JSSemanticHighlightingUtil.TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript property signature");
        }
        if (resolve instanceof TypeScriptGenericOrMappedTypeParameter) {
            return new JSSemanticHighlightingUtil.TextAttributeKeyInfo(highlighter.getMappedKey(TypeScriptHighlighter.TS_TYPE_PARAMETER), "TypeScript type parameter");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "com/intellij/lang/javascript/highlighting/TypeScriptAttributeKeysProvider", "getTextAttributeKeyInfoForResolveResult"));
    }
}

