/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.printing;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.DarculaAwareGraph2DPrinter;
import com.intellij.openapi.graph.builder.actions.printing.Graph2DPrintPreviewPanel;
import com.intellij.openapi.graph.builder.actions.printing.PrintGraphAction;
import com.intellij.openapi.graph.view.BackgroundRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.PrintPreviewPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.UIUtil;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PrintPreviewAction
extends AbstractGraphAction<Graph2D> {
    public PrintPreviewAction() {
    }

    public PrintPreviewAction(Graph2D graph2D) {
        super(graph2D);
    }

    @Override
    public void actionPerformed(AnActionEvent e, final Graph2D graph2D) {
        Project project = PrintPreviewAction.getProject(e);
        if (project == null) {
            return;
        }
        final PrinterJob printJob = PrinterJob.getPrinterJob();
        Graph2DView view = PrintPreviewAction.getGraph2DView(graph2D);
        final GraphBuilder builder = (GraphBuilder)((Object)e.getDataContext().getData(GraphBuilder.GRAPH_BUILDER_KEY));
        final BackgroundRenderer renderer = view.getBackgroundRenderer();
        PrintPreviewPanel panel = Graph2DPrintPreviewPanel.createPanel(project, printJob, new DarculaAwareGraph2DPrinter(view), printJob.defaultPage());
        final JPanel jPanel = panel.getJPanel();
        for (JButton button : UIUtil.findComponentsOfType((JComponent)jPanel, JButton.class)) {
            if (!button.getText().startsWith("Print")) continue;
            button.setVisible(false);
            break;
        }
        new DialogWrapper(project){
            {
                super(arg0);
                this.setTitle(ActionsBundle.message((String)"action.Graph.print.preview", (Object[])new Object[0]));
                this.init();
                this.getOKAction().putValue("Name", "Print...");
            }

            protected String getDimensionServiceKey() {
                return "Diagram.Print.Preview.Dialog";
            }

            protected JComponent createCenterPanel() {
                PrintGraphAction.setupBackgroundBeforePrint(graph2D, renderer, builder);
                ApplicationManager.getApplication().invokeLater(() -> PrintGraphAction.rollbackBackgroundAfterPrint(renderer, builder));
                return jPanel;
            }

            protected void doOKAction() {
                super.doOKAction();
                PrintGraphAction.doPrint(graph2D, renderer, builder, printJob);
            }
        }.show();
    }

    @Override
    public void update(AnActionEvent e, Graph2D graph2D) {
        e.getPresentation().setText(ActionsBundle.message((String)"action.Graph.print.preview", (Object[])new Object[0]));
        e.getPresentation().setIcon(AllIcons.Graph.PrintPreview);
    }
}

