/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.tagtoattribute;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.sixrr.xrp.base.BaseTagRefactoringHandler;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.tagtoattribute.TagToAttributeDialog;
import com.sixrr.xrp.tagtoattribute.TagToAttributeProcessor;
import org.jetbrains.annotations.Nullable;

class TagToAttributeHandler
extends BaseTagRefactoringHandler {
    TagToAttributeHandler() {
    }

    @Override
    protected String getHelpID() {
        return "refactoring.tagToAttribute";
    }

    @Override
    protected String getRefactoringName() {
        return "Tag To Attribute";
    }

    @Override
    protected void handleTag(XmlTag tag, Project project) {
        TagToAttributeDialog dialog = new TagToAttributeDialog(tag);
        if (!dialog.showAndGet()) {
            return;
        }
        Context context = dialog.getContext();
        String attributeName = dialog.getAttributeName();
        boolean previewUsages = dialog.isPreviewUsages();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            TagToAttributeProcessor processor = new TagToAttributeProcessor(tag, attributeName, context);
            processor.setPreviewUsages(previewUsages);
            processor.run();
        }, "Replace Tag With Attribute", null);
    }

    @Override
    @Nullable
    protected String getProblemMessage(XmlTag tag) {
        if (tag.getParentTag() == null) {
            return "Cannot perform the refactoring.\nThis refactoring is not available for top-level tags.";
        }
        return null;
    }
}

