/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.idea.perforce.perforce.jobs.DefaultGb;
import org.jetbrains.idea.perforce.perforce.jobs.ErrorReporter;
import org.jetbrains.idea.perforce.perforce.jobs.JobDetailsLoader;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobFieldValue;

class SelfLoadingJobDetailsPanel {
    private JPanel myMain;
    private final Project myProject;
    private final PerforceJob myJob;
    private final List<Pair<String, String>> myDetails;
    private final JPanel myPanel;

    SelfLoadingJobDetailsPanel(Project project, PerforceJob job) {
        this.myProject = project;
        this.myJob = job;
        this.myDetails = new ArrayList<Pair<String, String>>();
        this.myPanel = new JPanel(new BorderLayout());
        this.createDetailsPanel();
    }

    private void initData() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.load()) {
                ApplicationManager.getApplication().invokeLater(this::displayJobDetails, ModalityState.any());
            }
        });
    }

    private void displayJobDetails() {
        this.myMain.removeAll();
        GridBag gb = new GridBag();
        for (Pair<String, String> detail : this.myDetails) {
            JTextArea text = new JTextArea(((String)detail.getSecond()).trim());
            text.setEditable(false);
            text.setBackground(UIUtil.getBgFillColor((Component)this.myMain));
            gb.nextLine();
            this.myMain.add((Component)new JLabel((String)detail.getFirst() + ":"), gb.next().fillCellNone().weightx(0.0));
            this.myMain.add((Component)text, gb.next().fillCellHorizontally().weightx(1.0));
        }
        this.myMain.add((Component)new JPanel(), gb.nextLine().next().coverLine(2).weighty(1.0));
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    private void createDetailsPanel() {
        this.myMain = new JPanel(new GridBagLayout());
        GridBagConstraints gb = DefaultGb.create();
        gb.anchor = 10;
        gb.fill = 1;
        gb.weighty = 1.0;
        gb.weightx = 1.0;
        this.myMain.add((Component)new JLabel("Loading..."), gb);
        this.myPanel.add((Component)this.myMain, "North");
        this.initData();
    }

    private boolean load() {
        try {
            List<Pair<String, String>> items = new JobDetailsLoader(this.myProject).load(this.myJob);
            if (items != null) {
                PerforceJobFieldValue nameValue = this.myJob.getNameValue();
                if (nameValue != null) {
                    String fieldName = nameValue.getField().getName();
                    String name = nameValue.getValue();
                    items.remove(Pair.create((Object)fieldName, (Object)name));
                }
                this.myDetails.addAll(items);
            }
        }
        catch (VcsException e) {
            new ErrorReporter("loading job details").report(this.myProject, e);
            return false;
        }
        return true;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }
}

