/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigInspection
extends LocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"typescript.config.inspection", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiFile file2;
        if (holder == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(3);
        }
        if (!((file2 = holder.getFile()).getFileType() instanceof TypeScriptConfigFileType)) {
            JsonElementVisitor jsonElementVisitor = new JsonElementVisitor();
            if (jsonElementVisitor == null) {
                TypeScriptConfigInspection.$$$reportNull$$$0(4);
            }
            return jsonElementVisitor;
        }
        JsonElementVisitor jsonElementVisitor = new JsonElementVisitor(){

            public void visitProperty(@NotNull JsonProperty o) {
                String name;
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("paths".equals(name = o.getName())) {
                    this.validatePathsProperty(o);
                } else if ("checkJs".equals(name)) {
                    this.validateCheckJs(o);
                }
                super.visitProperty(o);
            }

            private void validateCheckJs(@NotNull JsonProperty o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (TypeScriptConfigInspection.hasPropertyInParentObject(o, "allowJs")) {
                    return;
                }
                TypeScriptConfig config2 = TypeScriptConfigInspection.getConfig(holder, file2);
                if (config2 == null) {
                    return;
                }
                if (!config2.checkJs() || config2.allowJs()) {
                    return;
                }
                this.reportError(o, JSBundle.message((String)"typescript.config.inspection.checkjs.info", (Object[])new Object[0]), "allowJs", "true");
            }

            private void validatePathsProperty(@NotNull JsonProperty o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (TypeScriptConfigInspection.hasPropertyInParentObject(o, "baseUrl")) {
                    return;
                }
                TypeScriptConfig config2 = TypeScriptConfigInspection.getConfig(holder, file2);
                if (config2 == null) {
                    return;
                }
                if (config2.getRawCompilerOption("baseUrl") != null) {
                    return;
                }
                this.reportError(o, JSBundle.message((String)"typescript.config.inspection.path.mapping.info", (Object[])new Object[0]), "baseUrl", "\".\"");
            }

            private void reportError(@NotNull JsonProperty o, @NotNull String text, String property, String value) {
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(4);
                }
                JsonValue element = o.getNameElement();
                TextRange range = element.getTextRange();
                holder.registerProblem((PsiElement)element, range.shiftLeft(range.getStartOffset()), text, new LocalQuickFix[]{new InsertProperty(property, value)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptConfigInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitProperty";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "validateCheckJs";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "validatePathsProperty";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reportError";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jsonElementVisitor == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(5);
        }
        return jsonElementVisitor;
    }

    @Nullable
    private static TypeScriptConfig getConfig(@NotNull ProblemsHolder holder, @NotNull PsiFile file2) {
        TypeScriptConfigService service;
        if (holder == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(7);
        }
        return (service = TypeScriptConfigService.Provider.get(holder.getProject())) == null ? null : service.parseConfigFile(file2.getVirtualFile());
    }

    private static boolean hasPropertyInParentObject(@NotNull JsonProperty o, @NotNull String propertyName) {
        PsiElement parent;
        if (o == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(8);
        }
        if (propertyName == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(9);
        }
        if (!((parent = o.getParent()) instanceof JsonObject)) {
            return true;
        }
        JsonObject compilerOptions = (JsonObject)parent;
        return compilerOptions.findProperty(propertyName) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptConfigInspection";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptConfigInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasPropertyInParentObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InsertProperty
    implements LocalQuickFix {
        private final String myName;
        private final String myValue;

        InsertProperty(@NotNull String name, @NotNull String value) {
            if (name == null) {
                InsertProperty.$$$reportNull$$$0(0);
            }
            if (value == null) {
                InsertProperty.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myValue = value;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Add required property" == null) {
                InsertProperty.$$$reportNull$$$0(2);
            }
            return "Add required property";
        }

        @Nls
        @NotNull
        public String getName() {
            String string = JSBundle.message((String)"typescript.config.inspection.fix.pattern", (Object[])new Object[]{this.myName});
            if (string == null) {
                InsertProperty.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                InsertProperty.$$$reportNull$$$0(4);
            }
            if (descriptor2 == null) {
                InsertProperty.$$$reportNull$$$0(5);
            }
            if ((element = descriptor2.getPsiElement()) == null) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JsonProperty)) {
                return;
            }
            PsiElement jsonObject = parent.getParent();
            if (!(jsonObject instanceof JsonObject)) {
                return;
            }
            WriteAction.run(() -> {
                if (project == null) {
                    InsertProperty.$$$reportNull$$$0(6);
                }
                JsonProperty property = TypeScriptConfigUtil.createJsonProperty(project, this.myName, this.myValue, true);
                PsiElement comma = property.getNextSibling();
                assert (comma != null);
                PsiElement newElement = jsonObject.addBefore(property.copy(), parent);
                jsonObject.addAfter(comma.copy(), newElement);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptConfigInspection$InsertProperty";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptConfigInspection$InsertProperty";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

