/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerConfigUtil {
    public static final String SOURCE_MAP = "--sourceMap";
    public static final String COMPILED_FILES = "compiledFiles";
    private static final String FILENAME = "filename";
    private static final String MESSAGE = "message";
    private static final String LINE = "line";
    private static final String COLUMN = "column";
    private static final String CATEGORY = "category";

    @NotNull
    public static String getConfigIdByConfig(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(0);
        }
        String string = TypeScriptCompilerConfigUtil.getConfigIdByConfig(config2.getConfigFile());
        if (string == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String getConfigIdByConfig(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(2);
        }
        return JSHighlightingInfoBuilder.toPath(file2);
    }

    @Nullable
    public static String getConfigIdForFile(@Nullable Project project, @NotNull VirtualFile file2) {
        TypeScriptConfig config2;
        if (file2 == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(3);
        }
        return (config2 = TypeScriptConfigUtil.getConfigForFile(project, file2)) == null ? null : TypeScriptCompilerConfigUtil.getConfigIdByConfig(config2);
    }

    public static boolean isConfig(VirtualFile file2, FileType type) {
        return type instanceof TypeScriptConfigFileType;
    }

    @Nullable
    public static TypeScriptConfig getConfigForFile(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(4);
        }
        return TypeScriptConfigUtil.getConfigForFile(project, file2);
    }

    @Nullable
    public static String normalizeNameAndPath(@NotNull VirtualFile name) {
        if (name == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(5);
        }
        return JSLanguageServiceUtil.normalizeNameAndPath(name);
    }

    public static void refreshFiles(@NotNull Project project, @NotNull Collection<String> files) {
        if (project == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(6);
        }
        if (files == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(7);
        }
        Runnable refresh = () -> {
            Collection result2;
            if (project == null) {
                TypeScriptCompilerConfigUtil.$$$reportNull$$$0(14);
            }
            if (files == null) {
                TypeScriptCompilerConfigUtil.$$$reportNull$$$0(15);
            }
            if ((result2 = (Collection)ReadAction.compute(() -> {
                if (project == null) {
                    TypeScriptCompilerConfigUtil.$$$reportNull$$$0(16);
                }
                if (files == null) {
                    TypeScriptCompilerConfigUtil.$$$reportNull$$$0(17);
                }
                if (project.isDisposed()) {
                    return ContainerUtil.emptyList();
                }
                HashSet dirtyFiles = ContainerUtil.newHashSet();
                for (String file2 : files) {
                    String systemIndependentName = FileUtil.toSystemIndependentName((String)file2);
                    VirtualFile path = LocalFileSystem.getInstance().findFileByPath(systemIndependentName);
                    if (path != null) {
                        dirtyFiles.add(path);
                        continue;
                    }
                    String parentDir = VfsUtil.getParentDir((String)systemIndependentName);
                    if (StringUtil.isEmpty((String)parentDir) || (path = LocalFileSystem.getInstance().findFileByPath(parentDir)) == null) continue;
                    dirtyFiles.add(path);
                }
                for (String file2 : dirtyFiles) {
                    Boolean data;
                    if (file2.isDirectory() || Boolean.TRUE.equals(data = (Boolean)file2.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER))) continue;
                    file2.putUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER, (Object)Boolean.TRUE);
                }
                return dirtyFiles;
            })).isEmpty()) {
                return;
            }
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)result2));
        };
        ApplicationManager.getApplication().executeOnPooledThread(refresh);
    }

    public static void processEmitFilesAfterCompiling(@NotNull Project project, @NotNull JsonObject objectWithFiles, @NotNull String fieldName) {
        JsonElement emitFiles;
        if (project == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(8);
        }
        if (objectWithFiles == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(9);
        }
        if (fieldName == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(10);
        }
        if ((emitFiles = objectWithFiles.get(fieldName)) != null) {
            assert (emitFiles.isJsonArray());
            List<String> files = TypeScriptCompilerConfigUtil.jsonArrayToStringArray(emitFiles);
            if (files.isEmpty()) {
                return;
            }
            TypeScriptCompilerConfigUtil.refreshFiles(project, files);
        }
    }

    @NotNull
    public static List<String> jsonArrayToStringArray(JsonElement emitFiles) {
        List list = ContainerUtil.map((Collection)ContainerUtil.newArrayList((Iterable)emitFiles.getAsJsonArray()), JsonElement::getAsString);
        if (list == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static GlobalSearchScope getCompileScope(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(12);
        }
        GlobalSearchScope globalSearchScope = ScopeChooserUtils.findScopeByName((Project)project, (String)TypeScriptCompilerSettings.getSettings(project).getScopeName());
        if (globalSearchScope == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectWithFiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigIdByConfig";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "jsonArrayToStringArray";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigIdByConfig";
                break;
            }
            case 1: 
            case 11: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfigIdForFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalizeNameAndPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processEmitFilesAfterCompiling";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCompileScope";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$refreshFiles$1";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

