/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.JSModuleFixDescriptor;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ModuleFixCreator {
    @NotNull
    private final List<JSModuleFixDescriptor> myFixDescriptors;
    @NotNull
    private final Set<VirtualFile> myPredefinedFiles;
    @NotNull
    private final ModuleReferenceInfo myModuleReferenceInfo;
    private boolean myNoFixesShouldBeSuggested;
    @NotNull
    private final GlobalSearchScope myScope;

    public ModuleFixCreator(@NotNull Project project, @NotNull Set<VirtualFile> predefinedFiles, @NotNull ModuleReferenceInfo moduleReferenceInfo) {
        if (project == null) {
            ModuleFixCreator.$$$reportNull$$$0(0);
        }
        if (predefinedFiles == null) {
            ModuleFixCreator.$$$reportNull$$$0(1);
        }
        if (moduleReferenceInfo == null) {
            ModuleFixCreator.$$$reportNull$$$0(2);
        }
        this.myPredefinedFiles = predefinedFiles;
        this.myModuleReferenceInfo = moduleReferenceInfo;
        this.myFixDescriptors = new ArrayList<JSModuleFixDescriptor>();
        this.myScope = GlobalSearchScope.allScope((Project)project);
    }

    public void addFix(@NotNull JSModuleFixDescriptor fixDescriptor) {
        if (fixDescriptor == null) {
            ModuleFixCreator.$$$reportNull$$$0(3);
        }
        if (this.myNoFixesShouldBeSuggested) {
            return;
        }
        VirtualFile file2 = fixDescriptor.getFromFile();
        if (this.myPredefinedFiles.contains(file2)) {
            this.myNoFixesShouldBeSuggested = true;
            this.myFixDescriptors.clear();
            return;
        }
        if (this.myFixDescriptors.contains(fixDescriptor)) {
            return;
        }
        assert (this.myScope.getProject() != null);
        if (!this.myScope.contains(file2) && !NodeCoreLibraryManager.getInstance(this.myScope.getProject()).isCoreModuleLibraryFile(file2)) {
            return;
        }
        this.myFixDescriptors.add(fixDescriptor);
    }

    public boolean isGlobalPredefinedElement(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            ModuleFixCreator.$$$reportNull$$$0(4);
        }
        return (file2 = element.getContainingFile()) != null && file2.isValid() && this.myPredefinedFiles.contains(file2.getVirtualFile()) && element instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)element).getNamespace() == null;
    }

    public boolean isNoFixesShouldBeSuggested() {
        return this.myNoFixesShouldBeSuggested;
    }

    public void addShortModulesFor(@NotNull List<JSModuleFixDescriptor> fixDescriptors) {
        if (fixDescriptors == null) {
            ModuleFixCreator.$$$reportNull$$$0(5);
        }
        if (fixDescriptors.isEmpty()) {
            return;
        }
        ArrayList<JSModuleFixDescriptor> descriptors = new ArrayList<JSModuleFixDescriptor>(fixDescriptors);
        Set existingPaths = descriptors.stream().map(JSModuleFixDescriptor::getFromPath).collect(Collectors.toSet());
        for (JSModuleFixDescriptor descriptor2 : descriptors) {
            JSModuleFixDescriptor newDescriptor;
            VirtualFile file2;
            VirtualFile libModuleRoot;
            int idx;
            String key;
            String path;
            if (descriptor2.getModuleType().equals((Object)ModuleType.amd) || (path = descriptor2.getFromPath()).startsWith(".") || path.startsWith("/") || FileUtil.isAbsolute((String)path) || existingPaths.contains(key = (idx = path.indexOf(47)) > 0 ? path.substring(0, idx) : path) || key.isEmpty() || "react".equalsIgnoreCase(key) || (libModuleRoot = JSLibraryUtil.getLibraryFolder(file2 = descriptor2.getFromFile(), "node_modules")) == null) continue;
            Pair<Boolean, NodeModuleSearchUtil.ModuleMainFiles> moduleInPackage = NodeModuleSearchUtil.findMainModuleInPackage(libModuleRoot);
            NodeModuleSearchUtil.ModuleMainFiles mainFiles = (NodeModuleSearchUtil.ModuleMainFiles)moduleInPackage.getSecond();
            VirtualFile selectedMainFile = mainFiles.getMain();
            if (!file2.equals(selectedMainFile) && mainFiles.getJsNextMain() != null) {
                selectedMainFile = mainFiles.getJsNextMain();
            }
            if (selectedMainFile == null) continue;
            existingPaths.add(key);
            if (this.myModuleReferenceInfo.getParentName() == null) {
                String target = descriptor2.getFirstWordInExportsName();
                if (target == null) {
                    String string = target = descriptor2.getTail() != null && descriptor2.getTail().length > 0 ? descriptor2.getTail()[0] : null;
                }
                if (target == null) {
                    target = descriptor2.getFirstWordInFile();
                }
                newDescriptor = new JSModuleFixDescriptor(descriptor2.getModuleType(), key, selectedMainFile, descriptor2.getFirstWordInFile(), target);
            } else {
                newDescriptor = new JSModuleFixDescriptor(descriptor2.getModuleType(), key, selectedMainFile, descriptor2.getFirstWordInFile(), null);
            }
            this.myFixDescriptors.add(newDescriptor);
        }
    }

    @NotNull
    public List<JSModuleFixDescriptor> getFixDescriptors() {
        List<JSModuleFixDescriptor> list = this.myFixDescriptors;
        if (list == null) {
            ModuleFixCreator.$$$reportNull$$$0(6);
        }
        return list;
    }

    public boolean isEmpty() {
        return this.myFixDescriptors.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReferenceInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixDescriptors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/ModuleFixCreator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/ModuleFixCreator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalPredefinedElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addShortModulesFor";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ModuleType {
        nodejs,
        es6,
        amd;

    }
}

