/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.bower.BowerCommandLineUtil;
import com.intellij.lang.javascript.bower.BowerInstalledPackagesPanel;
import com.intellij.lang.javascript.bower.BowerPackagingService;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.BowerValidationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class BowerPackagesView {
    private static final Logger LOG = Logger.getInstance(BowerPackagesView.class);
    private final Project myProject;
    private final BowerInstalledPackagesPanel myPackagesPanel;
    private final PackagesNotificationPanel myPackagesNotificationPanel;
    private final JPanel myComponent;
    private BowerSettings myCurrentSettings;

    public BowerPackagesView(@NotNull Project project) {
        if (project == null) {
            BowerPackagesView.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Dependencies", (boolean)false));
        this.myPackagesNotificationPanel = new PackagesNotificationPanel();
        this.myPackagesPanel = new BowerInstalledPackagesPanel(project, this.myPackagesNotificationPanel);
        panel.add((Component)((Object)this.myPackagesPanel), "Center");
        panel.add((Component)this.myPackagesNotificationPanel.getComponent(), "South");
        this.myComponent = panel;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            BowerPackagesView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    public void onSettingsChanged(@NotNull BowerSettings settings, @NotNull List<BowerValidationInfo> errors) {
        if (settings == null) {
            BowerPackagesView.$$$reportNull$$$0(2);
        }
        if (errors == null) {
            BowerPackagesView.$$$reportNull$$$0(3);
        }
        if (settings.equals(this.myCurrentSettings)) {
            return;
        }
        this.myCurrentSettings = settings;
        BowerPackagingService service = null;
        this.myPackagesNotificationPanel.hide();
        this.myPackagesNotificationPanel.removeAllLinkHandlers();
        if (errors.isEmpty()) {
            service = new BowerPackagingService(this.myProject, settings);
            this.checkVersion(settings);
        } else {
            this.showErrors(errors);
        }
        this.myPackagesPanel.updatePackages((PackageManagementService)service);
    }

    private void showErrors(@NotNull List<BowerValidationInfo> errors) {
        if (errors == null) {
            BowerPackagesView.$$$reportNull$$$0(4);
        }
        List errorHtmlDescriptions = ContainerUtil.map(errors, info -> info.getErrorHtmlDescription());
        String styleTag = UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont());
        String html = "<html>" + styleTag + "<body><div style='padding-left:4px;'>" + StringUtil.join((Collection)errorHtmlDescriptions, (String)"<div style='padding-top:2px;'/>") + "</div></body></html>";
        for (BowerValidationInfo error : errors) {
            String linkText = error.getLinkText();
            Component component = error.getComponent();
            if (linkText == null || component == null) continue;
            this.myPackagesNotificationPanel.addLinkHandler(linkText, () -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component, true)));
        }
        this.myPackagesNotificationPanel.showError(html, null, null);
    }

    private void checkVersion(@NotNull BowerSettings settings) {
        if (settings == null) {
            BowerPackagesView.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (settings == null) {
                BowerPackagesView.$$$reportNull$$$0(6);
            }
            try {
                ProcessOutput output = BowerCommandLineUtil.runBowerCommand(null, settings, "--version");
                SemVer semVer = SemVer.parseFromText((String)output.getStdout().trim());
                if (semVer != null && semVer.getMajor() < 1) {
                    UIUtil.invokeLaterIfNeeded(() -> this.myPackagesNotificationPanel.showError("To view bower packages you need bower@1.0.0 or higher", null, null));
                }
            }
            catch (ExecutionException e) {
                LOG.warn("Cannot fetch bower version", (Throwable)e);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerPackagesView";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerPackagesView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onSettingsChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showErrors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkVersion$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

