/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.debugger.UiDebuggerExtension;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.datatransfer.Transferable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.DefaultCaret;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisposerDebugger
implements UiDebuggerExtension,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.objectTree.DisposerDebugger");
    private JComponent myComponent;
    private JBTabsImpl myTreeTabs;
    private static final ObjectNode ROOT = new ObjectNode(Disposer.getTree(), null, new Object(), -1L);

    private void initUi() {
        this.myComponent = new JPanel();
        this.myTreeTabs = new JBTabsImpl(null, null, (Disposable)this);
        Splitter splitter = new Splitter(true);
        JBTabsImpl bottom = new JBTabsImpl(null, null, (Disposable)this);
        AllocationPanel allocations = new AllocationPanel((JBTabs)this.myTreeTabs);
        bottom.addTab(new TabInfo((JComponent)allocations).setText("Allocation")).setActions(allocations.getActions(), "unknown");
        splitter.setFirstComponent((JComponent)this.myTreeTabs);
        splitter.setSecondComponent((JComponent)bottom);
        this.myComponent.setLayout(new BorderLayout());
        this.myComponent.add((Component)splitter, "Center");
        JLabel countLabel = new JLabel("Total disposable count: " + Disposer.getTree().size());
        this.myComponent.add((Component)countLabel, "South");
        this.addTree(new DisposerTree(this), "All", false);
        this.addTree(new DisposerTree(this), "Watch", true);
    }

    private void addTree(DisposerTree tree, String name, boolean canClear) {
        DefaultActionGroup group = new DefaultActionGroup();
        if (canClear) {
            group.add((AnAction)new ClearAction(tree));
        }
        this.myTreeTabs.addTab(new TabInfo((JComponent)tree).setText(name).setObject((Object)tree).setActions((ActionGroup)group, "unknown"));
    }

    @Override
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.initUi();
        }
        return this.myComponent;
    }

    @Override
    public String getName() {
        return "Disposer";
    }

    public void dispose() {
    }

    @Override
    public void disposeUiResources() {
        this.myComponent = null;
    }

    private static class DisposerNode
    extends AbstractTreeNode<ObjectNode> {
        private final DisposerTree myTree;

        private DisposerNode(DisposerTree tree, @NotNull ObjectNode value) {
            if (value == null) {
                DisposerNode.$$$reportNull$$$0(0);
            }
            super(null, (Object)value);
            this.myTree = tree;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ObjectNode value = (ObjectNode)this.getValue();
            if (value != ROOT) {
                Collection subnodes = value.getChildren();
                ArrayList<DisposerNode> children2 = new ArrayList<DisposerNode>(subnodes.size());
                for (Object subnode : subnodes) {
                    children2.add(new DisposerNode(this.myTree, (ObjectNode)subnode));
                }
                ArrayList<DisposerNode> arrayList = children2;
                if (arrayList == null) {
                    DisposerNode.$$$reportNull$$$0(1);
                }
                return arrayList;
            }
            ObjectTree tree = Disposer.getTree();
            Set root = tree.getRootObjects();
            ArrayList<DisposerNode> children3 = new ArrayList<DisposerNode>(root.size());
            for (Disposable each : root) {
                children3.add(new DisposerNode(this.myTree, tree.getNode((Object)each)));
            }
            ArrayList<DisposerNode> arrayList = children3;
            if (arrayList == null) {
                DisposerNode.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @Nullable
        public Throwable getAllocation() {
            return this.getValue() != null ? ((ObjectNode)this.getValue()).getAllocation() : null;
        }

        protected boolean shouldUpdateData() {
            return true;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                DisposerNode.$$$reportNull$$$0(3);
            }
            if (this.getValue() != null) {
                String fqNameClass;
                String fqNameObject;
                int dogIndex;
                Object object = ((ObjectNode)this.getValue()).getObject();
                String classString = object.getClass().toString();
                String objectString = object.toString();
                presentation.setPresentableText(objectString);
                if (((ObjectNode)this.getValue()).getOwnModification() < this.myTree.myModificationToFilter) {
                    presentation.setForcedTextForeground((Color)JBColor.GRAY);
                }
                if (objectString != null && (dogIndex = objectString.lastIndexOf("@")) >= 0 && (fqNameObject = objectString.substring(0, dogIndex)).equals(fqNameClass = classString.substring("class ".length()))) {
                    return;
                }
                presentation.setLocationString(classString);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/objectTree/DisposerDebugger$DisposerNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/objectTree/DisposerDebugger$DisposerNode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DisposerStructure
    extends AbstractTreeStructureBase {
        private final DisposerNode myRoot;

        private DisposerStructure(DisposerTree tree) {
            super(null);
            this.myRoot = new DisposerNode(tree, ROOT);
        }

        @Override
        public List<TreeStructureProvider> getProviders() {
            return null;
        }

        @NotNull
        public Object getRootElement() {
            DisposerNode disposerNode = this.myRoot;
            if (disposerNode == null) {
                DisposerStructure.$$$reportNull$$$0(0);
            }
            return disposerNode;
        }

        public void commit() {
        }

        public boolean hasSomethingToCommit() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/DisposerDebugger$DisposerStructure", "getRootElement"));
        }
    }

    private static class DisposerTree
    extends JPanel
    implements Disposable,
    ObjectTreeListener,
    ElementFilter<DisposerNode> {
        private final FilteringTreeBuilder myTreeBuilder;
        private final Tree myTree;
        private long myModificationToFilter = -1L;

        private DisposerTree(Disposable parent) {
            final DisposerStructure structure = new DisposerStructure(this);
            DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
            Tree tree = new Tree((TreeModel)model);
            tree.setRootVisible(false);
            tree.setShowsRootHandles(true);
            tree.getSelectionModel().setSelectionMode(1);
            this.myTreeBuilder = new FilteringTreeBuilder(tree, this, structure, (Comparator)AlphaComparator.INSTANCE){

                public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
                    return structure.getRootElement() == this.getOriginalNode(nodeDescriptor);
                }
            };
            this.myTreeBuilder.setFilteringMerge(200, MergingUpdateQueue.ANY_COMPONENT);
            Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
            this.myTree = tree;
            this.setLayout(new BorderLayout());
            this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), "Center");
            Disposer.getTree().addListener((ObjectTreeListener)this);
            Disposer.register((Disposable)parent, (Disposable)this);
        }

        public boolean shouldBeShowing(DisposerNode value) {
            return ((ObjectNode)value.getValue()).getModification() > this.myModificationToFilter;
        }

        public void objectRegistered(@NotNull Object node) {
            if (node == null) {
                DisposerTree.$$$reportNull$$$0(0);
            }
            this.queueUpdate();
        }

        public void objectExecuted(@NotNull Object node) {
            if (node == null) {
                DisposerTree.$$$reportNull$$$0(1);
            }
            this.queueUpdate();
        }

        private void queueUpdate() {
            UIUtil.invokeLaterIfNeeded(() -> this.myTreeBuilder.refilter());
        }

        public void dispose() {
            Disposer.getTree().removeListener((ObjectTreeListener)this);
        }

        @Nullable
        public DisposerNode getSelectedNode() {
            Set nodes = this.myTreeBuilder.getSelectedElements(DisposerNode.class);
            return nodes.size() == 1 ? (DisposerNode)((Object)nodes.iterator().next()) : null;
        }

        public Tree getTree() {
            return this.myTree;
        }

        public void clear() {
            this.myModificationToFilter = Disposer.getTree().getModification();
            this.myTreeBuilder.refilter();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/intellij/openapi/util/objectTree/DisposerDebugger$DisposerTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "objectRegistered";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "objectExecuted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AllocationPanel
    extends JPanel
    implements TreeSelectionListener {
        private final JEditorPane myAllocation;
        private final DefaultActionGroup myActions;
        private final JBTabs myTreeTabs;

        private AllocationPanel(JBTabs treeTabs) {
            this.myTreeTabs = treeTabs;
            this.myAllocation = new JEditorPane();
            DefaultCaret caret = new DefaultCaret();
            this.myAllocation.setCaret(caret);
            caret.setUpdatePolicy(1);
            this.myAllocation.setEditable(false);
            this.setLayout(new BorderLayout());
            this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myAllocation), "Center");
            treeTabs.addListener(new TabsListener(){

                public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                    this.updateText();
                }

                public void beforeSelectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                    this.removeListener(oldSelection);
                    this.addListener(newSelection);
                }
            });
            this.myActions = new DefaultActionGroup();
            this.myActions.add((AnAction)new CopyAllocationAction());
        }

        private void addListener(TabInfo info) {
            if (info == null) {
                return;
            }
            ((DisposerTree)info.getObject()).getTree().getSelectionModel().addTreeSelectionListener(this);
        }

        private void removeListener(TabInfo info) {
            if (info == null) {
                return;
            }
            ((DisposerTree)info.getObject()).getTree().getSelectionModel().removeTreeSelectionListener(this);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.updateText();
        }

        private void updateText() {
            Throwable allocation;
            if (this.myTreeTabs.getSelectedInfo() == null) {
                return;
            }
            DisposerTree tree = (DisposerTree)this.myTreeTabs.getSelectedInfo().getObject();
            DisposerNode node = tree.getSelectedNode();
            if (node != null && (allocation = node.getAllocation()) != null) {
                StringWriter s = new StringWriter();
                PrintWriter writer = new PrintWriter(s);
                allocation.printStackTrace(writer);
                this.myAllocation.setText(s.toString());
                return;
            }
            this.myAllocation.setText(null);
        }

        public ActionGroup getActions() {
            return this.myActions;
        }

        private class CopyAllocationAction
        extends AnAction {
            CopyAllocationAction() {
                super("Copy", "Copy allocation to clipboard", PlatformIcons.COPY_ICON);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    CopyAllocationAction.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(AllocationPanel.this.myAllocation.getDocument().getLength() > 0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    CopyAllocationAction.$$$reportNull$$$0(1);
                }
                try {
                    CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(AllocationPanel.this.myAllocation.getText()));
                }
                catch (HeadlessException e1) {
                    LOG.error((Throwable)e1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/util/objectTree/DisposerDebugger$AllocationPanel$CopyAllocationAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class ClearAction
    extends AnAction {
        private final DisposerTree myTree;

        private ClearAction(DisposerTree tree) {
            super("Clear");
            this.myTree = tree;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setIcon(AllIcons.Debugger.Watch);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(1);
            }
            this.myTree.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/util/objectTree/DisposerDebugger$ClearAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

