/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryTableBase
implements PersistentStateComponent<Element>,
LibraryTable,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.libraries.LibraryTableBase");
    private final EventDispatcher<LibraryTable.Listener> myDispatcher = EventDispatcher.create(LibraryTable.Listener.class);
    private LibraryModel myModel = new LibraryModel();
    private boolean myFirstLoad = true;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();

    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        LibraryModel libraryModel = new LibraryModel(this.myModel);
        if (libraryModel == null) {
            LibraryTableBase.$$$reportNull$$$0(0);
        }
        return libraryModel;
    }

    public Element getState() {
        Element element = new Element("state");
        try {
            this.myModel.writeExternal(element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return element;
    }

    public void noStateLoaded() {
        this.myFirstLoad = false;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            LibraryTableBase.$$$reportNull$$$0(1);
        }
        if (this.myFirstLoad) {
            this.myModel.readExternal(element);
        } else {
            LibraryModel model = new LibraryModel(this.myModel);
            WriteAction.run(() -> {
                if (element == null) {
                    LibraryTableBase.$$$reportNull$$$0(15);
                }
                model.readExternal(element);
                model.commit();
            });
        }
        this.myFirstLoad = false;
    }

    public long getStateModificationCount() {
        return this.myModificationTracker.getModificationCount();
    }

    @NotNull
    public Library[] getLibraries() {
        Library[] libraryArray = this.myModel.getLibraries();
        if (libraryArray == null) {
            LibraryTableBase.$$$reportNull$$$0(2);
        }
        return libraryArray;
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        Iterator<Library> iterator = this.myModel.getLibraryIterator();
        if (iterator == null) {
            LibraryTableBase.$$$reportNull$$$0(3);
        }
        return iterator;
    }

    public Library getLibraryByName(@NotNull String name) {
        if (name == null) {
            LibraryTableBase.$$$reportNull$$$0(4);
        }
        return this.myModel.getLibraryByName(name);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            LibraryTableBase.$$$reportNull$$$0(5);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            LibraryTableBase.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            LibraryTableBase.$$$reportNull$$$0(7);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            LibraryTableBase.$$$reportNull$$$0(8);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    private void fireLibraryAdded(@NotNull Library library) {
        if (library == null) {
            LibraryTableBase.$$$reportNull$$$0(9);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireLibraryAdded: " + library);
        }
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryAdded(library);
    }

    private void fireBeforeLibraryRemoved(@NotNull Library library) {
        if (library == null) {
            LibraryTableBase.$$$reportNull$$$0(10);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireBeforeLibraryRemoved: " + library);
        }
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).beforeLibraryRemoved(library);
    }

    public void dispose() {
        for (Library library : this.getLibraries()) {
            Disposer.dispose((Disposable)library);
        }
    }

    @NotNull
    public Library createLibrary() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Library library = this.createLibrary(null);
        if (library == null) {
            LibraryTableBase.$$$reportNull$$$0(11);
        }
        return library;
    }

    void fireLibraryRenamed(@NotNull LibraryImpl library) {
        if (library == null) {
            LibraryTableBase.$$$reportNull$$$0(12);
        }
        this.incrementModificationCount();
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryRenamed((Library)library);
    }

    private void incrementModificationCount() {
        if (Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
            LOG.error("library");
        }
        this.myModificationTracker.incModificationCount();
    }

    @NotNull
    public Library createLibrary(String name) {
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        Library library = modifiableModel.createLibrary(name);
        modifiableModel.commit();
        Library library2 = library;
        if (library2 == null) {
            LibraryTableBase.$$$reportNull$$$0(13);
        }
        return library2;
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            LibraryTableBase.$$$reportNull$$$0(14);
        }
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        modifiableModel.removeLibrary(library);
        modifiableModel.commit();
    }

    private void commit(LibraryModel model) {
        this.myFirstLoad = false;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!model.isChanged()) {
            return;
        }
        this.incrementModificationCount();
        Set removedLibraries = model.myRemovedLibraries;
        for (Library library : removedLibraries) {
            this.fireBeforeLibraryRemoved(library);
        }
        this.myModel.applyChanges(model);
        for (Library library : removedLibraries) {
            Disposer.dispose((Disposable)library);
            this.fireAfterLibraryRemoved(library);
        }
        for (Library library : model.myAddedLibraries) {
            this.fireLibraryAdded(library);
        }
    }

    private void fireAfterLibraryRemoved(Library library) {
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryRemoved(library);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myModel = new LibraryModel();
        this.myModel.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myModel.writeExternal(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTableBase";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTableBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryIterator";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryByName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fireLibraryAdded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeLibraryRemoved";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fireLibraryRenamed";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeLibrary";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadState$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class LibraryModel
    implements LibraryTable.ModifiableModel,
    JDOMExternalizable,
    LibraryTable.Listener,
    Disposable {
        private final List<Library> myLibraries = new ArrayList<Library>();
        private final Set<Library> myAddedLibraries = ContainerUtil.newIdentityTroveSet();
        private final Set<Library> myRemovedLibraries = ContainerUtil.newIdentityTroveSet();
        private volatile Map<String, Library> myLibraryByNameCache;
        private boolean myWritable;

        private LibraryModel() {
            LibraryTableBase.this.myDispatcher.addListener((EventListener)((Object)this));
            this.myWritable = false;
        }

        private LibraryModel(LibraryModel that) {
            LibraryTableBase.this.myDispatcher.addListener((EventListener)((Object)this));
            this.myWritable = true;
            this.myLibraries.addAll(that.myLibraries);
        }

        public void commit() {
            LibraryTableBase.this.commit(this);
            this.myAddedLibraries.clear();
            this.myRemovedLibraries.clear();
            Disposer.dispose((Disposable)this);
            this.myWritable = false;
        }

        public void dispose() {
            LibraryTableBase.this.myDispatcher.removeListener((EventListener)((Object)this));
            for (Library library : this.myAddedLibraries) {
                Disposer.dispose((Disposable)library);
            }
        }

        @NotNull
        public Iterator<Library> getLibraryIterator() {
            Iterator<Library> iterator = Collections.unmodifiableList(this.myLibraries).iterator();
            if (iterator == null) {
                LibraryModel.$$$reportNull$$$0(0);
            }
            return iterator;
        }

        @Nullable
        public Library getLibraryByName(@NotNull String name) {
            Library library;
            Map<String, Library> cache;
            if (name == null) {
                LibraryModel.$$$reportNull$$$0(1);
            }
            if ((cache = this.myLibraryByNameCache) == null) {
                cache = new HashMap<String, Library>();
                for (Library library2 : this.myLibraries) {
                    cache.put(library2.getName(), library2);
                }
                this.myLibraryByNameCache = cache;
            }
            if ((library = cache.get(name)) != null) {
                return library;
            }
            String libraryPrefix = "library.";
            String libPath = System.getProperty("library." + name);
            if (libPath != null) {
                LibraryImpl libraryFromProperty = new LibraryImpl(name, null, LibraryTableBase.this, null, null);
                libraryFromProperty.addRoot(libPath, OrderRootType.CLASSES);
                return libraryFromProperty;
            }
            return null;
        }

        @NotNull
        public Library[] getLibraries() {
            Library[] libraryArray = this.myLibraries.toArray(Library.EMPTY_ARRAY);
            if (libraryArray == null) {
                LibraryModel.$$$reportNull$$$0(2);
            }
            return libraryArray;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myWritable);
        }

        @NotNull
        public Library createLibrary(String name) {
            Library library = this.createLibrary(name, null);
            if (library == null) {
                LibraryModel.$$$reportNull$$$0(3);
            }
            return library;
        }

        @NotNull
        public Library createLibrary(String name, @Nullable PersistentLibraryKind kind) {
            Library library = this.createLibrary(name, kind, null);
            if (library == null) {
                LibraryModel.$$$reportNull$$$0(4);
            }
            return library;
        }

        @NotNull
        public Library createLibrary(String name, @Nullable PersistentLibraryKind kind, @Nullable ProjectModelExternalSource externalSource) {
            this.assertWritable();
            LibraryImpl library = new LibraryImpl(name, kind, LibraryTableBase.this, null, externalSource);
            this.myLibraries.add((Library)library);
            if (this.myWritable) {
                this.myAddedLibraries.add((Library)library);
            }
            this.myLibraryByNameCache = null;
            LibraryImpl libraryImpl = library;
            if (libraryImpl == null) {
                LibraryModel.$$$reportNull$$$0(5);
            }
            return libraryImpl;
        }

        public void removeLibrary(@NotNull Library library) {
            if (library == null) {
                LibraryModel.$$$reportNull$$$0(6);
            }
            LibraryTableBase.this.incrementModificationCount();
            this.assertWritable();
            this.myLibraries.remove(library);
            if (this.myWritable) {
                if (!this.myAddedLibraries.remove(library)) {
                    this.myRemovedLibraries.add(library);
                } else {
                    Disposer.dispose((Disposable)library);
                }
            }
            this.myLibraryByNameCache = null;
        }

        public boolean isChanged() {
            if (!this.myWritable) {
                return false;
            }
            return !this.myAddedLibraries.isEmpty() || !this.myRemovedLibraries.isEmpty();
        }

        public void readExternal(Element element) {
            if (this.myWritable) {
                this.myRemovedLibraries.addAll(this.myLibraries);
            }
            this.myLibraries.clear();
            List libraryElements = element.getChildren("library");
            for (Element libraryElement : libraryElements) {
                LibraryImpl library = new LibraryImpl(LibraryTableBase.this, libraryElement, null);
                if (library.getName() != null) {
                    this.myLibraries.add((Library)library);
                    if (this.myWritable) {
                        this.myAddedLibraries.add((Library)library);
                    }
                    LibraryTableBase.this.fireLibraryAdded((Library)library);
                    continue;
                }
                Disposer.dispose((Disposable)library);
            }
            this.myLibraryByNameCache = null;
        }

        public void afterLibraryRenamed(@NotNull Library library) {
            if (library == null) {
                LibraryModel.$$$reportNull$$$0(7);
            }
            this.myLibraryByNameCache = null;
        }

        public void writeExternal(Element element) {
            List libraries = ContainerUtil.findAll(this.myLibraries, library -> !((LibraryEx)library).isDisposed());
            ContainerUtil.sort((List)libraries, (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true));
            for (Library library2 : libraries) {
                if (library2.getName() == null) continue;
                library2.writeExternal(element);
            }
        }

        private void applyChanges(LibraryModel model) {
            this.myLibraries.removeAll(model.myRemovedLibraries);
            this.myLibraries.addAll(model.myAddedLibraries);
            this.myLibraryByNameCache = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryIterator";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraries";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryByName";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removeLibrary";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "afterLibraryRenamed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

