/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowErrorDescriptionHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;

public class ShowErrorDescriptionAction
extends BaseCodeInsightAction
implements DumbAware {
    private static int width;
    private static boolean shouldShowDescription;
    private static boolean descriptionShown;
    private boolean myRequestFocus = false;

    public ShowErrorDescriptionAction() {
        this.setEnabledInModalContext(true);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        ShowErrorDescriptionHandler showErrorDescriptionHandler = new ShowErrorDescriptionHandler(shouldShowDescription ? width : 0, this.myRequestFocus);
        if (showErrorDescriptionHandler == null) {
            ShowErrorDescriptionAction.$$$reportNull$$$0(0);
        }
        return showErrorDescriptionHandler;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            ShowErrorDescriptionAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ShowErrorDescriptionAction.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ShowErrorDescriptionAction.$$$reportNull$$$0(3);
        }
        return DaemonCodeAnalyzer.getInstance((Project)project).isHighlightingAvailable(file2) && ShowErrorDescriptionAction.isEnabledForFile(project, editor, file2);
    }

    private static boolean isEnabledForFile(Project project, Editor editor, PsiFile file2) {
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        HighlightInfo info = ((DaemonCodeAnalyzerImpl)codeAnalyzer).findHighlightByOffset(editor.getDocument(), editor.getCaretModel().getOffset(), false);
        return info != null && info.getDescription() != null;
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowErrorDescriptionAction.$$$reportNull$$$0(4);
        }
        super.beforeActionPerformedUpdate(e);
        this.myRequestFocus = ScreenReader.isActive() && e.getInputEvent() instanceof KeyEvent;
        ShowErrorDescriptionAction.changeState();
    }

    private static void changeState() {
        if (Comparing.strEqual((String)ActionManagerEx.getInstanceEx().getPrevPreformedActionId(), (String)"ShowErrorDescription")) {
            shouldShowDescription = descriptionShown;
        } else {
            shouldShowDescription = false;
            descriptionShown = true;
        }
    }

    public static void rememberCurrentWidth(int currentWidth) {
        width = currentWidth;
        descriptionShown = !shouldShowDescription;
    }

    static {
        shouldShowDescription = false;
        descriptionShown = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/ShowErrorDescriptionAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/ShowErrorDescriptionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformedUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

