/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocRefImpl;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.PhpBaseRefactoringProcessor;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberConflicts;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberDelegate;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveMemberProcessor
extends PhpBaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(PhpMoveMemberProcessor.class);
    @NotNull
    protected final Collection<PhpClassMember> mySelectedMembers;
    @NotNull
    protected PhpClass myFromClass;
    @NotNull
    protected PhpClass myTargetClass;
    @NotNull
    protected Editor myEditor;
    @NotNull
    protected Document myDocument;
    @NotNull
    protected Set<PsiFile> affectedFiles;

    protected PhpMoveMemberProcessor(@NotNull Project project, @NotNull PhpClass fromClazz, @NotNull PhpClass targetClazz, @NotNull Editor editor, @NotNull Collection<PhpClassMember> selectedMembers) {
        if (project == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(0);
        }
        if (fromClazz == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(1);
        }
        if (targetClazz == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(3);
        }
        if (selectedMembers == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(4);
        }
        super(project);
        this.myFromClass = fromClazz;
        this.myTargetClass = targetClazz;
        this.mySelectedMembers = selectedMembers;
        this.myEditor = editor;
        this.myDocument = editor.getDocument();
        this.affectedFiles = new THashSet();
    }

    protected PhpMoveMemberProcessor(@NotNull Project project, @NotNull PhpClass fromClazz, @NotNull PhpClass targetClazz, @NotNull Collection<PhpClassMember> selectedMemberInfos) {
        if (project == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(5);
        }
        if (fromClazz == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(6);
        }
        if (targetClazz == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(7);
        }
        if (selectedMemberInfos == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(8);
        }
        super(project);
        this.myFromClass = fromClazz;
        this.myTargetClass = targetClazz;
        this.mySelectedMembers = selectedMemberInfos;
        this.affectedFiles = new THashSet();
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> ref) {
        if (ref == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(9);
        }
        UsageInfo[] usages = (UsageInfo[])ref.get();
        PhpMoveMemberConflicts conflicts = new PhpMoveMemberConflicts(this.mySelectedMembers, this.myFromClass, this.myTargetClass);
        conflicts.checkAlreadyDefinedMembers(this.myTargetClass);
        conflicts.checkFinalMethods(this.myTargetClass);
        conflicts.checkUsagesForConflicts(usages);
        for (UsageInfo usageInfo : usages) {
            this.affectedFiles.add(usageInfo.getFile());
        }
        this.affectedFiles.add(this.myFromClass.getContainingFile());
        this.affectedFiles.add(this.myTargetClass.getContainingFile());
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myProject, this.affectedFiles, (boolean)true)) {
            return false;
        }
        for (PhpClassMember member : this.mySelectedMembers) {
            if (!(member instanceof Method)) continue;
            conflicts.checkInternalReferences((Method)member);
        }
        return this.showConflicts(conflicts.getConflicts(), usages);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(10);
        }
        UsageViewDescriptor usageViewDescriptor = new UsageViewDescriptor(){

            @NotNull
            public PsiElement[] getElements() {
                if (PsiElement.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return PhpBundle.message("refactoring.move.method.message", new Object[0]);
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return PhpBundle.message("refactoring.move.members.to.be.moved", UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount));
            }

            @Nullable
            public String getCommentReferencesText(int usagesCount, int filesCount) {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/move/member/PhpMoveMemberProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptor == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(11);
        }
        return usageViewDescriptor;
    }

    public static Collection<PsiReference> findReferences(PsiElement element) {
        Collection references = ReferencesSearch.search((PsiElement)element).findAll();
        ArrayList<PsiReference> referenceCollection = new ArrayList<PsiReference>(references.size());
        for (PsiReference reference : references) {
            if (!(reference instanceof MemberReference) && !(reference instanceof PhpDocRefImpl.PhpDocElementReference) && !(reference instanceof PhpCallbackReferenceBase)) continue;
            referenceCollection.add(reference);
        }
        return referenceCollection;
    }

    @NotNull
    private static String generateAliasName(PhpClass targetClass, Collection<PhpUse> declarations) {
        Set usedNames = (Set)StreamEx.of(declarations).map(d -> (String)ObjectUtils.notNull((Object)d.getAliasName(), (Object)d.getName())).toCollection(THashSet::new);
        String string = PhpNameUtil.unique(targetClass.getName(), "", "", (Condition<? super String>)((Condition)usedNames::contains));
        if (string == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static boolean scopeContainsNamedElement(PhpPsiElement element, @NotNull PhpNamedElement namedElement) {
        if (namedElement == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(13);
        }
        PhpClass thisClazz = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)element, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        String targetClazzNamespaceName = namedElement.getNamespaceName();
        if (thisClazz != null) {
            return thisClazz.getNamespaceName().equals(targetClazzNamespaceName);
        }
        return targetClazzNamespaceName.equals("\\");
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (PhpClassMember it : this.mySelectedMembers) {
            Collection<PsiReference> references = PhpMoveMemberProcessor.findReferences((PsiElement)it);
            for (PsiReference reference : references) {
                PsiElement element = reference.getElement();
                result.add(new UsageInfo(element));
            }
        }
        UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(14);
        }
        return usageInfoArray;
    }

    protected List<PhpClassMember> getSelectedMembers() {
        return new ArrayList<PhpClassMember>(this.mySelectedMembers);
    }

    public static PhpClass getClass(PsiElement element) {
        return (PhpClass)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
    }

    private static void processTraitMembers(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            PhpNamedElement namedElement;
            PhpPsiElement element = (PhpPsiElement)usage.getElement();
            if (!(element instanceof MethodReference) || !((namedElement = (PhpNamedElement)PhpPsiUtil.getParentByCondition((PsiElement)element, false, (Condition<? super PsiElement>)PhpNamedElement.INSTANCEOF)) instanceof PhpTraitUseRule)) continue;
            PhpTraitUseRule rule = (PhpTraitUseRule)namedElement;
            PhpUseList traitUseList = (PhpUseList)PhpPsiUtil.getParentByCondition((PsiElement)namedElement, false, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            if (traitUseList == null) continue;
            traitUseList.getNode().removeChild(rule.getNode());
        }
    }

    @Override
    protected void performMainRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(15);
        }
        List<PhpClassMember> members = this.getSelectedMembers();
        String name = this.myTargetClass.getName();
        for (UsageInfo usage : usages) {
            PhpPsiElement arg;
            PsiElement firstChild;
            PsiElement sibling;
            PhpPsiElement usageElement = (PhpPsiElement)usage.getElement();
            if (usageElement == null) continue;
            if (usageElement instanceof MemberReference) {
                name = PhpMoveMemberProcessor.importClassAndGetName(this.myTargetClass, (MemberReference)usageElement);
            }
            if (usageElement instanceof MemberReference) {
                PhpClass containingClass = PhpMoveMemberProcessor.getClass((PsiElement)usageElement);
                if (containingClass != null && containingClass.getManager().areElementsEquivalent((PsiElement)containingClass, (PsiElement)this.myTargetClass)) {
                    name = "self";
                }
                Method containingMethod = (Method)PhpPsiUtil.getParentByCondition((PsiElement)usageElement, (Condition<? super PsiElement>)Method.INSTANCEOF);
                if (containingClass != null && members.contains(containingMethod) && ((MemberReference)usageElement).getClassReference().getName().equalsIgnoreCase("self")) {
                    name = "self";
                }
            }
            if ((sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(firstChild = usageElement.getFirstChild(), true)) == null) continue;
            if (usageElement instanceof PhpDocRef && PhpPsiUtil.isOfType(firstChild, PhpDocTokenTypes.DOC_IDENTIFIER) && PhpPsiUtil.isOfType(sibling, PhpDocTokenTypes.DOC_STATIC)) {
                this.basicDocRefactoring(name, firstChild, (PhpDocRef)usageElement);
            }
            if (!(usageElement instanceof MemberReference)) continue;
            if (firstChild instanceof ParenthesizedExpression && (arg = ((ParenthesizedExpression)firstChild).getArgument()) instanceof NewExpression) {
                ClassReference classReference = ((NewExpression)arg).getClassReference();
                assert (classReference != null);
                Statement newClassStatement = PhpPsiElementFactory.createStatement(this.myProject, "new " + classReference.getName() + "();");
                Object elementStatement = PhpPsiUtil.getParentByCondition((PsiElement)usageElement, true, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                if (elementStatement != null) {
                    PsiElement prevStatement = elementStatement.getPrevSibling();
                    elementStatement.getParent().addAfter((PsiElement)newClassStatement, prevStatement);
                }
            }
            if (!PhpPsiUtil.isOfType(sibling, PhpTokenTypes.ARROW) && !PhpPsiUtil.isOfType(sibling, PhpTokenTypes.SCOPE_RESOLUTION)) continue;
            String elementText = usageElement.getText();
            int restTextOffset = sibling.getTextRange().getEndOffset();
            int startOffset = firstChild.getTextRange().getStartOffset();
            String restText = elementText.substring(restTextOffset - startOffset);
            String newReferenceText = elementText.substring(0, restTextOffset - startOffset).replace(firstChild.getText(), name);
            if (PhpPsiUtil.isOfType(sibling, PhpTokenTypes.ARROW)) {
                newReferenceText = newReferenceText.replaceFirst("->", "::");
            }
            usageElement.replace((PsiElement)PhpPsiElementFactory.createFirstFromText(this.myProject, MemberReference.class, "<?php " + newReferenceText + restText));
        }
        if (this.myFromClass.isTrait()) {
            PhpMoveMemberProcessor.processTraitMembers(usages);
        }
        PhpMoveClassMemberBase.getInstance(this.myTargetClass, false).move(members, PhpModifier.Access.PUBLIC, true);
        this.optimizeImports(this.affectedFiles);
    }

    private void basicDocRefactoring(String name, PsiElement firstChild, PhpDocRef ref) {
        String referenceString = ref.getText();
        int length = firstChild.getTextRange().getLength();
        referenceString = referenceString.replace(referenceString.substring(0, length), name);
        ref.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(this.myProject, PhpDocRef.class, "/** @see " + referenceString + "  */\n"));
    }

    @NotNull
    private static String importClassAndGetName(@NotNull PhpClass targetClass, @NotNull MemberReference reference) {
        String targetClassFQN;
        PhpPsiElement scopeForUseOperator;
        ClassReference classReference;
        PhpUse targetAliasUse;
        if (targetClass == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(16);
        }
        if (reference == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(17);
        }
        PhpUse phpUse = targetAliasUse = (classReference = (ClassReference)ObjectUtils.tryCast((Object)reference.getClassReference(), ClassReference.class)) != null ? PhpTargetElementEvaluator.getElementByReference((PsiReference)classReference) : null;
        if (targetAliasUse != null) {
            String referenceName = reference.getName();
            boolean aliasReferencedOnlyToMovedMember = PhpCodeInsightUtil.collectReferencesToAlias(targetAliasUse).stream().map(r -> r.getElement().getParent()).allMatch(r -> r instanceof MemberReference && StringUtil.equalsIgnoreCase((CharSequence)((MemberReference)r).getName(), (CharSequence)referenceName));
            if (aliasReferencedOnlyToMovedMember) {
                PhpMoveMemberProcessor.replaceTargetReference(targetAliasUse, targetClass.getPresentableFQN());
                String string = targetAliasUse.getName();
                if (string == null) {
                    PhpMoveMemberProcessor.$$$reportNull$$$0(18);
                }
                return string;
            }
        }
        if ((scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)reference)) == null || PhpMoveMemberProcessor.scopeContainsNamedElement((PhpPsiElement)reference, (PhpNamedElement)targetClass)) {
            String string = targetClass.getName();
            if (string == null) {
                PhpMoveMemberProcessor.$$$reportNull$$$0(19);
            }
            return string;
        }
        List<PhpUse> declarations = PhpCodeInsightUtil.collectImports(scopeForUseOperator).stream().flatMap(use -> StreamEx.of((Object[])use.getDeclarations())).collect(Collectors.toList());
        PhpUse targetUse = (PhpUse)ContainerUtil.find(declarations, arg_0 -> PhpMoveMemberProcessor.lambda$importClassAndGetName$4(targetClassFQN = targetClass.getFQN(), arg_0));
        if (targetUse != null) {
            String string = targetUse.getName();
            if (string == null) {
                PhpMoveMemberProcessor.$$$reportNull$$$0(20);
            }
            return string;
        }
        boolean useWithSameNameExists = ContainerUtil.exists(declarations, d -> {
            if (targetClass == null) {
                PhpMoveMemberProcessor.$$$reportNull$$$0(26);
            }
            return PhpLangUtil.equalsClassNames(d.getName(), targetClass.getName());
        });
        if (useWithSameNameExists) {
            String nameAlias = PhpMoveMemberProcessor.generateAliasName(targetClass, declarations);
            PhpAliasImporter.insertUseStatement(targetClassFQN, nameAlias, scopeForUseOperator);
            String string = nameAlias;
            if (string == null) {
                PhpMoveMemberProcessor.$$$reportNull$$$0(21);
            }
            return string;
        }
        PhpAliasImporter.insertUseStatement(targetClassFQN, scopeForUseOperator);
        String string = targetClass.getName();
        if (string == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static void replaceTargetReference(@NotNull PhpUse use, @NotNull String presentableFQN) {
        PhpReference targetReference;
        if (use == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(23);
        }
        if (presentableFQN == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(24);
        }
        if ((targetReference = use.getTargetReference()) != null) {
            targetReference.replace((PsiElement)PhpPsiElementFactory.createClassReference(use.getProject(), presentableFQN));
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpMoveMemberDelegate.REFACTORING_NAME;
        if (string == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static /* synthetic */ boolean lambda$importClassAndGetName$4(String targetClassFQN, PhpUse d) {
        return PhpLangUtil.equalsClassNames(d.getFQN(), targetClassFQN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromClazz";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedMembers";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedMemberInfos";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberProcessor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "use";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableFQN";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generateAliasName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "importClassAndGetName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scopeContainsNamedElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "performMainRefactoring";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "importClassAndGetName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "replaceTargetReference";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$importClassAndGetName$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

