/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpPBMetaBuilderLegacy;
import com.jetbrains.php.lang.psi.resolve.types.PhpPBMetaBuilderNew;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider3;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParameterBasedTypeProvider
implements PhpTypeProvider3 {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.PhpParameterBasedTypeProvider");
    private static final Key<CachedValue<Map<String, Map<String, String>>>> STATIC_FACTORY_TYPE_MAP = new Key("STATIC_FACTORY_TYPE_MAP");
    public static final String PHPSTORM_META_PHP = ".phpstorm.meta.php";
    public static final String PATTERN_KEY = "\u03c0";
    public static final String TYPE_KEY = "\u03c0\u2020";
    public static final String ELEMENT_TYPE_KEY = "\u03c0e\u2020";
    public static final char SEPARATOR = '.';
    public static final char ESCAPED_SEPARATOR = '\u2265';
    public static final String ONE_ARG_PATTERN = "@";
    public static final String ARG_PATTERN = "$";
    public static final String PARAM_SEPARATATOR = "~";
    private static final ThreadLocal<Boolean> computing = ThreadLocal.withInitial(() -> false);

    public char getKey() {
        return '\u03c0';
    }

    @Nullable
    public PhpType getType(PsiElement e) {
        String param;
        PhpPsiElement value;
        Map<String, Map<String, String>> methods = PhpParameterBasedTypeProvider.getStaticMethodTypesMap(e.getProject());
        if (methods == null) {
            return null;
        }
        String subject = null;
        PsiElement[] parameters = null;
        if (e instanceof FunctionReference) {
            if (e instanceof MethodReference) {
                String name = ((MethodReference)e).getName();
                if (name == null) {
                    return null;
                }
                if (PhpParameterBasedTypeProvider.hasMethodCandidates(methods, name)) {
                    return null;
                }
            }
            subject = ((FunctionReference)e).getSignature();
            if (!(e instanceof MethodReference) && PhpParameterBasedTypeProvider.hasFunctionOverride(methods, subject)) {
                return null;
            }
            parameters = ((FunctionReference)e).getParameters();
        } else if (e instanceof ArrayAccessExpression && (value = ((ArrayAccessExpression)e).getValue()) instanceof PhpReference) {
            subject = ((PhpReference)value).getSignature();
            List types = StringUtil.split((String)subject, (String)"|");
            if (types.stream().anyMatch(PhpType::isPluralType)) {
                PhpType type = new PhpType();
                types.forEach(arg_0 -> ((PhpType)type).add(arg_0));
                return type.elementType();
            }
            ArrayIndex index = ((ArrayAccessExpression)e).getIndex();
            if (index != null) {
                parameters = new PsiElement[]{index.getValue()};
            }
        }
        if (parameters == null || StringUtil.isEmpty((String)subject)) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>();
        for (PsiElement parameter : parameters) {
            ClassReference reference;
            if (parameter instanceof StringLiteralExpression) {
                params.add(((StringLiteralExpression)parameter).getContents());
            }
            if (parameter instanceof NewExpression && (reference = ((NewExpression)parameter).getClassReference()) != null) {
                params.add(reference.getFQN());
            }
            if (parameter instanceof PhpExpression && PhpPsiUtil.isOfType(parameter, PhpElementTypes.NUMBER)) {
                params.add(parameter.getText());
            }
            if (parameter instanceof ClassConstantReference && StringUtil.equals((CharSequence)"class", (CharSequence)((ClassConstantReference)parameter).getNameCS())) {
                reference = (ClassReference)((ClassConstantReference)parameter).getClassReference();
                if (reference == null) continue;
                params.add(reference.getFQN());
                continue;
            }
            if (parameter instanceof ConstantReference || parameter instanceof ClassConstantReference) {
                params.add(((PhpReference)parameter).getSignature());
                continue;
            }
            if (!(parameter instanceof Variable) && !(parameter instanceof FieldReference)) continue;
            params.add(((PhpReference)parameter).getSignature());
        }
        String string = param = params.size() == 0 ? "\u00f8" : StringUtil.join(params, (String)PARAM_SEPARATATOR);
        if (StringUtil.isEmpty((String)param)) {
            return null;
        }
        if (param.contains("|")) {
            return null;
        }
        if (subject.length() > 200 || param.length() > 100) {
            return null;
        }
        Map map = StringUtil.split((String)subject, (String)"|").stream().map(methods::get).filter(m -> m != null).findFirst().orElse(null);
        if (map != null) {
            String target = (String)map.get(param.replace('.', '\u2265'));
            if (target != null) {
                return new PhpType().add(target);
            }
            target = (String)map.get(PATTERN_KEY);
            if (target != null) {
                for (int i = 0; i < params.size(); ++i) {
                    target = StringUtil.replace((String)target, (String)(ARG_PATTERN + i), (String)((String)params.get(i)));
                }
                target = StringUtil.replace((String)target, (String)ONE_ARG_PATTERN, (String)((String)ContainerUtil.getOrElse(params, (int)0, (Object)"")));
                return new PhpType().add(target);
            }
            target = (String)map.get(TYPE_KEY);
            if (target != null) {
                return new PhpType().add((String)ContainerUtil.getOrElse(params, (int)StringUtil.parseInt((String)target, (int)Integer.MAX_VALUE), (Object)""));
            }
            target = (String)map.get(ELEMENT_TYPE_KEY);
            if (target != null) {
                return new PhpType().add((String)ContainerUtil.getOrElse(params, (int)StringUtil.parseInt((String)target, (int)Integer.MAX_VALUE), (Object)"")).elementType();
            }
        }
        String finalParam = param.replace('.', '\u2265');
        PhpType result = new PhpType();
        StringUtil.split((String)subject, (String)"|").stream().filter(s -> !s.contains("#\u03c0")).map(s -> "#" + this.getKey() + s + '.' + finalParam).forEach(arg_0 -> ((PhpType)result).add(arg_0));
        return result;
    }

    private static boolean hasMethodCandidates(Map<String, Map<String, String>> methods, String name) {
        String finalName = "." + name;
        return methods.keySet().stream().noneMatch(s -> s.startsWith("#M") && s.endsWith(finalName));
    }

    private static boolean hasFunctionOverride(Map<String, Map<String, String>> methods, String subject) {
        return StringUtil.split((String)subject, (String)"|").stream().noneMatch(methods::containsKey);
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        Map<String, Map<String, String>> methods = PhpParameterBasedTypeProvider.getStaticMethodTypesMap(project);
        if (methods == null) {
            return null;
        }
        int separator = expression.lastIndexOf(46);
        if (separator >= 0) {
            String refSignature = expression.substring(0, separator);
            Map<String, String> types = PhpParameterBasedTypeProvider.getTargets(refSignature, visited, depth, project);
            PhpIndex index = PhpIndex.getInstance((Project)project);
            if (types != null) {
                String key = expression.substring(separator + 1).replace('.', '\u2265');
                List keys = StringUtil.split((String)key, (String)PARAM_SEPARATATOR);
                String type = types.get(key);
                if (type == null && (key.startsWith("#D") || key.startsWith("#K"))) {
                    Collection signature = index.getBySignature(key.replace('\u2265', '.'));
                    for (PhpNamedElement element : signature) {
                        if (element instanceof Constant) {
                            type = types.get(StringUtil.unquoteString((String)StringUtil.defaultIfEmpty((String)((Constant)element).getValuePresentation(), (String)"")));
                        }
                        if (!(element instanceof Field)) continue;
                        type = types.get(StringUtil.unquoteString((String)StringUtil.defaultIfEmpty((String)((Field)element).getDefaultValuePresentation(), (String)"")));
                    }
                }
                if (type == null) {
                    type = types.get(PATTERN_KEY);
                    if (type != null) {
                        for (int i = 0; i < keys.size(); ++i) {
                            type = StringUtil.replace((String)type, (String)(ARG_PATTERN + i), (String)((String)keys.get(i)));
                        }
                        type = StringUtil.replace((String)type, (String)ONE_ARG_PATTERN, (String)((String)ContainerUtil.getOrElse((List)keys, (int)0, (Object)"")));
                    } else {
                        type = types.get(TYPE_KEY);
                        if (type != null) {
                            type = key;
                        } else {
                            type = types.get(ELEMENT_TYPE_KEY);
                            if (type != null) {
                                type = new PhpType().add(key).elementType().toString();
                            }
                        }
                    }
                }
                if (type == null) {
                    type = (String)ContainerUtil.getOrElse((List)keys, (int)0, (Object)"");
                }
                return StringUtil.split((String)type.replace('\u2265', '.'), (String)"|").stream().flatMap(s -> s.contains("#") ? index.getBySignature(s).stream() : index.getAnyByFQN(s).stream()).collect(Collectors.toList());
            }
        }
        return Collections.emptySet();
    }

    @Nullable
    private static Map<String, String> getTargets(String refSignature, Set<String> visited, int depth, Project project) {
        PhpClass aClass;
        Map<String, Map<String, String>> methods = PhpParameterBasedTypeProvider.getStaticMethodTypesMap(project);
        if (methods == null) {
            return null;
        }
        Ref types = new Ref();
        Optional targets = StringUtil.split((String)refSignature, (String)"|").stream().flatMap(s -> PhpIndex.getInstance((Project)project).getBySignature(s, visited, depth).stream()).findFirst();
        PhpNamedElement target = targets.orElse(null);
        if (target instanceof Method) {
            PhpClassHierarchyUtils.HierarchyClassMemberProcessor processor = (classMember, subClass, baseClass) -> {
                types.set(methods.get("#M#C" + classMember.getFQN()));
                return types.isNull();
            };
            processor.process((PhpClassMember)((Method)target), null, null);
            PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)((Method)target), (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)processor);
        } else if (target instanceof Function) {
            types.set(methods.get("#F" + target.getFQN()));
        } else if (target instanceof PhpClass) {
            types.set(methods.get(refSignature));
        } else if (target instanceof Variable && (aClass = (PhpClass)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)project).getBySignature("#C" + target.getType().toStringResolved()))) != null) {
            PhpClassHierarchyUtils.processSupers((PhpClass)aClass, (boolean)true, (boolean)false, aClass1 -> {
                types.set(methods.get("#C" + aClass1.getFQN()));
                return types.isNull();
            });
        }
        return (Map)types.get();
    }

    @Nullable
    public static Map<String, Map<String, String>> getStaticMethodTypesMap(Project project) {
        if (computing.get().booleanValue()) {
            return null;
        }
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, STATIC_FACTORY_TYPE_MAP, () -> {
            computing.set(true);
            Collection<PsiFile> files = PhpParameterBasedTypeProvider.getMetaFiles(project);
            LOG.info("COMPUTING MethodTypesMap ON " + files.stream().map(f -> f.getVirtualFile().getPresentableUrl() + " " + f.getVirtualFile().getModificationCount()).collect(Collectors.joining(", ")));
            Map<String, Map<String, String>> newMeta = PhpPBMetaBuilderNew.getMap(files);
            Map<String, Map<String, String>> legacyMeta = PhpPBMetaBuilderLegacy.getMap(files);
            THashMap result = new THashMap();
            result.putAll(legacyMeta);
            for (Map.Entry<String, Map<String, String>> entry : newMeta.entrySet()) {
                Map<String, String> current = (Map<String, String>)result.get(entry.getKey());
                if (current != null) {
                    current.putAll(entry.getValue());
                    continue;
                }
                current = entry.getValue();
                result.put(entry.getKey(), current);
            }
            List collect = files.stream().map(PsiFile::getVirtualFile).collect(Collectors.toList());
            collect.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            LOG.info("DONE COMPUTING MethodTypesMap => " + result.size());
            computing.set(false);
            return new CachedValueProvider.Result(Collections.unmodifiableMap(result), collect.toArray());
        }, false);
    }

    public static boolean isMeta(PsiElement element) {
        PsiFile file1 = element.getContainingFile();
        if (!(file1 instanceof PhpFile)) {
            return false;
        }
        VirtualFile file = file1.getVirtualFile();
        if (file == null) {
            return false;
        }
        if (PhpLangUtil.equalsIgnoreCase(file.getNameSequence(), PHPSTORM_META_PHP)) {
            return true;
        }
        VirtualFile parent = file.getParent();
        return parent != null && PhpLangUtil.equalsIgnoreCase(parent.getNameSequence(), PHPSTORM_META_PHP);
    }

    @NotNull
    public static Collection<PsiFile> getMetaFiles(Project project) {
        Collection collection = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            SmartList files = new SmartList();
            Collection filesByName = FilenameIndex.getVirtualFilesByName((Project)project, (String)PHPSTORM_META_PHP, (GlobalSearchScope)PhpIndex.getInstance((Project)project).getSearchScope());
            for (VirtualFile file : filesByName) {
                if (file.isDirectory()) {
                    Arrays.stream(file.getChildren()).map(f -> PsiManager.getInstance((Project)project).findFile(f)).forEach(arg_0 -> ((SmartList)files).add(arg_0));
                    continue;
                }
                files.add((Object)PsiManager.getInstance((Project)project).findFile(file));
            }
            return CachedValueProvider.Result.create((Object)files, (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
        });
        if (collection == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpParameterBasedTypeProvider", "getMetaFiles"));
    }

    class MyCompletionContributor
    extends CompletionContributor {
        MyCompletionContributor() {
        }

        public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                MyCompletionContributor.$$$reportNull$$$0(0);
            }
            if (result == null) {
                MyCompletionContributor.$$$reportNull$$$0(1);
            }
            ProcessingContext context = new ProcessingContext();
            PsiElement position = parameters.getPosition();
            if (parameters.getCompletionType() == CompletionType.BASIC && ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class)).accepts((Object)position, context)) {
                PhpPsiElement value;
                ArrayIndex index;
                Map map = null;
                ParameterListOwner parameterListOwner = (ParameterListOwner)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)position, ParameterListOwner.class);
                if (parameterListOwner instanceof FunctionReference) {
                    map = PhpParameterBasedTypeProvider.getTargets(((FunctionReference)parameterListOwner).getSignature(), null, 0, position.getProject());
                }
                if ((index = (ArrayIndex)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)position, ArrayIndex.class)) instanceof ArrayAccessExpression && (value = ((ArrayAccessExpression)index.getParent()).getValue()) instanceof PhpReference) {
                    map = PhpParameterBasedTypeProvider.getTargets(((PhpReference)value).getSignature(), null, 0, position.getProject());
                }
                if (map != null) {
                    for (String s : map.keySet()) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)s.replace('\u2265', '.')).withTypeText((String)map.get(s), true));
                    }
                }
            }
            super.fillCompletionVariants(parameters, result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpParameterBasedTypeProvider$MyCompletionContributor";
            objectArray[2] = "fillCompletionVariants";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

