/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.hierarchy.type;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.hierarchy.PhpHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;

final class PhpTypeHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    protected PhpTypeHierarchyNodeDescriptor(Project project, NodeDescriptor parentDescriptor, PsiElement element, boolean isBase) {
        super(project, parentDescriptor, element, isBase);
    }

    public PhpClass getPhpClass() {
        return (PhpClass)this.getPsiElement();
    }

    public boolean update() {
        boolean changes = super.update();
        PhpClass phpClass = this.getPhpClass();
        if (phpClass == null) {
            return this.invalidElement();
        }
        this.installIcon(changes);
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        this.myHighlightedText.getEnding().addText(phpClass.getName(), classNameAttributes);
        String className = phpClass.getName();
        String fileName = PhpHierarchyUtils.getFileNameContainingElement((PsiElement)phpClass);
        if (!PhpLangUtil.isObject(phpClass)) {
            this.myHighlightedText.getEnding().addText(" (" + fileName + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }
}

