/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.insert;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.insert.PhpInsertHandlerUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.actions.generation.PhpDocCreationOption;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpOverriddenMethodInsertHandler
implements InsertHandler<LookupElement> {
    private static final PhpOverriddenMethodInsertHandler INSTANCE = new PhpOverriddenMethodInsertHandler();

    protected PhpOverriddenMethodInsertHandler() {
    }

    public static PhpOverriddenMethodInsertHandler getInstance() {
        return INSTANCE;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement lookupElement) {
        Object namedElement;
        if (context == null) {
            PhpOverriddenMethodInsertHandler.$$$reportNull$$$0(0);
        }
        if (lookupElement == null) {
            PhpOverriddenMethodInsertHandler.$$$reportNull$$$0(1);
        }
        if ((namedElement = lookupElement.getObject()) instanceof Method && ((Method)namedElement).isValid()) {
            Object currentMethod;
            Object groupStatement;
            int offset;
            PsiElement position;
            PhpDocComment phpDoc;
            Editor editor;
            Method method = (Method)namedElement;
            PsiFile file = context.getFile();
            PhpClass targetClass = PhpOverriddenMethodInsertHandler.getTargetClass(file, editor = context.getEditor(), phpDoc = (PhpDocComment)PhpPsiUtil.getParentByCondition(position = file.findElementAt(offset = editor.getCaretModel().getOffset()), true, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF));
            if (targetClass != null && (groupStatement = PhpPsiUtil.getChildByCondition(currentMethod = PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)Method.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF), (Condition<? super PsiElement>)GroupStatement.INSTANCEOF)) == null) {
                String template;
                int openingParenthesisIndex;
                if (context.getCompletionChar() == '(') {
                    context.setAddCompletionChar(false);
                }
                if ((openingParenthesisIndex = (template = PhpCodeUtil.createOverridingMethodText(targetClass, method, null, PhpDocCreationOption.NONE, phpDoc)).indexOf("(")) < 0) {
                    return;
                }
                String text = phpDoc != null ? template.substring(openingParenthesisIndex, template.indexOf("{")).trim() : (targetClass.isInterface() ? template.substring(openingParenthesisIndex, template.indexOf("{")).trim() + ";" : template.substring(openingParenthesisIndex));
                RangeMarker rangeMarker = editor.getDocument().createRangeMarker(offset, offset);
                rangeMarker.setGreedyToRight(true);
                PhpInsertHandlerUtil.insertStringAtCaret(editor, text);
                Project project = context.getProject();
                CodeStyleManager.getInstance((Project)project).reformatText(file, rangeMarker.getStartOffset(), rangeMarker.getEndOffset() + 1);
                PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)targetClass);
                if (scopeHolder != null) {
                    PsiElement newPosition = file.findElementAt(offset);
                    Method newMethod = (Method)PhpPsiUtil.getParentByCondition(newPosition, true, (Condition<? super PsiElement>)Method.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                    if (newMethod == null && newPosition != null) {
                        newMethod = (Method)PhpPsiUtil.getParentByCondition(newPosition.getPrevSibling(), false, (Condition<? super PsiElement>)Method.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                    }
                    if (newMethod != null) {
                        PhpClassReferenceResolver resolver = new PhpClassReferenceResolver();
                        for (Parameter parameter : method.getParameters()) {
                            resolver.processElement((PsiElement)parameter, false);
                        }
                        PhpReturnType returnType = method.getReturnType();
                        if (returnType != null) {
                            resolver.processElement((PsiElement)returnType);
                        }
                        resolver.importReferences(scopeHolder, (PsiElement)newMethod);
                    }
                }
            }
        }
    }

    @Nullable
    private static PhpClass getTargetClass(@NotNull PsiFile file, @NotNull Editor editor, @Nullable PhpDocComment phpDoc) {
        PhpPsiElement sibling;
        PhpClass targetClass;
        if (file == null) {
            PhpOverriddenMethodInsertHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PhpOverriddenMethodInsertHandler.$$$reportNull$$$0(3);
        }
        if ((targetClass = PhpCodeEditUtil.findClassAtCaret(editor, file)) == null && phpDoc != null && (sibling = phpDoc.getNextPsiSibling()) instanceof PhpClass) {
            targetClass = (PhpClass)sibling;
        }
        return targetClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/completion/insert/PhpOverriddenMethodInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

