/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpFieldReferenceByVariableTypeDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.NotNull;

public class PhpFieldReferenceByVariableTypeAnalyzer
extends PhpTypeAnalyzerProcessor {
    @NotNull
    private final CharSequence myFieldName;
    @NotNull
    private final CharSequence myVariableName;

    public PhpFieldReferenceByVariableTypeAnalyzer(@NotNull CharSequence fieldName, @NotNull CharSequence variableName) {
        if (fieldName == null) {
            PhpFieldReferenceByVariableTypeAnalyzer.$$$reportNull$$$0(0);
        }
        if (variableName == null) {
            PhpFieldReferenceByVariableTypeAnalyzer.$$$reportNull$$$0(1);
        }
        this.myFieldName = fieldName;
        this.myVariableName = variableName;
    }

    public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction curInstruction) {
        if (PhpLangUtil.equalsFieldNames(this.myFieldName, curInstruction.getFieldName())) {
            return this.processAccessInstruction((PhpAccessInstruction)curInstruction);
        }
        return true;
    }

    public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction curInstruction) {
        if (PhpLangUtil.equalsVariableNames(this.myVariableName, curInstruction.getVariableName()) && PhpLangUtil.equalsFieldNames(this.myFieldName, curInstruction.getFieldName()) && (curInstruction.getAccess().isWrite() || curInstruction.getAccess().isWriteRef())) {
            return this.processAccessInstruction((PhpAccessInstruction)curInstruction);
        }
        return true;
    }

    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        PhpAccessInstruction.Access access;
        if (PhpLangUtil.equalsVariableNames(this.myVariableName, instruction.getVariableName()) && (access = instruction.getAccess()).isWrite()) {
            return false;
        }
        return super.processAccessVariableInstruction(instruction);
    }

    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
        PhpFieldReferenceByVariableTypeDFAnalyzer analyzer = new PhpFieldReferenceByVariableTypeDFAnalyzer(this.myFieldName, this.myVariableName);
        PhpType type = (PhpType)analyzer.performDFA(instruction.getCondition(), instruction.getResult());
        if (!type.isEmpty()) {
            this.setType(type);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fieldName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "variableName";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/codeInsight/typeInference/PhpFieldReferenceByVariableTypeAnalyzer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

