/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.codeInsight.highlighting.PhpConversionSpecificationParser;
import com.jetbrains.php.lang.intentions.stringDoc.PhpHeredocToStringIntention;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class PhpHighlightFormatStringParametersUsagesHandler
extends HighlightUsagesHandlerBase<StringLiteralExpression> {
    private final int myFormatExpressionIndex;
    private final int mySelectedParameterIndex;
    private final PsiElement[] myParameters;

    PhpHighlightFormatStringParametersUsagesHandler(Editor editor, PsiFile file, int formatExpressionIndex, int selectedParameterIndex, PsiElement[] parameters) {
        super(editor, file);
        this.myFormatExpressionIndex = formatExpressionIndex;
        this.mySelectedParameterIndex = selectedParameterIndex;
        this.myParameters = parameters;
    }

    public List<StringLiteralExpression> getTargets() {
        StringLiteralExpression format = (StringLiteralExpression)ObjectUtils.tryCast((Object)this.myParameters[this.myFormatExpressionIndex], StringLiteralExpression.class);
        return format != null ? Collections.singletonList(format) : Collections.emptyList();
    }

    protected void selectTargets(List<StringLiteralExpression> targets, Consumer<List<StringLiteralExpression>> selectionConsumer) {
        selectionConsumer.consume(targets);
    }

    public void computeUsages(List<StringLiteralExpression> targets) {
        int parameterIndex;
        StringLiteralExpression formatExpression = (StringLiteralExpression)ContainerUtil.getFirstItem(targets);
        if (formatExpression == null) {
            return;
        }
        MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> specificationsWithIndices = PhpConversionSpecificationParser.parseConversionSpecifications(formatExpression.getContents(), formatExpression.isSingleQuote() || PhpHeredocToStringIntention.isNowdoc((PsiElement)formatExpression));
        int specificationIndex = this.mySelectedParameterIndex == this.myFormatExpressionIndex ? this.resolveConversionIndexFromCaret(formatExpression, specificationsWithIndices) : this.mySelectedParameterIndex - this.myFormatExpressionIndex;
        Collection specifications = specificationsWithIndices.get((Object)specificationIndex);
        for (PhpConversionSpecificationParser.ConversionSpecification specification : specifications) {
            this.myReadUsages.add(PhpHighlightFormatStringParametersUsagesHandler.getRangeInsideDocument(formatExpression, specification.getRangeInElement()));
        }
        int n = parameterIndex = specificationIndex >= 0 ? this.myFormatExpressionIndex + specificationIndex : specificationIndex;
        if (!specifications.isEmpty() && parameterIndex >= 0 && parameterIndex < this.myParameters.length) {
            this.addOccurrence(this.myParameters[parameterIndex]);
        }
    }

    @NotNull
    private static TextRange getRangeInsideDocument(@NotNull StringLiteralExpression formatExpression, @NotNull TextRange rangeInsideExpression) {
        if (formatExpression == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(0);
        }
        if (rangeInsideExpression == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(1);
        }
        TextRange textRange = InjectedLanguageManager.getInstance((Project)formatExpression.getProject()).injectedToHost((PsiElement)formatExpression, rangeInsideExpression).shiftRight(formatExpression.getTextOffset()).shiftRight(formatExpression.getValueRange().getStartOffset());
        if (textRange == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    private int resolveConversionIndexFromCaret(@NotNull StringLiteralExpression formatExpression, @NotNull MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> specifications) {
        if (formatExpression == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(3);
        }
        if (specifications == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(4);
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        return StreamEx.of((Collection)specifications.entrySet()).findFirst(e -> {
            if (formatExpression == null) {
                PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(5);
            }
            return PhpHighlightFormatStringParametersUsagesHandler.specificationAtCaretOffsetExists(caretOffset, formatExpression, (Collection)e.getValue());
        }).map(Map.Entry::getKey).orElse(-1);
    }

    private static boolean specificationAtCaretOffsetExists(int caretOffset, StringLiteralExpression formatExpression, Collection<PhpConversionSpecificationParser.ConversionSpecification> specifications) {
        return specifications.stream().map(e -> PhpHighlightFormatStringParametersUsagesHandler.getRangeInsideDocument(formatExpression, e.getRangeInElement())).anyMatch(range -> range.containsOffset(caretOffset));
    }

    public boolean highlightReferences() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/highlighting/PhpHighlightFormatStringParametersUsagesHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/highlighting/PhpHighlightFormatStringParametersUsagesHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInsideDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInsideDocument";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveConversionIndexFromCaret";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveConversionIndexFromCaret$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

