/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.options;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class SqlCodeCompletionOptionPanel {
    private JPanel myPanel;
    private JBCheckBox myUseAliasesInCompletionJBCheckBox;
    private JBCheckBox myAutoAliasTableJBCheckBox;
    private final JBTable myCustomAliasesJBTable;
    private JBCheckBox myInvertOrderOfOperandsInJoinOnJBCheckBox;
    private JBCheckBox mySuggestTableAliasNamesJBCheckBox;
    private JPanel myAliasesTablePanel;

    public SqlCodeCompletionOptionPanel() {
        this.$$$setupUI$$$();
        this.myCustomAliasesJBTable = new JBTable(){

            @NotNull
            public StatusText getEmptyText() {
                StatusText emptyText = new StatusText(){

                    protected boolean isStatusVisible() {
                        return this.isEmpty();
                    }
                };
                emptyText.setText("No custom aliases");
                emptyText.appendSecondaryText("Add alias", SimpleTextAttributes.LINK_ATTRIBUTES, ev -> SqlCodeCompletionOptionPanel.this.doAddRow());
                StatusText statusText = emptyText;
                if (statusText == null) {
                    1.$$$reportNull$$$0(0);
                }
                return statusText;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/options/SqlCodeCompletionOptionPanel$1", "getEmptyText"));
            }
        };
        this.initTable();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myCustomAliasesJBTable);
        decorator.setAddAction(e -> this.doAddRow()).setAddActionName("Add alias");
        decorator.setRemoveAction(e -> this.doRemoveRows()).setRemoveActionName("Remove alias").setRemoveActionUpdater(e -> !this.isEditing());
        this.myAliasesTablePanel.add((Component)decorator.createPanel(), "Center");
    }

    private void initTable() {
        this.myCustomAliasesJBTable.setBackground(UIUtil.getEditorPaneBackground());
        this.myCustomAliasesJBTable.setBorder(BorderFactory.createEtchedBorder());
        this.myCustomAliasesJBTable.setName("valueTable");
        this.myCustomAliasesJBTable.setRowHeight(20);
        this.myCustomAliasesJBTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myCustomAliasesJBTable.setStriped(true);
        this.myCustomAliasesJBTable.registerKeyboardAction(e -> this.doRemoveRows(), KeyStroke.getKeyStroke(127, 0), 0);
        this.myCustomAliasesJBTable.registerKeyboardAction(e -> {
            int row = this.myCustomAliasesJBTable.getSelectedRow();
            int column2 = this.myCustomAliasesJBTable.getSelectedColumn();
            if (row >= 0 && column2 >= 0) {
                this.myCustomAliasesJBTable.editCellAt(row, column2);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
    }

    private boolean isEditing() {
        return this.myCustomAliasesJBTable.getEditingRow() != -1;
    }

    private void doAddRow() {
        int count2 = this.myCustomAliasesJBTable.getRowCount();
        ((SqlAliasesTableModel)this.myCustomAliasesJBTable.getModel()).addRow();
        this.myCustomAliasesJBTable.invalidate();
        this.myCustomAliasesJBTable.repaint();
        this.myCustomAliasesJBTable.getSelectionModel().setSelectionInterval(count2, count2);
        this.myCustomAliasesJBTable.scrollRectToVisible(this.myCustomAliasesJBTable.getCellRect(count2, 0, true));
        this.myCustomAliasesJBTable.editCellAt(count2, 0);
    }

    private void doRemoveRows() {
        int[] rows;
        if (this.isEditing()) {
            return;
        }
        for (int row : rows = this.myCustomAliasesJBTable.getSelectedRows()) {
            ((SqlAliasesTableModel)this.myCustomAliasesJBTable.getModel()).removeRow(row);
        }
        this.myCustomAliasesJBTable.invalidate();
        this.myCustomAliasesJBTable.repaint();
        int min = ArrayUtil.min((int[])rows);
        if (min < 1) {
            ++min;
        }
        this.myCustomAliasesJBTable.getSelectionModel().setSelectionInterval(min - 1, min - 1);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public JBCheckBox getUseAliasesInCompletionJBCheckBox() {
        return this.myUseAliasesInCompletionJBCheckBox;
    }

    public JBCheckBox getAutoAliasTableJBCheckBox() {
        return this.myAutoAliasTableJBCheckBox;
    }

    public JBTable getCustomAliasesJBTable() {
        return this.myCustomAliasesJBTable;
    }

    public JBCheckBox getInvertOrderOfOperandsInJoinOnJBCheckBox() {
        return this.myInvertOrderOfOperandsInJoinOnJBCheckBox;
    }

    public JBCheckBox getSuggestTableAliasNamesJBCheckBox() {
        return this.mySuggestTableAliasNamesJBCheckBox;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        JBCheckBox jBCheckBox4;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.setMaximumSize(new Dimension(-1, -1));
        jPanel2.setPreferredSize(new Dimension(-1, -1));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.putClientProperty("html.disable", Boolean.FALSE);
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"SQL", (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(8, 0, 1, 2, 2, 1, 1, 7, null, null, null));
        this.myUseAliasesInCompletionJBCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setSelected(false);
        jBCheckBox4.setText("Use aliases in completion for JOIN");
        jPanel2.add((Component)jBCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myAliasesTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 7, new Dimension(-1, 150), new Dimension(400, 150), null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Custom aliases:");
        jPanel2.add((Component)jBLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInvertOrderOfOperandsInJoinOnJBCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Invert order of operands in auto-generated ON clause");
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySuggestTableAliasNamesJBCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setActionCommand("Suggest alias names in completion after table names");
        jBCheckBox2.setText("Suggest alias names in completion after table names");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoAliasTableJBCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(false);
        jBCheckBox.setText("Automatically add aliases when completing table names");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("JOIN clauses");
        jPanel2.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Table aliases");
        jPanel2.add((Component)titledSeparator2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    static class SqlAliasesTableModel
    extends AbstractTableModel {
        private final Map<String, String> myMappings;
        private final List<String> myKeys;

        Map<String, String> getMappings() {
            if (!this.myMappings.containsKey("")) {
                return this.myMappings;
            }
            HashMap copy = ContainerUtil.newHashMap(this.myMappings);
            copy.remove("");
            return copy;
        }

        SqlAliasesTableModel(Map<String, String> mappings) {
            this.myMappings = mappings;
            this.myKeys = ContainerUtil.newArrayList(this.myMappings.keySet());
        }

        @Override
        public int getRowCount() {
            return this.myKeys.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String key2 = this.myKeys.get(rowIndex);
            return columnIndex == 0 ? key2 : this.myMappings.get(key2);
        }

        public void addRow() {
            this.myKeys.add("");
            this.myMappings.put("", "");
        }

        public void removeRow(int rowIndex) {
            this.myMappings.remove(this.myKeys.remove(rowIndex));
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            String valueToSet = (String)aValue;
            String key2 = this.myKeys.get(rowIndex);
            if (columnIndex == 1) {
                if (StringUtil.isEmptyOrSpaces((String)key2) && StringUtil.isEmptyOrSpaces((String)valueToSet)) {
                    this.myMappings.remove(key2);
                    this.myKeys.remove(key2);
                } else {
                    this.myMappings.replace(key2, valueToSet);
                }
                return;
            }
            String value = this.myMappings.get(key2);
            this.myMappings.remove(key2);
            if (!StringUtil.isEmptyOrSpaces((String)value) || !StringUtil.isEmptyOrSpaces((String)valueToSet)) {
                this.myKeys.set(rowIndex, valueToSet);
                this.myMappings.put(valueToSet, value);
            } else {
                this.myKeys.remove(rowIndex);
            }
        }

        @Override
        public String getColumnName(int column2) {
            return column2 == 0 ? "Name" : "Alias";
        }
    }
}

