/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntHashSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableColumn> {
    private final Dbms myDbms;
    private final JdbcHelper myJdbcHelper;
    private final DatabaseMetaDataWrapper.Schema mySchema;
    private final TIntHashSet myPositions;
    private String myPrevName;

    public TableColumnIt(@Nullable ResultSet rs, @NotNull Dbms dbms, @NotNull DatabaseMetaDataWrapper.Schema schema) throws SQLException {
        if (dbms == null) {
            TableColumnIt.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            TableColumnIt.$$$reportNull$$$0(1);
        }
        super(rs);
        this.myPositions = new TIntHashSet();
        this.myDbms = dbms;
        this.mySchema = schema;
        this.myJdbcHelper = DbImplUtil.getJdbcHelper(this.myDbms);
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableColumn createStorage() {
        DatabaseMetaDataWrapper.TableColumn tableColumn = new DatabaseMetaDataWrapper.TableColumn(new DatabaseMetaDataWrapper.Table(this.mySchema, ""));
        if (tableColumn == null) {
            TableColumnIt.$$$reportNull$$$0(2);
        }
        return tableColumn;
    }

    @Override
    protected DatabaseMetaDataWrapper.TableColumn calcValue() throws SQLException {
        DatabaseMetaDataWrapper.TableColumn res2 = (DatabaseMetaDataWrapper.TableColumn)this.getStorageToFill();
        try {
            String table = this.myRs.getString("TABLE_NAME", 3);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TABLE_SCHEM", 2), (String)this.mySchema.schema);
            if (!Comparing.equal((String)this.mySchema.schema, (String)schema)) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            if (StringUtil.isEmpty((String)table)) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            if (!Comparing.equal((String)this.myPrevName, (String)table)) {
                this.myPositions.clear();
                this.myPrevName = table;
            }
            res2.table.name = table;
            res2.name = this.myRs.getString("COLUMN_NAME", 4);
            if (StringUtil.isEmpty((String)res2.name)) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            res2.type = this.myRs.getInt("DATA_TYPE", 5, 0);
            res2.typeName = StringUtil.notNullize((String)this.myRs.getString("TYPE_NAME", 6));
            res2.typeSuffix = null;
            res2.length = this.myRs.getInt("COLUMN_SIZE", 7, 0);
            res2.scale = this.myRs.getInt("DECIMAL_DIGITS", 9, 0);
            this.myJdbcHelper.adjustType((JdbcHelper.Type)res2);
            res2.nullable = this.myRs.getInt("NULLABLE", 11, 0) != 0;
            res2.def = this.myRs.getString("COLUMN_DEF", 13);
            res2.position = this.myRs.getInt("ORDINAL_POSITION", 17, 0);
            if (res2.position == -1) {
                res2.position = 0;
            }
            while (this.myPositions.contains(res2.position)) {
                ++res2.position;
            }
            this.myPositions.add(res2.position);
            res2.comment = this.myRs.getString("REMARKS", 12);
            String aincYN = this.myRs.getString("IS_AUTOINCREMENT", 23);
            res2.autoIncrement = "yes".equalsIgnoreCase(aincYN);
            if (aincYN == null && this.myDbms.isTransactSql()) {
                res2.autoIncrement = res2.typeName != null && res2.typeName.endsWith(" identity");
            }
        }
        catch (SQLException e) {
            this.onError(res2, e);
            return (DatabaseMetaDataWrapper.TableColumn)this.skip();
        }
        return res2;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.table.schema.database, cur.table.schema.schema, cur.table.name);
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/TableColumnIt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/TableColumnIt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.TableColumn, DatabaseMetaDataWrapper.TableColumn> {
        public Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableColumn> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableColumn> it) {
            final String tableName = ((DatabaseMetaDataWrapper.TableColumn)it.current()).table.name;
            ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn> groupIt = new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableColumn item) {
                    return Comparing.equal((String)tableName, (String)item.table.name);
                }
            };
            if (groupIt == null) {
                Grouping.$$$reportNull$$$0(1);
            }
            return groupIt;
        }

        @Override
        protected DatabaseMetaDataWrapper.Table getItem(ClosableIt<DatabaseMetaDataWrapper.TableColumn> it) {
            return ((DatabaseMetaDataWrapper.TableColumn)it.current()).table;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/TableColumnIt$Grouping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/TableColumnIt$Grouping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGroupIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

