/**
 */
var Range = {
}
/**
 * Moves the contents of a Range from the containing document or document fragment to a new DocumentFragment.
 * @syntax range.extractContents()
 * @returns {DocumentFragment} A DocumentFragment containing the extracted contents.
 */
Range.prototype.extractContents = function() {};

/**
 * Compare start boundary-point of sourceRange to end boundary-point of Range on which compareBoundaryPoints is invoked.
 * @syntax Range.START_TO_END
 * @returns {Number} 
 * @static
 */
Range.START_TO_END = new Number();

/**
 * Select the contents within a node
 * @syntax range.selectNodeContents(refNode)
 * @param {Node} refNode Node to select from
 * @returns {undefined} 
 */
Range.prototype.selectNodeContents = function(refNode) {};

/**
 * Compare the boundary-points of two Ranges in a document.
 * @syntax range.compareBoundaryPoints(how, sourceRange)
 * @param {Number} how A code representing the type of comparison, as defined above.
 * @param {Range} sourceRange The Range on which this current Range is compared to.
 * @returns {Number} -1, 0 or 1 depending on whether the corresponding boundary-point of the Range is respectively before, equal to, or after the corresponding boundary-point of sourceRange.
 */
Range.prototype.compareBoundaryPoints = function(how,  sourceRange) {};

/**
 * Removes the contents of a Range from the containing document or document fragment without returning a reference to the removed content.
 * @syntax range.deleteContents()
 * @returns {undefined} 
 */
Range.prototype.deleteContents = function() {};

/**
 * Offset within the starting node of the Range. Exceptions on retrieval DOMException INVALID_STATE_ERR: Raised if detach() has already been invoked on this object.
 * @syntax range.startOffset
 * @returns {Number} 
 */
Range.prototype.startOffset = new Number();

/**
 * Select a node and its contents
 * @syntax range.selectNode(refNode)
 * @param {Node} refNode The node to select.
 * @returns {undefined} 
 */
Range.prototype.selectNode = function(refNode) {};

/**
 * Produces a new Range whose boundary-points are equal to the boundary-points of the Range.
 * @syntax range.cloneRange()
 * @returns {Range} The duplicated Range.
 */
Range.prototype.cloneRange = function() {};

/**
 * Offset within the ending node of the Range. Exceptions on retrieval DOMException INVALID_STATE_ERR: Raised if detach() has already been invoked on this object.
 * @syntax range.endOffset
 * @returns {Number} 
 */
Range.prototype.endOffset = new Number();

/**
 * Compare end boundary-point of sourceRange to end boundary-point of Range on which compareBoundaryPoints is invoked.
 * @syntax Range.END_TO_END
 * @returns {Number} 
 * @static
 */
Range.END_TO_END = new Number();

/**
 * Node within which the Range begins Exceptions on retrieval DOMException INVALID_STATE_ERR: Raised if detach() has already been invoked on this object.
 * @syntax range.startContainer
 * @returns {Node} 
 */
Range.prototype.startContainer = new Node();

/**
 * Node within which the Range ends Exceptions on retrieval DOMException INVALID_STATE_ERR: Raised if detach() has already been invoked on this object.
 * @syntax range.endContainer
 * @returns {Node} 
 */
Range.prototype.endContainer = new Node();

/**
 * Sets the start position to be before a node
 * @syntax range.setStartBefore(refNode)
 * @param {Node} refNode Range starts before refNode
 * @returns {undefined} 
 */
Range.prototype.setStartBefore = function(refNode) {};

/**
 * Sets the attributes describing the end of a Range.
 * @syntax range.setEnd(refNode, offset)
 * @param {Node} refNode The refNode value. This parameter must be different from null.
 * @param {Number} offset The endOffset value.
 * @returns {undefined} 
 */
Range.prototype.setEnd = function(refNode,  offset) {};

/**
 * Collapse a Range onto one of its boundary-points
 * @syntax range.collapse(toStart)
 * @param {boolean} toStart If TRUE, collapses the Range onto its start; if FALSE, collapses it onto its end.
 * @returns {undefined} 
 */
Range.prototype.collapse = function(toStart) {};

/**
 * Called to indicate that the Range is no longer in use and that the implementation may relinquish any resources associated with this Range. Subsequent calls to any methods or attribute getters on this Range will result in a DOMException being thrown with an error code of INVALID_STATE_ERR.
 * @syntax range.detach()
 * @returns {undefined} 
 */
Range.prototype.detach = function() {};

/**
 * Inserts a node into the Document or DocumentFragment at the start of the Range. If the container is a Text node, this will be split at the start of the Range (as if the Text node's splitText method was performed at the insertion point) and the insertion will occur between the two resulting Text nodes. Adjacent Text nodes will not be automatically merged. If the node to be inserted is a DocumentFragment node, the children will be inserted rather than the DocumentFragment node itself.
 * @syntax range.insertNode(newNode)
 * @param {Node} newNode The node to insert at the start of the Range
 * @returns {undefined} 
 */
Range.prototype.insertNode = function(newNode) {};

/**
 * Compare end boundary-point of sourceRange to start boundary-point of Range on which compareBoundaryPoints is invoked.
 * @syntax Range.END_TO_START
 * @returns {Number} 
 * @static
 */
Range.END_TO_START = new Number();

/**
 * Sets the start position to be after a node
 * @syntax range.setStartAfter(refNode)
 * @param {Node} refNode Range starts after refNode
 * @returns {undefined} 
 */
Range.prototype.setStartAfter = function(refNode) {};

/**
 * TRUE if the Range is collapsed Exceptions on retrieval DOMException INVALID_STATE_ERR: Raised if detach() has already been invoked on this object.
 * @syntax range.collapsed
 * @returns {boolean} 
 */
Range.prototype.collapsed = new boolean();

/**
 * Reparents the contents of the Range
 * @syntax range.surroundContents(newParent)
 * @param {Node} newParent The node to surround the contents with.
 * @returns {undefined} 
 */
Range.prototype.surroundContents = function(newParent) {};

/**
 * Duplicates the contents of a Range
 * @syntax range.cloneContents()
 * @returns {DocumentFragment} A DocumentFragment that contains content equivalent to this Range.
 */
Range.prototype.cloneContents = function() {};

/**
 * Compare start boundary-point of sourceRange to start boundary-point of Range on which compareBoundaryPoints is invoked.
 * @syntax Range.START_TO_START
 * @returns {Number} 
 * @static
 */
Range.START_TO_START = new Number();

/**
 * Sets the attributes describing the start of the Range.
 * @syntax range.setStart(refNode, offset)
 * @param {Node} refNode The refNode value. This parameter must be different from null.
 * @param {Number} offset The startOffset value.
 * @returns {undefined} 
 */
Range.prototype.setStart = function(refNode,  offset) {};

/**
 * The deepest common ancestor container of the Range's two boundary-points. Exceptions on retrieval DOMException INVALID_STATE_ERR: Raised if detach() has already been invoked on this object.
 * @syntax range.commonAncestorContainer
 * @returns {Node} 
 */
Range.prototype.commonAncestorContainer = new Node();

/**
 * Returns the contents of a Range as a string. This string contains only the data characters, not any markup.
 * @syntax range.toString()
 * @returns {String} The contents of the Range.
 */
Range.prototype.toString = function() {};

/**
 * Sets the end of a Range to be after a node
 * @syntax range.setEndAfter(refNode)
 * @param {Node} refNode Range ends after refNode.
 * @returns {undefined} 
 */
Range.prototype.setEndAfter = function(refNode) {};

/**
 * Sets the end position to be before a node.
 * @syntax range.setEndBefore(refNode)
 * @param {Node} refNode Range ends before refNode
 * @returns {undefined} 
 */
Range.prototype.setEndBefore = function(refNode) {};

/**
 * Represents the Range prototype object.
 * @syntax Range.prototype
 * @static
 */
Range.prototype;

