/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.reformat.BracesStack;
import org.netbeans.modules.cnd.editor.reformat.DiffLinkedList;
import org.netbeans.modules.cnd.editor.reformat.ExtendedTokenSequence;
import org.netbeans.modules.cnd.editor.reformat.Reformatter;
import org.netbeans.modules.cnd.editor.reformat.ReformatterImpl;

public class PreprocessorFormatter {
    private final ReformatterImpl context;
    private final ExtendedTokenSequence ts;
    private final CodeStyle codeStyle;
    private final DiffLinkedList diffs;
    private int prepocessorDepth = 0;
    private final Stack<PreprocessorStateStack> stateStack = new Stack();
    private final BracesStack braces;

    PreprocessorFormatter(ReformatterImpl context) {
        this.context = context;
        this.ts = context.ts;
        this.codeStyle = context.codeStyle;
        this.diffs = context.diffs;
        this.braces = context.braces;
    }

    void indentPreprocessor(Token<CppTokenId> previous) {
        TokenSequence prep = this.ts.embedded(CppTokenId.languagePreproc());
        if (prep == null) {
            return;
        }
        prep.moveStart();
        while (prep.moveNext() && (prep.token().id() == CppTokenId.WHITESPACE || prep.token().id() == CppTokenId.PREPROCESSOR_START || prep.token().id() == CppTokenId.PREPROCESSOR_START_ALT)) {
        }
        Token directive = null;
        boolean atSharp = false;
        if (prep.token() != null) {
            directive = prep.token();
        }
        PreprocessorStateStack ps = null;
        if (directive != null) {
            switch ((CppTokenId)directive.id()) {
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ELIF: {
                    --this.prepocessorDepth;
                    if (this.stateStack.empty()) break;
                    ps = this.stateStack.pop();
                    ps.outputStack.add(this.braces.clone());
                    this.braces.reset(ps.inputStack);
                    break;
                }
                case PREPROCESSOR_ENDIF: {
                    --this.prepocessorDepth;
                    if (this.stateStack.empty()) break;
                    ps = this.stateStack.pop();
                    ps.outputStack.add(this.braces.clone());
                    this.braces.reset(ps.getBestOutputStack());
                }
            }
            if (this.context.doFormat()) {
                while (prep.movePrevious()) {
                    if (prep.token().id() != CppTokenId.PREPROCESSOR_START && prep.token().id() != CppTokenId.PREPROCESSOR_START_ALT) continue;
                    atSharp = true;
                    break;
                }
            }
        }
        if (atSharp) {
            this.selectPreprocessorIndent(previous, prep);
            if (prep.moveNext()) {
                Token prev = prep.token();
                while (prep.moveNext()) {
                    Token current = prep.token();
                    if (current.id() == CppTokenId.WHITESPACE) {
                        this.replaceCurrentImbeded(prep, (Token<CppTokenId>)current, (Token<CppTokenId>)prev);
                    } else if (current.id() == CppTokenId.ESCAPED_WHITESPACE) {
                        this.replaceCurrentImbeded(prep, (Token<CppTokenId>)current, (Token<CppTokenId>)prev);
                    }
                    prev = current;
                }
            }
        }
        if (directive != null) {
            switch ((CppTokenId)directive.id()) {
                case PREPROCESSOR_IF: 
                case PREPROCESSOR_IFDEF: 
                case PREPROCESSOR_IFNDEF: {
                    ++this.prepocessorDepth;
                    this.stateStack.push(new PreprocessorStateStack(this.braces.clone()));
                    break;
                }
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ELIF: {
                    ++this.prepocessorDepth;
                    if (ps != null) {
                        this.stateStack.push(ps);
                        break;
                    }
                    this.stateStack.push(new PreprocessorStateStack(this.braces.clone()));
                }
            }
        }
    }

    private void selectPreprocessorIndent(Token<CppTokenId> previous, TokenSequence<CppTokenId> prep) {
        Token next = null;
        if (prep.moveNext()) {
            next = prep.token();
            prep.movePrevious();
        }
        switch (this.codeStyle.indentPreprocessorDirectives()) {
            case CODE_INDENT: {
                this.indentByCode(previous, prep, (Token<CppTokenId>)next);
                break;
            }
            case START_LINE: {
                this.noIndent(previous, prep, (Token<CppTokenId>)next);
                break;
            }
            case PREPROCESSOR_INDENT: {
                this.indentByPreprocessor(previous, prep, (Token<CppTokenId>)next);
            }
        }
    }

    private void noIndent(Token<CppTokenId> previous, TokenSequence<CppTokenId> prep, Token<CppTokenId> next) {
        this.indentBefore(previous, 0, false);
        this.indentAfter(prep, next, 0);
    }

    private int textLength(String text, boolean startLine) {
        if (startLine) {
            int l = 0;
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) == '\t') {
                    if (this.context.tabSize > 1) {
                        l += this.context.tabSize;
                        continue;
                    }
                    ++l;
                    continue;
                }
                ++l;
            }
            return l;
        }
        return text.length();
    }

    private void replaceCurrentImbeded(TokenSequence<CppTokenId> prep, Token<CppTokenId> current, Token<CppTokenId> previous) {
        String old = current.text().toString();
        if (current.id() == CppTokenId.WHITESPACE) {
            int l = this.textLength(old, previous.id() == CppTokenId.ESCAPED_LINE);
            if (!Reformatter.Diff.equals(old, 0, l, false, this.context.expandTabToSpaces, this.context.tabSize)) {
                this.diffs.addFirst(prep.offset(), prep.offset() + current.length(), 0, l, previous.id() == CppTokenId.ESCAPED_LINE);
            }
        } else if (current.id() == CppTokenId.ESCAPED_WHITESPACE) {
            int beg = -1;
            for (int i = 0; i < old.length(); ++i) {
                if (old.charAt(i) != '\\') continue;
                beg = i;
                break;
            }
            if (beg > 0) {
                String rest;
                int l;
                String first = old.substring(0, beg);
                if (!Reformatter.Diff.equals(first, 0, l = this.textLength(first, previous.id() == CppTokenId.ESCAPED_LINE), false, this.context.expandTabToSpaces, this.context.tabSize)) {
                    this.diffs.addFirst(prep.offset(), prep.offset() + first.length(), 0, l, false);
                }
                if (!Reformatter.Diff.equals(rest = old.substring(beg + 2), 0, l = this.textLength(rest, true), false, this.context.expandTabToSpaces, this.context.tabSize)) {
                    this.diffs.addFirst(prep.offset() + beg + 2, prep.offset() + old.length(), 0, l, true);
                }
            }
        }
    }

    private void indentBefore(Token<CppTokenId> previous, int spaces, boolean isIndent) {
        DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
        if (diff != null) {
            if (diff.after != null) {
                diff.after.replaceSpaces(spaces, isIndent);
                if (diff.replace != null && !diff.after.hasNewLine()) {
                    diff.replace.replaceSpaces(0, false);
                }
                return;
            }
            if (diff.replace != null) {
                diff.replace.replaceSpaces(spaces, isIndent);
                return;
            }
        }
        if (previous != null && previous.id() == CppTokenId.WHITESPACE) {
            if (!Reformatter.Diff.equals(previous.text().toString(), 0, spaces, isIndent, this.context.expandTabToSpaces, this.context.tabSize)) {
                this.ts.replacePrevious(previous, 0, spaces, isIndent);
            }
        } else if (spaces > 0) {
            this.ts.addBeforeCurrent(0, spaces, isIndent);
        }
    }

    private void indentAfter(TokenSequence<CppTokenId> prep, Token<CppTokenId> next, int spaces) {
        if (next.id() == CppTokenId.WHITESPACE) {
            if (!Reformatter.Diff.equals(next.text().toString(), 0, spaces, false, this.context.expandTabToSpaces, this.context.tabSize)) {
                this.diffs.addFirst(prep.offset() + prep.token().length(), prep.offset() + prep.token().length() + next.length(), 0, spaces, false);
            }
        } else if (spaces > 0) {
            this.diffs.addFirst(prep.offset() + prep.token().length(), prep.offset() + prep.token().length(), 0, spaces, false);
        }
    }

    private void indentByCode(Token<CppTokenId> previous, TokenSequence<CppTokenId> prep, Token<CppTokenId> next) {
        if (this.codeStyle.sharpAtStartLine()) {
            this.indentBefore(previous, 0, false);
            this.indentAfter(prep, next, this.context.getIndent());
        } else {
            this.indentBefore(previous, this.context.getIndent(), true);
            this.indentAfter(prep, next, 0);
        }
    }

    private void indentByPreprocessor(Token<CppTokenId> previous, TokenSequence<CppTokenId> prep, Token<CppTokenId> next) {
        if (this.codeStyle.sharpAtStartLine()) {
            this.indentBefore(previous, 0, false);
            this.indentAfter(prep, next, this.getPreprocessorIndent(this.prepocessorDepth));
        } else {
            this.indentBefore(previous, this.getPreprocessorIndent(this.prepocessorDepth), true);
            this.indentAfter(prep, next, 0);
        }
    }

    private int getPreprocessorIndent(int shift) {
        if (shift > 0) {
            if (this.codeStyle.getFormatNewlineBeforeBrace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                return shift * (this.codeStyle.indentSize() / 2);
            }
            return shift * this.codeStyle.indentSize();
        }
        return 0;
    }

    private static class PreprocessorStateStack {
        private BracesStack inputStack;
        private List<BracesStack> outputStack = new ArrayList<BracesStack>();

        private PreprocessorStateStack(BracesStack inputStack) {
            this.inputStack = inputStack;
        }

        private BracesStack getBestOutputStack() {
            if (this.outputStack.size() > 0) {
                BracesStack min = null;
                int minLen = Integer.MAX_VALUE;
                BracesStack max = null;
                int maxLen = Integer.MIN_VALUE;
                int inLen = this.inputStack.getLength();
                for (BracesStack out : this.outputStack) {
                    int currentLen = out.getLength();
                    if (currentLen < inLen) {
                        if (currentLen > minLen) continue;
                        min = out;
                        minLen = currentLen;
                        continue;
                    }
                    if (currentLen <= inLen || currentLen < maxLen) continue;
                    max = out;
                    maxLen = currentLen;
                }
                if (min != null && max == null) {
                    return min;
                }
                if (max != null) {
                    return max;
                }
                return this.outputStack.get(this.outputStack.size() - 1);
            }
            return this.inputStack;
        }
    }
}

