/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Value;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ReturnValueNode
extends BaseNode {
    private static final String RETURN = "org/netbeans/modules/db/resources/paramReturn.gif";
    private static final String FOLDER = "ProcedureParam";
    private static final String DBDATATYPE = "DBDatatype";
    private static final String DBDATATYPEDESC = "DBDatatypeDescription";
    private String name = "";
    private final MetadataElementHandle<Value> valueHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static ReturnValueNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        ReturnValueNode node = new ReturnValueNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private ReturnValueNode(NodeDataLookup lookup, NodeProvider provider) {
        super(lookup, FOLDER, provider);
    }

    @Override
    public synchronized void refresh() {
        this.setupNames();
        super.refresh();
    }

    private void setupNames() {
        boolean connected = this.connection.isConnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Value parameter = (Value)ReturnValueNode.this.valueHandle.resolve(metaData);
                        if (parameter != null) {
                            ReturnValueNode.this.name = parameter.getName();
                            ReturnValueNode.this.updateProperties(parameter);
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, e, true);
            }
        }
    }

    private void updateProperties(Value param) {
        PropertySupport.Name ps = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)ps);
        this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ReturnValueNode.class, (String)"Return"));
        this.addProperty("Datatype", "DatatypeDescription", String.class, false, param.getType().toString());
        this.addProperty(DBDATATYPE, DBDATATYPEDESC, String.class, false, param.getTypeName() == null ? "" : param.getTypeName());
    }

    @Override
    protected void initialize() {
        this.setupNames();
    }

    @Override
    public String getIconBase() {
        return RETURN;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ReturnValueNode.class, (String)"ND_ProcedureParam");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ReturnValueNode.class);
    }
}

