/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer;

import java.sql.Connection;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnectionAccessor;

public final class DatabaseConnection {
    private org.netbeans.modules.db.explorer.DatabaseConnection delegate;

    DatabaseConnection(org.netbeans.modules.db.explorer.DatabaseConnection delegate) {
        assert (delegate != null);
        this.delegate = delegate;
    }

    org.netbeans.modules.db.explorer.DatabaseConnection getDelegate() {
        return this.delegate;
    }

    public static DatabaseConnection create(JDBCDriver driver, String databaseURL, String user, String schema, String password, boolean rememberPassword) {
        return DatabaseConnection.create(driver, databaseURL, user, schema, password, rememberPassword, null);
    }

    public static DatabaseConnection create(JDBCDriver driver, String databaseURL, String user, String schema, String password, boolean rememberPassword, String displayName) {
        return DatabaseConnection.create(driver, databaseURL, user, schema, password, rememberPassword, displayName, null);
    }

    public static DatabaseConnection create(JDBCDriver driver, String databaseURL, String user, String schema, String password, boolean rememberPassword, String displayName, Properties connectionProperties) {
        if (driver == null || databaseURL == null) {
            throw new NullPointerException();
        }
        org.netbeans.modules.db.explorer.DatabaseConnection conn = new org.netbeans.modules.db.explorer.DatabaseConnection();
        conn.setDriverName(driver.getName());
        conn.setDriver(driver.getClassName());
        conn.setDatabase(databaseURL);
        conn.setUser(user);
        conn.setSchema(schema);
        conn.setPassword(password);
        conn.setRememberPassword(rememberPassword);
        conn.setDisplayName(displayName);
        conn.setConnectionProperties(connectionProperties);
        return conn.getDatabaseConnection();
    }

    public String getDriverClass() {
        return this.delegate.getDriver();
    }

    public JDBCDriver getJDBCDriver() {
        return this.delegate.findJDBCDriver();
    }

    public String getDatabaseURL() {
        return this.delegate.getDatabase();
    }

    public String getSchema() {
        return this.delegate.getSchema();
    }

    public String getUser() {
        return this.delegate.getUser();
    }

    public String getPassword() {
        return this.delegate.getPassword();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public Properties getConnectionProperties() {
        return this.delegate.getConnectionProperties();
    }

    public boolean isUseScrollableCursors() {
        return this.delegate.isUseScrollableCursors();
    }

    public void setUseScrollableCursors(boolean useScrollableCursors) {
        this.delegate.setUseScrollableCursors(useScrollableCursors);
    }

    public Connection getJDBCConnection() {
        if (!ConnectionList.getDefault().contains(this.delegate)) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        return this.delegate.getJDBCConnection();
    }

    public Connection getJDBCConnection(boolean test) {
        if (test && SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method can not be called on the event dispatch thread with 'test' set to true.");
        }
        if (!ConnectionList.getDefault().contains(this.delegate)) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        return this.delegate.getJDBCConnection(test);
    }

    public String toString() {
        return "DatabaseConnection[name='" + this.getName() + "']";
    }

    static {
        DatabaseConnectionAccessor.DEFAULT = new DatabaseConnectionAccessor(){

            @Override
            public DatabaseConnection createDatabaseConnection(org.netbeans.modules.db.explorer.DatabaseConnection conn) {
                return new DatabaseConnection(conn);
            }
        };
    }
}

