/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class CompareCommand
extends GitCommand {
    private final LinkedHashMap<File, GitRevisionInfo.GitFileInfo> statuses;
    private final File[] roots;
    private final String revisionFirst;
    private final String revisionSecond;

    public CompareCommand(Repository repository, String revisionFirst, String revisionSecond, File[] roots, GitClassFactory gitFactory, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.revisionFirst = revisionFirst;
        this.revisionSecond = revisionSecond;
        this.statuses = new LinkedHashMap();
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git diff --raw");
        sb.append(this.revisionFirst).append(' ').append(this.revisionSecond);
        for (File root : this.roots) {
            sb.append(" ").append(root.getAbsolutePath());
        }
        return sb.toString();
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        return this.getRepository().getDirectory().exists();
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        TreeWalk walk = new TreeWalk(repository);
        try {
            walk.reset();
            walk.setRecursive(true);
            walk.addTree((AnyObjectId)Utils.findCommit(repository, this.revisionFirst).getTree());
            walk.addTree((AnyObjectId)Utils.findCommit(repository, this.revisionSecond).getTree());
            Collection<PathFilter> pathFilters = Utils.getPathFilters(repository.getWorkTree(), this.roots);
            if (pathFilters.isEmpty()) {
                walk.setFilter(AndTreeFilter.create((TreeFilter)TreeFilter.ANY_DIFF, (TreeFilter)PathFilter.ANY_DIFF));
            } else {
                walk.setFilter(AndTreeFilter.create((TreeFilter[])new TreeFilter[]{TreeFilter.ANY_DIFF, PathFilter.ANY_DIFF, PathFilterGroup.create(pathFilters)}));
            }
            List<GitRevisionInfo.GitFileInfo> infos = Utils.getDiffEntries(repository, walk, this.getClassFactory());
            for (GitRevisionInfo.GitFileInfo info : infos) {
                this.statuses.put(info.getFile(), info);
            }
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        finally {
            walk.release();
        }
    }

    public Map<File, GitRevisionInfo.GitFileInfo> getFileDifferences() {
        return this.statuses;
    }
}

