/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.support;

import java.util.concurrent.atomic.AtomicLong;
import org.clang.basic.FileEntry;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.basic.SrcMgr;
import org.clang.lex.MacroDefinition;
import org.clang.lex.PPCallbacks;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clang.lex.java.PTHManagerDriver;
import org.clang.lex.llvm.SmallVectorToken;
import org.clang.tools.services.support.FileInfoCallback;
import org.clang.tools.services.support.SkippedRangeBuilder;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Casts;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.support.llvm;

public final class FileInfo {
    private static final SmallVector<?> EMPTY = new SmallVector(0);
    private final char.ptr file;
    private final int includeIndex;
    SmallVectorToken tokens = null;
    boolean sawErrorDirective = false;
    private final SkippedRangeBuilder skipRangeBuilder;
    private int[] skippedRanges;
    private final int fileID;
    private final SrcMgr.CharacteristicKind FileType;
    private final Preprocessor PP;
    private final SourceManager srcMgr;
    private final int includeLocStartOffset;
    private final int includeLocEndOffset;
    final int StartOfFile;
    private final boolean mainFile;
    private final int initialTokensNr;
    private final long FileSize;
    private SmallVector<FileInfoCallback.PreprocessorDirectiveInfo> pp_directives;
    private SmallVector<FileInfoCallback.MacroExpansionInfo> macroExpansions;
    private SmallVector<FileInfoCallback.MacroUsageInfo> macroUsages;
    private final FileInfoCallback.InclusionDirectiveInfo inclusionDirective;
    private SmallVector<FileInfoCallback.FileGuardInfo> fileGuards;
    static long MaxNrOfTokensInPoolOnEndOfMainFile = 0L;
    static int MaxPoolOfVectorTokensSize = 0;
    private static final AtomicLong NrNewVectorTokens = new AtomicLong(0L);
    private static final AtomicLong NrNewTokensCreated = new AtomicLong(0L);
    private static final AtomicLong NrReusedVectorTokens = new AtomicLong(0L);
    private static final AtomicLong NrReusedVectorTokensWithoutGrow = new AtomicLong(0L);
    private static final AtomicLong TotalLexedSize = new AtomicLong(0L);
    private static long AllFilesSizeOnce = 0L;
    private static long AllHeadersFilesSizeOnce = 0L;
    private static long AllSourceFilesSizeOnce = 0L;
    private static final AtomicLong AllTokensNr = new AtomicLong(0L);
    private static final AtomicLong FilesLessThan10KTokens = new AtomicLong(0L);
    private static final AtomicLong HugeTokenInFile = new AtomicLong(0L);
    private static final AtomicLong NrExits = new AtomicLong(0L);
    private static final AtomicLong NrHits = new AtomicLong(0L);
    private static final AtomicLong NrMisses = new AtomicLong(0L);
    private static final StringMap<MyFileData> FilesCache = new StringMap(65536, null);
    private static int NrFilesWithInitialAllIncludedOnFirstLex = 0;
    private static int NrFilesWithInitialAllIncludedOnFirstLexButLexedAgain = 0;
    private static long TotalSizeWhichCanBeSkipedForInitialAllIncluded = 0L;
    private static int NrFilesWithInitial_NOT_AllIncludedOnFirstLexButLexedAgain = 0;
    private static long TotalSizeWhichCanBeSkipedForInitial_NOT_AllIncluded = 0L;
    static final AtomicLong NrSkippedByGuardsFiles = new AtomicLong(0L);
    static final AtomicLong NrNotFoundFiles = new AtomicLong(0L);
    private static final boolean TRACE_MAIN_FILE_INFO_ONLY = NativeTrace.TRACE_FILE_INFO_EXIT < 0;
    private static final int TRACE_FILE_INFO_EXIT_ABS = NativeTrace.TRACE_FILE_INFO_EXIT >= 0 ? NativeTrace.TRACE_FILE_INFO_EXIT : -NativeTrace.TRACE_FILE_INFO_EXIT;

    FileInfo(Preprocessor PP, FileEntry enteredFile, int FID, int StartOfFile, SrcMgr.CharacteristicKind FileType, boolean startOfMainFile, int index, FileInfoCallback.InclusionDirectiveInfo InclusionDirectiveInfo2) {
        assert (PP != null) : "No Preprocessor for " + FID + " " + enteredFile;
        this.PP = PP;
        this.srcMgr = PP.getSourceManager();
        if (enteredFile == null) {
            this.file = NativePointer.$EMPTY;
            this.FileSize = 0L;
        } else {
            this.file = enteredFile.getName();
            this.FileSize = enteredFile.getSize();
        }
        this.StartOfFile = StartOfFile;
        assert (this.StartOfFile == this.srcMgr.getLocForStartOfFile(FID));
        int tokNr = (int)(this.FileSize / (long)FileInfoCallback.FILE_SIZE_TO_TOKENS_RATIO);
        if (tokNr > FileInfoCallback.MAX_INITIAL_TOKENS_CAPACITY) {
            tokNr = FileInfoCallback.MAX_INITIAL_TOKENS_CAPACITY;
        } else if (tokNr < FileInfoCallback.MIN_INITIAL_TOKENS_CAPACITY) {
            tokNr = FileInfoCallback.MIN_INITIAL_TOKENS_CAPACITY;
        }
        this.initialTokensNr = tokNr;
        this.includeIndex = index;
        this.skipRangeBuilder = new SkippedRangeBuilder(this.file);
        this.fileID = FID;
        this.FileType = FileType;
        if (InclusionDirectiveInfo2 == null) {
            long decomposedLoc = this.srcMgr.getDecomposedIncludedLoc(this.fileID);
            this.includeLocEndOffset = this.includeLocStartOffset = std_pair.$second_uint((long)decomposedLoc);
        } else {
            this.includeLocStartOffset = InclusionDirectiveInfo2.getHashOffset();
            this.includeLocEndOffset = InclusionDirectiveInfo2.getEodOffset();
        }
        this.mainFile = startOfMainFile;
        this.inclusionDirective = InclusionDirectiveInfo2;
        this.pp_directives = EMPTY;
        this.macroExpansions = EMPTY;
        this.macroUsages = EMPTY;
        this.fileGuards = EMPTY;
    }

    void enterInnerInclude() {
    }

    void enter() {
    }

    long getFileSize() {
        return this.FileSize;
    }

    void releaseTokensIfPossible(SmallVector<SmallVectorToken> poolOfTokens) {
        if (this.tokens != null) {
            if (NativeTrace.isDebugMode()) {
                for (int i = 0; i < poolOfTokens.size(); ++i) {
                    SmallVectorToken toks = (SmallVectorToken)poolOfTokens.$at(i);
                    assert (toks != this.tokens) : "tokens already in pool at " + i;
                }
            }
            this.tokens.clear();
            poolOfTokens.push_back((Object)this.tokens);
            this.tokens = null;
        }
    }

    void prepareTokens(SmallVector<SmallVectorToken> poolOfTokens) {
        if (poolOfTokens.empty()) {
            if (NativeTrace.VERBOSE_MODE || NativeTrace.SERVICE_STATISTICS) {
                NrNewVectorTokens.incrementAndGet();
                NrNewTokensCreated.addAndGet(this.initialTokensNr);
            }
            this.tokens = new SmallVectorToken(this.initialTokensNr, null);
        } else {
            this.tokens = (SmallVectorToken)poolOfTokens.pop_back_val();
            if (NativeTrace.VERBOSE_MODE || NativeTrace.SERVICE_STATISTICS) {
                NrReusedVectorTokens.incrementAndGet();
                if (this.tokens.capacity() >= this.initialTokensNr) {
                    NrReusedVectorTokensWithoutGrow.incrementAndGet();
                }
            }
            this.tokens.reserve(this.initialTokensNr);
        }
        assert (this.tokens != null);
        assert (this.tokens.size() == 0) : "" + this.tokens.size();
    }

    void exit() {
        this.skippedRanges = this.skipRangeBuilder.build();
        this.collectStatsOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectStatsOnExit() {
        if (TRACE_FILE_INFO_EXIT_ABS > 0 && this.file != null && this.file != NativePointer.$EMPTY && (!TRACE_MAIN_FILE_INFO_ONLY || this.isMainFile())) {
            if (this.isMainFile()) {
                llvm.errs().$out("EXIT TU ");
            }
            llvm.errs().$out("FileID=").$out_int(this.fileID).$out(";includeIndex=").$out_int(this.includeIndex).$out(";").$out(this.file);
            if (TRACE_FILE_INFO_EXIT_ABS > 1) {
                llvm.errs().$out("\nTokens: ").$out_int(this.getNrTokens());
            }
            if (TRACE_FILE_INFO_EXIT_ABS > 2) {
                llvm.errs().$out("\nSkip=").$out(this.skipRangeBuilder.toString(false));
            }
            llvm.errs().$out("\n").flush();
        }
        if (NativeTrace.VERBOSE_MODE || NativeTrace.SERVICE_STATISTICS) {
            int nrTokens = this.getNrTokens();
            if (this.file != null && this.file != NativePointer.$EMPTY) {
                StringMapEntry Entry2;
                StringMapEntry stringMapEntry = FilesCache;
                synchronized (stringMapEntry) {
                    Entry2 = FilesCache.GetOrCreateValue(this.file, std.strlen((char.ptr)this.file));
                }
                stringMapEntry = Entry2;
                synchronized (stringMapEntry) {
                    if (Entry2.second == null) {
                        AllFilesSizeOnce += this.FileSize;
                        if (this.mainFile) {
                            AllSourceFilesSizeOnce += this.FileSize;
                        } else {
                            AllHeadersFilesSizeOnce += this.FileSize;
                        }
                        boolean allIncluded = this.skippedRanges.length == 0;
                        Entry2.second = new MyFileData(this.FileSize, allIncluded, nrTokens);
                        if (allIncluded) {
                            ++NrFilesWithInitialAllIncludedOnFirstLex;
                        }
                    } else if (((MyFileData)Entry2.second).State == 1) {
                        ++NrFilesWithInitialAllIncludedOnFirstLexButLexedAgain;
                        TotalSizeWhichCanBeSkipedForInitialAllIncluded += this.FileSize;
                    } else {
                        ++NrFilesWithInitial_NOT_AllIncludedOnFirstLexButLexedAgain;
                        TotalSizeWhichCanBeSkipedForInitial_NOT_AllIncluded += this.FileSize;
                    }
                    ((MyFileData)Entry2.second).NrInclusions++;
                }
            }
            TotalLexedSize.addAndGet(this.FileSize);
            AllTokensNr.addAndGet(nrTokens);
            NrExits.incrementAndGet();
            if (this.initialTokensNr >= nrTokens) {
                NrHits.incrementAndGet();
            } else {
                if (FileInfoCallback.TRACE) {
                    llvm.errs().$out("Inited as ").$out_int(this.initialTokensNr).$out(" got ").$out_int(nrTokens).$out("\n").flush();
                }
                NrMisses.incrementAndGet();
            }
            if (nrTokens < 10000) {
                FilesLessThan10KTokens.incrementAndGet();
            }
            if (HugeTokenInFile.get() < (long)nrTokens) {
                HugeTokenInFile.set(nrTokens);
                if (FileInfoCallback.TRACE) {
                    FileInfo.printTokenStats();
                }
            }
        }
    }

    public static void clearTokenStats() {
        MaxNrOfTokensInPoolOnEndOfMainFile = 0L;
        MaxPoolOfVectorTokensSize = 0;
        NrNewVectorTokens.set(0L);
        NrNewTokensCreated.set(0L);
        NrReusedVectorTokens.set(0L);
        NrReusedVectorTokensWithoutGrow.set(0L);
        TotalLexedSize.set(0L);
        AllFilesSizeOnce = 0L;
        AllHeadersFilesSizeOnce = 0L;
        AllSourceFilesSizeOnce = 0L;
        AllTokensNr.set(0L);
        FilesLessThan10KTokens.set(0L);
        HugeTokenInFile.set(0L);
        NrExits.set(0L);
        NrHits.set(0L);
        NrMisses.set(0L);
        FilesCache.clear();
        NrFilesWithInitialAllIncludedOnFirstLex = 0;
        NrFilesWithInitialAllIncludedOnFirstLexButLexedAgain = 0;
        TotalSizeWhichCanBeSkipedForInitialAllIncluded = 0L;
        NrFilesWithInitial_NOT_AllIncludedOnFirstLexButLexedAgain = 0;
        TotalSizeWhichCanBeSkipedForInitial_NOT_AllIncluded = 0L;
        NrSkippedByGuardsFiles.set(0L);
        NrNotFoundFiles.set(0L);
        PTHManagerDriver.clearStatistics();
    }

    public static void printTokenStats() {
        if (AllFilesSizeOnce == 0L) {
            return;
        }
        long TokensDensity = AllTokensNr.longValue() == 0L ? 0L : TotalLexedSize.longValue() / AllTokensNr.longValue();
        llvm.errs().$out("Less Than 10K Tokens In ").$out(NativeTrace.formatNumber((long)FilesLessThan10KTokens.longValue())).$out("; Max Tokens: ").$out(NativeTrace.formatNumber((long)HugeTokenInFile.longValue())).$out("; Initial Capacity Hits: ").$out(NativeTrace.formatNumber((long)NrHits.longValue())).$out("; Initial Capacity Misses: ").$out(NativeTrace.formatNumber((long)NrMisses.longValue())).$out("\nAll Tokens: ").$out(NativeTrace.formatNumber((long)AllTokensNr.longValue())).$out("\nNum Lexed Files: ").$out(NativeTrace.formatNumber((long)NrExits.longValue())).$out("\nNum Unique Files: ").$out(NativeTrace.formatNumber((long)FilesCache.size())).$out(" (").$out_long(NrExits.longValue() / (long)FilesCache.size()).$out(" times less)").$out("\nTotal Lexed Files Size: ").$out(NativeTrace.formatNumber((long)TotalLexedSize.longValue())).$out("\nTotal Size of Unique Files: ").$out(NativeTrace.formatNumber((long)AllFilesSizeOnce)).$out(" (").$out_long(TotalLexedSize.longValue() / AllFilesSizeOnce).$out(" times less)").$out("\n        Size of Main Files: ").$out(NativeTrace.formatNumber((long)AllSourceFilesSizeOnce)).$out("\n      Size of Header Files: ").$out(NativeTrace.formatNumber((long)AllHeadersFilesSizeOnce)).$out("\nAllToks/NumFiles: ").$out_int((int)(AllTokensNr.longValue() / NrExits.longValue())).$out("; FileSize/AllToks: ").$out_int((int)TokensDensity).$out("\nFirst skipRanges was empty in ").$out(NativeTrace.formatNumber((long)NrFilesWithInitialAllIncludedOnFirstLex)).$out(" unique files").$out("\nTotal Nr of extra Lexed \"Lex-once Files\": ").$out(NativeTrace.formatNumber((long)NrFilesWithInitialAllIncludedOnFirstLexButLexedAgain)).$out("\nTotal Size of extra Lexed \"Lex-once Files\": ").$out(NativeTrace.formatNumber((long)TotalSizeWhichCanBeSkipedForInitialAllIncluded)).$out("\nTotal Nr of extra Lexed NOT \"Lex-once Files\": ").$out(NativeTrace.formatNumber((long)NrFilesWithInitial_NOT_AllIncludedOnFirstLexButLexedAgain)).$out("\nTotal Size of extra Lexed NOT \"Lex-once Files\": ").$out(NativeTrace.formatNumber((long)TotalSizeWhichCanBeSkipedForInitial_NOT_AllIncluded)).$out("\nNum Files skipped by guards: ").$out(NativeTrace.formatNumber((long)NrSkippedByGuardsFiles.longValue())).$out("\nNum Unresolved files: ").$out(NativeTrace.formatNumber((long)NrNotFoundFiles.longValue())).$out("\n\t").$out("New Vector Tokens created ").$out(NativeTrace.formatNumber((long)NrNewVectorTokens.longValue())).$out("(with total initial amount ").$out(NativeTrace.formatNumber((long)NrNewTokensCreated.longValue())).$out(" elements)").$out("\n\tVector Tokens reused ").$out(NativeTrace.formatNumber((long)NrReusedVectorTokens.longValue())).$out("(without grow ").$out(NativeTrace.formatNumber((long)NrReusedVectorTokensWithoutGrow.longValue())).$out(" times)").$out("\n\tMax pool size ").$out(NativeTrace.formatNumber((long)MaxPoolOfVectorTokensSize)).$out(" with Max Total Capacity ").$out(NativeTrace.formatNumber((long)MaxNrOfTokensInPoolOnEndOfMainFile)).$out(" tokens").$out("\n").flush();
        PTHManagerDriver.printStats();
    }

    public boolean isMainFile() {
        return this.mainFile;
    }

    public FileInfoCallback.InclusionDirectiveInfo getInclusionDirective() {
        return this.inclusionDirective;
    }

    public int[] getSkippedRanges() {
        return this.skippedRanges;
    }

    public SmallVector<FileInfoCallback.PreprocessorDirectiveInfo> getPreprocessorDirectives() {
        return this.pp_directives;
    }

    public SmallVector<FileInfoCallback.MacroExpansionInfo> getMacroExpansions() {
        return this.macroExpansions;
    }

    public SmallVector<FileInfoCallback.MacroUsageInfo> getMacroUsages() {
        return this.macroUsages;
    }

    public SmallVector<FileInfoCallback.FileGuardInfo> getFileGuardsInfo() {
        return this.fileGuards;
    }

    public SourceManager getSourceManager() {
        return this.srcMgr;
    }

    public Preprocessor getPreprocessor() {
        return this.PP;
    }

    public SrcMgr.CharacteristicKind getFileType() {
        return this.FileType;
    }

    public boolean isFile() {
        return this.file != NativePointer.$EMPTY;
    }

    public char.ptr getName() {
        return this.file;
    }

    public int getFileID() {
        return this.fileID;
    }

    public int getIncludeIndex() {
        return this.includeIndex;
    }

    public boolean hasTokens() {
        return this.tokens != null;
    }

    public int getNrTokens() {
        return this.tokens == null ? 0 : this.tokens.size();
    }

    public SmallVectorToken getTokens() {
        return this.tokens;
    }

    public int getIncludeStartOffset() {
        return this.includeLocStartOffset;
    }

    public int getIncludeEndOffset() {
        return this.includeLocEndOffset;
    }

    public String toString() {
        return "file=" + this.fileID + ":" + Casts.toJavaString((char.ptr)this.file);
    }

    void onPPDirective(FileInfoCallback.PreprocessorDirectiveInfo pp) {
        this.preparedPPDirectives();
        this.pp_directives.push_back((Object)pp);
    }

    FileInfoCallback.MacroExpansionInfo onMacroExpands(int begin, int end, int macroNamelength, SourceRange Range, MacroDefinition MD, IdentifierInfo II) {
        this.prepareMacroExpansions();
        FileInfoCallback.MacroExpansionInfo macroExpansionInfo = new FileInfoCallback.MacroExpansionInfo(begin, end, macroNamelength, Range, MD, II);
        this.macroExpansions.push_back((Object)macroExpansionInfo);
        return macroExpansionInfo;
    }

    void onSourceRangeSkipped(int begin, int end) {
    }

    void onIf(int begin, int end, int ifOffset, PPCallbacks.ConditionValueKind ConditionValue) {
        this.skipRangeBuilder.startIf(begin, end, ifOffset, ConditionValue);
    }

    void onMacroUsage(Token MacroNameTok, MacroDefinition MD) {
        if (MD.$bool()) {
            this.prepareMacroUsages();
            IdentifierInfo UsedMacroName = MacroNameTok.getIdentifierInfo();
            assert (UsedMacroName != null) : "no name for " + MacroNameTok;
            this.macroUsages.push_back((Object)new FileInfoCallback.MacroUsageInfo(MacroNameTok.$getLocation(), MacroNameTok.getLength(), MD, UsedMacroName));
        }
    }

    void onElif(int begin, int end, int ifOffset, PPCallbacks.ConditionValueKind ConditionValue) {
        this.skipRangeBuilder.handleElif(begin, end, ifOffset, ConditionValue);
    }

    void onElse(int begin, int end, int ifOffset) {
        this.skipRangeBuilder.handleElse(begin, end, ifOffset);
    }

    void onEndif(int begin, int end, int ifOffset) {
        this.skipRangeBuilder.handleEndif(begin, end, ifOffset);
    }

    void onUserErrorDiagnostic(int begin, int end) {
        this.skipRangeBuilder.handleErrorDiagnostic(begin, end);
        this.sawErrorDirective = true;
    }

    void onGuardPositionDetected(IdentifierInfo IfDefMacro, int IfDefMacroLocation, IdentifierInfo DefMacro, int DefinedMacroLocation) {
        this.prepareFileGuards();
        this.fileGuards.push_back((Object)new FileInfoCallback.FileGuardInfo(IfDefMacro, IfDefMacroLocation, DefMacro, DefinedMacroLocation));
    }

    void onPragmaOnceDetected(Token once) {
        this.prepareFileGuards();
        this.fileGuards.push_back((Object)new FileInfoCallback.FileGuardInfo(once.getIdentifierInfo(), once.$getLocation(), null, -1));
    }

    private void prepareFileGuards() {
        if (this.fileGuards == EMPTY) {
            this.fileGuards = new SmallVector(1, null);
        }
    }

    private void prepareMacroUsages() {
        if (this.macroUsages == EMPTY) {
            this.macroUsages = new SmallVector(4, null);
        }
    }

    private void prepareMacroExpansions() {
        if (this.macroExpansions == EMPTY) {
            this.macroExpansions = new SmallVector(4, null);
        }
    }

    private void preparedPPDirectives() {
        if (this.pp_directives == EMPTY) {
            this.pp_directives = new SmallVector(4, null);
        }
    }

    private static final class MyFileData {
        private final long Size;
        private final int State;
        private final int NrTokens;
        private int NrInclusions;

        private MyFileData(long FileSize, boolean emptySkip, int nrTokens) {
            this.Size = FileSize;
            this.NrTokens = nrTokens;
            this.State = emptySkip ? 1 : 2;
        }
    }

    static final class InitialSkippedState {
        private static final int ALL_INCLUDED = 1;
        private static final int NOT_ALL_INCLUDED = 2;

        InitialSkippedState() {
        }
    }
}

