/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.wizard.DefaultSuiteProjectDeletePanel;
import org.netbeans.spi.project.DataFilesProviderImplementation;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class DefaultSuiteProjectOperationsImplementation {
    private static final Logger LOG = Logger.getLogger(DefaultSuiteProjectOperationsImplementation.class.getName());
    static final int MAX_WORK = 100;

    private DefaultSuiteProjectOperationsImplementation() {
    }

    private static String getDisplayName(Project project) {
        return ProjectUtils.getInformation((Project)project).getDisplayName();
    }

    private static void performDelete(Project project, List<FileObject> toDelete, Map<NbModuleProject, List<FileObject>> subModulesFilesToDelete, ProgressHandle handle) throws Exception {
        try {
            int toDeleteSubModulesSize = 0;
            if (subModulesFilesToDelete != null) {
                for (Map.Entry<NbModuleProject, List<FileObject>> entry : subModulesFilesToDelete.entrySet()) {
                    toDeleteSubModulesSize += entry.getValue().size() + 1;
                }
            }
            handle.start(toDelete.size() + toDeleteSubModulesSize + 1);
            int done = 0;
            done = DefaultSuiteProjectOperationsImplementation.performDeleteOnProject(project, toDelete, handle, done);
            if (subModulesFilesToDelete != null) {
                for (Map.Entry<NbModuleProject, List<FileObject>> entry : subModulesFilesToDelete.entrySet()) {
                    done = DefaultSuiteProjectOperationsImplementation.performDeleteOnProject(entry.getKey(), entry.getValue(), handle, done);
                }
            }
            handle.finish();
        }
        catch (Exception e) {
            String displayName = DefaultSuiteProjectOperationsImplementation.getDisplayName(project);
            String string = NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)"LBL_Project_cannot_be_deleted", (Object)displayName);
            Exceptions.attachLocalizedMessage((Throwable)e, (String)string);
            throw e;
        }
    }

    private static int performDeleteOnProject(Project project, List<FileObject> toDelete, ProgressHandle handle, int done) throws IOException {
        handle.progress(NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)"LBL_Progress_Cleaning_Project"));
        ProjectOperations.notifyDeleting((Project)project);
        handle.progress(++done);
        for (FileObject f : toDelete) {
            handle.progress(NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)"LBL_Progress_Deleting_File", (Object)FileUtil.getFileDisplayName((FileObject)f)));
            if (f != null && f.isValid()) {
                f.delete();
            }
            handle.progress(++done);
        }
        FileObject projectFolder = project.getProjectDirectory();
        projectFolder.refresh();
        if (!projectFolder.isValid()) {
            LOG.log(Level.WARNING, "invalid project folder: {0}", projectFolder);
        } else if (projectFolder.getChildren().length == 0) {
            projectFolder.delete();
        } else {
            LOG.log(Level.WARNING, "project folder {0} was not empty: {1}", new Object[]{projectFolder, Arrays.asList(projectFolder.getChildren())});
        }
        ProjectOperations.notifyDeleted((Project)project);
        return done;
    }

    public static void deleteProject(SuiteProject project) {
        DefaultSuiteProjectOperationsImplementation.deleteProject(project, new GUIUserInputHandler());
    }

    static void deleteProject(final SuiteProject project, UserInputHandler handler) {
        String displayName = DefaultSuiteProjectOperationsImplementation.getDisplayName(project);
        FileObject projectFolder = project.getProjectDirectory();
        LOG.log(Level.FINE, "delete started: {0}", displayName);
        final List metadataFiles = ProjectOperations.getMetadataFiles((Project)project);
        List dataFiles = ProjectOperations.getDataFiles((Project)project);
        final ArrayList allFiles = new ArrayList();
        allFiles.addAll(metadataFiles);
        allFiles.addAll(dataFiles);
        Iterator i = allFiles.iterator();
        while (i.hasNext()) {
            FileObject f = (FileObject)i.next();
            if (FileUtil.isParentOf((FileObject)projectFolder, (FileObject)f) || projectFolder.equals(f)) continue;
            i.remove();
        }
        SubprojectProvider suiteProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        Set subProjects = suiteProvider.getSubprojects();
        final HashSet<NbModuleProject> subModules = new HashSet<NbModuleProject>();
        for (Project prjIter : subProjects) {
            NbModuleProject nbModulePrj = (NbModuleProject)prjIter.getLookup().lookup(NbModuleProject.class);
            if (nbModulePrj == null) continue;
            subModules.add(nbModulePrj);
        }
        final Map<NbModuleProject, List<FileObject>> subModulesDataFiles = DefaultSuiteProjectOperationsImplementation.getSubModulesDataFiles(subModules);
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)"LBL_Delete_Project_Caption"));
        final DefaultSuiteProjectDeletePanel deletePanel = new DefaultSuiteProjectDeletePanel(handle, displayName, FileUtil.getFileDisplayName((FileObject)projectFolder), !subModulesDataFiles.isEmpty(), !subModules.isEmpty());
        String caption = NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)"LBL_Delete_Project_Caption");
        handler.showConfirmationDialog(deletePanel, project, caption, "Yes_Button", "No_Button", true, new Executor(){

            @Override
            public void execute() throws Exception {
                deletePanel.addProgressBar();
                DefaultSuiteProjectOperationsImplementation.close(project);
                HashMap subModulesAllFiles = null;
                Map subModulesMetadataFiles = null;
                if (deletePanel.isDeleteModules()) {
                    for (NbModuleProject modulePrjIter : subModules) {
                        DefaultSuiteProjectOperationsImplementation.close(modulePrjIter);
                    }
                    subModulesAllFiles = new HashMap();
                    subModulesAllFiles.putAll(subModulesDataFiles);
                    subModulesMetadataFiles = DefaultSuiteProjectOperationsImplementation.getSubModulesMetadataFiles(subModules, subModulesAllFiles);
                }
                if (deletePanel.isDeleteSources()) {
                    DefaultSuiteProjectOperationsImplementation.performDelete(project, allFiles, subModulesAllFiles, handle);
                } else {
                    DefaultSuiteProjectOperationsImplementation.performDelete(project, metadataFiles, subModulesMetadataFiles, handle);
                }
                deletePanel.removeProgressBar();
            }
        });
        LOG.log(Level.FINE, "delete done: {0}", displayName);
    }

    private static Map<NbModuleProject, List<FileObject>> getSubModulesMetadataFiles(Set<NbModuleProject> subModules, Map<NbModuleProject, List<FileObject>> subModulesAllFiles) {
        HashMap<NbModuleProject, List<FileObject>> result = new HashMap<NbModuleProject, List<FileObject>>();
        for (NbModuleProject modulePrjIter : subModules) {
            Object i2;
            ArrayList files = new ArrayList();
            for (Object i2 : modulePrjIter.getLookup().lookupAll(DataFilesProviderImplementation.class)) {
                files.addAll(i2.getMetadataFiles());
                assert (!files.contains(null)) : "Nulls in " + result + " from " + i2;
            }
            FileObject subModuleProjectFolder = modulePrjIter.getProjectDirectory();
            i2 = files.iterator();
            while (i2.hasNext()) {
                FileObject f = (FileObject)i2.next();
                if (FileUtil.isParentOf((FileObject)subModuleProjectFolder, (FileObject)f) || subModuleProjectFolder.equals(f)) continue;
                i2.remove();
            }
            result.put(modulePrjIter, files);
            subModulesAllFiles.get(modulePrjIter).addAll(files);
        }
        return result;
    }

    private static Map<NbModuleProject, List<FileObject>> getSubModulesDataFiles(Set<NbModuleProject> subModules) {
        HashMap<NbModuleProject, List<FileObject>> result = new HashMap<NbModuleProject, List<FileObject>>();
        for (NbModuleProject modulePrjIter : subModules) {
            Object i2;
            ArrayList files = new ArrayList();
            for (Object i2 : modulePrjIter.getLookup().lookupAll(DataFilesProviderImplementation.class)) {
                files.addAll(i2.getDataFiles());
                assert (!files.contains(null)) : "Nulls in " + result + " from " + i2;
            }
            FileObject subModuleProjectFolder = modulePrjIter.getProjectDirectory();
            i2 = files.iterator();
            while (i2.hasNext()) {
                FileObject f = (FileObject)i2.next();
                if (FileUtil.isParentOf((FileObject)subModuleProjectFolder, (FileObject)f) || subModuleProjectFolder.equals(f)) continue;
                i2.remove();
            }
            result.put(modulePrjIter, files);
        }
        return result;
    }

    private static JComponent wrapPanel(JComponent component) {
        component.setBorder(new EmptyBorder(12, 12, 12, 12));
        return component;
    }

    private static void showConfirmationDialog(final JComponent panel, Project project, String caption, String confirmButton, String cancelButton, boolean doSetMessageType, final Executor executor) {
        final JButton confirm = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)confirm, (String)NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)("LBL_" + confirmButton)));
        final JButton cancel = new JButton(cancelButton == null ? NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)"LBL_Cancel_Button") : NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)("LBL_" + cancelButton)));
        confirm.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)("ACSD_" + confirmButton)));
        cancel.getAccessibleContext().setAccessibleDescription(cancelButton == null ? NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)"ACSD_Cancel_Button") : NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)("ACSD_" + cancelButton)));
        assert (panel instanceof InvalidablePanel);
        ((InvalidablePanel)((Object)panel)).addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                confirm.setEnabled(((InvalidablePanel)((Object)panel)).isPanelValid());
            }
        });
        confirm.setEnabled(((InvalidablePanel)((Object)panel)).isPanelValid());
        final Dialog[] dialog = new Dialog[1];
        DialogDescriptor dd = new DialogDescriptor((Object)(doSetMessageType ? panel : DefaultSuiteProjectOperationsImplementation.wrapPanel(panel)), caption, true, new Object[]{confirm, cancel}, (Object)(cancelButton != null ? cancel : confirm), 0, null, new ActionListener(){
            private boolean operationRunning;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.operationRunning) {
                    return;
                }
                if (dialog[0] instanceof JDialog) {
                    ((JDialog)dialog[0]).getRootPane().getInputMap(1).remove(KeyStroke.getKeyStroke(27, 0));
                    ((JDialog)dialog[0]).setDefaultCloseOperation(0);
                }
                this.operationRunning = true;
                if (e.getSource() == confirm) {
                    Container findParent;
                    confirm.setEnabled(false);
                    cancel.setEnabled(false);
                    ((InvalidablePanel)((Object)panel)).showProgress();
                    for (findParent = panel; findParent != null && !(findParent instanceof Window); findParent = findParent.getParent()) {
                    }
                    if (findParent != null) {
                        ((Window)findParent).pack();
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            AtomicReference<Throwable> e = new AtomicReference<Throwable>();
                            try {
                                executor.execute();
                            }
                            catch (Throwable ex) {
                                block4: {
                                    try {
                                        e.set(ex);
                                        if (!(ex instanceof ThreadDeath)) break block4;
                                        throw (ThreadDeath)ex;
                                    }
                                    catch (Throwable throwable) {
                                        SwingUtilities.invokeLater(new Runnable(e){
                                            final /* synthetic */ AtomicReference val$e;
                                            {
                                                this.val$e = atomicReference;
                                            }

                                            @Override
                                            public void run() {
                                                dialog[0].setVisible(false);
                                                if (this.val$e.get() != null) {
                                                    LOG.log(Level.WARNING, null, (Throwable)this.val$e.get());
                                                }
                                            }
                                        });
                                        throw throwable;
                                    }
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                } else {
                    dialog[0].setVisible(false);
                }
            }
        });
        if (doSetMessageType) {
            dd.setMessageType(3);
        }
        dd.setClosingOptions(new Object[0]);
        dialog[0] = DialogDisplayer.getDefault().createDialog(dd);
        dialog[0].setVisible(true);
        dialog[0].dispose();
        dialog[0] = null;
    }

    @CheckForNull
    static String computeError(@NullAllowed File location, String projectNameText, boolean pureRename) {
        return DefaultSuiteProjectOperationsImplementation.computeError(location, projectNameText, null, pureRename);
    }

    @CheckForNull
    static String computeError(@NullAllowed File location, String projectNameText, String projectFolderText, boolean pureRename) {
        if (projectNameText.length() == 0) {
            return NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)"ERR_Project_Name_Must_Entered");
        }
        if (projectNameText.indexOf(47) != -1 || projectNameText.indexOf(92) != -1) {
            return NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)"ERR_Not_Valid_Filename", (Object)projectNameText);
        }
        if (location == null) {
            return null;
        }
        File parent = location;
        if (!location.exists()) {
            for (parent = location.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
            }
            if (parent == null) {
                return NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)"ERR_Location_Does_Not_Exist");
            }
        }
        if (!parent.canWrite()) {
            return NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)"ERR_Location_Read_Only");
        }
        File projectFolderFile = null;
        projectFolderFile = projectFolderText == null ? new File(location, projectNameText) : new File(projectFolderText);
        if (projectFolderFile.exists() && !pureRename) {
            return NbBundle.getMessage(DefaultSuiteProjectOperationsImplementation.class, (String)"ERR_Project_Folder_Exists");
        }
        return null;
    }

    private static void close(Project prj) {
        LifecycleManager.getDefault().saveAll();
        OpenProjects.getDefault().close(new Project[]{prj});
    }

    public static interface InvalidablePanel {
        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public boolean isPanelValid();

        public void showProgress();
    }

    static interface Executor {
        public void execute() throws Exception;
    }

    private static final class GUIUserInputHandler
    implements UserInputHandler {
        private GUIUserInputHandler() {
        }

        @Override
        public void showConfirmationDialog(JComponent panel, Project project, String caption, String confirmButton, String cancelButton, boolean doSetMessageType, Executor executor) {
            DefaultSuiteProjectOperationsImplementation.showConfirmationDialog(panel, project, caption, confirmButton, cancelButton, doSetMessageType, executor);
        }
    }

    static interface UserInputHandler {
        public void showConfirmationDialog(JComponent var1, Project var2, String var3, String var4, String var5, boolean var6, Executor var7);
    }
}

