/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.clone;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.ui.clone.CloneDestinationPanel;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class RepositoryStepPanel
extends JPanel {
    private final FileSystem fileSystem;
    final JButton btnBrowseDestination = new JButton();
    private final JLabel jLabel1 = new JLabel();
    private final JLabel jLabel2 = new JLabel();
    private final JLabel jLabel3 = new JLabel();
    private final JPanel jPanel1 = new JPanel();
    private final JSeparator jSeparator1 = new JSeparator();
    final JLabel lblCloneName = new JLabel();
    private final JLabel lblDestination = new JLabel();
    final JPanel progressPanel = new JPanel();
    final JTextField txtDestination = new JTextField();

    public RepositoryStepPanel(FileSystem fs, JPanel repositoryPanel) {
        this.fileSystem = fs;
        this.initComponents();
        this.txtDestination.setText(this.defaultWorkingDirectory().getPath());
        this.jPanel1.add(repositoryPanel);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setPreferredSize(this.getPreferredSize());
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(480, 160));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/git/remote/ui/clone/Bundle");
        this.setName(bundle.getString("BK2018"));
        this.setVerifyInputWhenFocusTarget(false);
        this.progressPanel.setLayout(null);
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 3));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RepositoryStepPanel.class, (String)"LBL_RepositoryStepPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RepositoryStepPanel.class, (String)"RepositoryStepPanel.jLabel1.text"));
        this.lblDestination.setLabelFor(this.txtDestination);
        Mnemonics.setLocalizedText((JLabel)this.lblDestination, (String)NbBundle.getMessage(RepositoryStepPanel.class, (String)"RepositoryStepPanel.lblDestination.text"));
        this.lblDestination.setToolTipText(NbBundle.getMessage(RepositoryStepPanel.class, (String)"RepositoryStepPanel.lblDestination.TTtext"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnBrowseDestination, (String)NbBundle.getMessage(RepositoryStepPanel.class, (String)"RepositoryStepPanel.btnBrowse.text"));
        this.btnBrowseDestination.setToolTipText(NbBundle.getMessage(RepositoryStepPanel.class, (String)"RepositoryStepPanel.btnBrowse.TTtext"));
        this.btnBrowseDestination.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryStepPanel.this.btnBrowseDestinationActionPerformed(evt);
            }
        });
        this.jLabel3.setForeground(UIManager.getDefaults().getColor("Label.disabledForeground"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RepositoryStepPanel.class, (String)"RepositoryStepPanel.destinationHint.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressPanel, -1, 574, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, 574, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addComponent(this.lblDestination).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.txtDestination).addGap(0, 0, 0).addComponent(this.lblCloneName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowseDestination)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDestination).addComponent(this.txtDestination, -2, -1, -2).addComponent(this.btnBrowseDestination).addComponent(this.lblCloneName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(18, 18, Short.MAX_VALUE).addComponent(this.progressPanel, -2, 37, -2)));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryStepPanel.class, (String)"ACSD_RepositoryPanel"));
    }

    private void btnBrowseDestinationActionPerformed(ActionEvent evt) {
        FileFilter[] old;
        VCSFileProxy oldFile = this.defaultWorkingDirectory();
        JFileChooser fileChooser = VCSFileProxySupport.createFileChooser((VCSFileProxy)oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(CloneDestinationPanel.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        for (FileFilter fileFilter : old = fileChooser.getChoosableFileFilters()) {
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(CloneDestinationPanel.class, (String)"Folders");
            }
        });
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this, NbBundle.getMessage(CloneDestinationPanel.class, (String)"OK_Button"));
        VCSFileProxy f = VCSFileProxySupport.getSelectedFile((JFileChooser)fileChooser);
        if (f != null) {
            this.txtDestination.setText(f.getPath());
        }
    }

    private VCSFileProxy defaultWorkingDirectory() {
        String cloneDir;
        VCSFileProxy defaultDir = null;
        String current = this.txtDestination.getText();
        if (current != null && !current.trim().equals("")) {
            VCSFileProxy currentFile;
            for (currentFile = VCSFileProxySupport.getResource((FileSystem)this.fileSystem, (String)current); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
            }
            if (currentFile != null) {
                defaultDir = currentFile.isFile() ? currentFile.getParentFile() : currentFile;
            }
        }
        if (defaultDir == null && (cloneDir = GitModuleConfig.getDefault().getPreferences().get("cloneDestinationStep.cloneDirectory", null)) != null) {
            defaultDir = VCSFileProxySupport.getResource((FileSystem)this.fileSystem, (String)cloneDir);
        }
        if (defaultDir == null) {
            defaultDir = VCSFileProxySupport.getHome((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)this.fileSystem.getRoot()));
        }
        return defaultDir;
    }
}

