/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui.customizer;

import java.io.IOException;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.groovy.grails.api.GrailsEnvironment;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.ui.customizer.GeneralCustomizerPanel;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public class GrailsProjectProperties {
    private final GrailsProject project;
    private final GrailsProjectConfig config;
    private ComboBoxModel environmentModel;
    private ComboBoxModel javaPlatformModel;
    private ButtonModel displayBrowserModel;
    private ListCellRenderer javaPlatformRenderer;
    private String port;
    private String debugBrowser;
    private String vmOptions;

    public GrailsProjectProperties(Project project) {
        assert (project instanceof GrailsProject);
        this.project = (GrailsProject)project;
        this.config = GrailsProjectConfig.forProject((Project)project);
    }

    public GrailsProject getProject() {
        return this.project;
    }

    public ComboBoxModel getEnvironmentModel() {
        if (this.environmentModel == null) {
            GrailsEnvironment[] envs = GrailsEnvironment.standardValues();
            Object[] values = new Object[envs.length];
            for (int i = 0; i < envs.length; ++i) {
                values[i] = new EnvironmentItem(envs[i]);
            }
            this.environmentModel = new DefaultComboBoxModel<Object>(values);
            GrailsEnvironment env = this.config.getEnvironment();
            if (env != null) {
                this.environmentModel.setSelectedItem(new EnvironmentItem(env));
            }
        }
        return this.environmentModel;
    }

    public ComboBoxModel getJavaPlatformModel() {
        if (this.javaPlatformModel == null) {
            this.javaPlatformModel = PlatformUiSupport.createPlatformComboBoxModel((String)((String)this.config.getJavaPlatform().getProperties().get("platform.ant.name")));
        }
        return this.javaPlatformModel;
    }

    public ButtonModel getDisplayBrowserModel() {
        if (this.displayBrowserModel == null) {
            this.displayBrowserModel = new JToggleButton.ToggleButtonModel();
            this.displayBrowserModel.setSelected(this.config.getDisplayBrowser());
        }
        return this.displayBrowserModel;
    }

    public ListCellRenderer getJavaPlatformRenderer() {
        if (this.javaPlatformRenderer == null) {
            this.javaPlatformRenderer = PlatformUiSupport.createPlatformListCellRenderer();
        }
        return this.javaPlatformRenderer;
    }

    public String getPort() {
        if (this.port == null) {
            this.port = this.config.getPort();
        }
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getVmOptions() {
        if (this.vmOptions == null) {
            this.vmOptions = this.config.getVmOptions();
        }
        return this.vmOptions;
    }

    public void setVmOptions(String vmOptions) {
        this.vmOptions = vmOptions;
    }

    public String getDebugBrowser() {
        if (this.debugBrowser == null) {
            this.debugBrowser = this.config.getDebugBrowser();
        }
        return this.debugBrowser;
    }

    public void setDebugBrowser(String debugBrowser) {
        this.debugBrowser = debugBrowser;
    }

    public void save() {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    GrailsProjectProperties.this.saveProperties();
                    return null;
                }
            });
            ProjectManager.getDefault().saveProject((Project)this.project);
        }
        catch (MutexException e) {
            Exceptions.printStackTrace((Throwable)((IOException)e.getException()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void saveProperties() throws IOException {
        Object platform;
        if (this.debugBrowser != null) {
            this.config.setDebugBrowser(this.debugBrowser);
        }
        if (this.port != null) {
            this.config.setPort(this.port);
        }
        this.config.setVmOptions(this.vmOptions);
        EnvironmentItem item = (EnvironmentItem)this.getEnvironmentModel().getSelectedItem();
        if (item != null) {
            this.config.setEnvironment(item.getEnvironment());
        }
        if ((platform = this.getJavaPlatformModel().getSelectedItem()) != null) {
            this.config.setJavaPlatform(PlatformUiSupport.getPlatform((Object)platform));
        }
        this.config.setDisplayBrowser(this.getDisplayBrowserModel().isSelected());
    }

    private static class EnvironmentItem {
        private final GrailsEnvironment environment;

        public EnvironmentItem(GrailsEnvironment environment) {
            this.environment = environment;
        }

        public GrailsEnvironment getEnvironment() {
            return this.environment;
        }

        public String toString() {
            return NbBundle.getMessage(GeneralCustomizerPanel.class, (String)("GeneralCustomizerPanel." + this.environment.toString()));
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnvironmentItem other = (EnvironmentItem)obj;
            return this.environment == other.environment;
        }

        public int hashCode() {
            int hash = 5;
            hash = 37 * hash + (this.environment != null ? this.environment.hashCode() : 0);
            return hash;
        }
    }
}

