/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitTag;
import org.netbeans.modules.git.remote.cli.GitTransportUpdate;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.GitFetchResult;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.CreateTagCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.TransportCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class FetchCommand
extends TransportCommand {
    private final ProgressMonitor monitor;
    private final List<String> refSpecs;
    private final String remote;
    private final RefPlaceholder ref = new RefPlaceholder();
    private Map<String, GitTransportUpdate> updates;
    private GitFetchResult result;

    public FetchCommand(JGitRepository repository, GitClassFactory gitFactory, String remoteName, ProgressMonitor monitor) {
        this(repository, gitFactory, remoteName, Collections.emptyList(), monitor);
    }

    public FetchCommand(JGitRepository repository, GitClassFactory gitFactory, String remote, List<String> fetchRefSpecifications, ProgressMonitor monitor) {
        super(repository, gitFactory, remote, monitor);
        this.monitor = monitor;
        this.remote = remote;
        this.refSpecs = fetchRefSpecifications;
    }

    public Map<String, GitTransportUpdate> getUpdates() {
        return Collections.unmodifiableMap(this.updates);
    }

    public GitFetchResult getResult() {
        return this.result;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(2);
        super.prepare();
        this.addArgument(0, "fetch");
        this.addArgument(0, "-v");
        this.addArgument(0, this.remote);
        for (String refSpec : this.refSpecs) {
            this.addArgument(0, refSpec);
        }
        this.addArgument(1, "show-ref");
        this.addArgument(1, this.ref);
    }

    @Override
    protected void runTransportCommand() throws GitException.AuthorizationException, GitException {
        block6: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                this.result = new GitFetchResult();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        FetchCommand.this.parseFetchOutput(output);
                    }
                }.runCLI();
                this.updates = new LinkedHashMap<String, GitTransportUpdate>();
                for (GitTransportUpdate.GitTransportUpdateContainer c : this.result.result.values()) {
                    if (c.type == GitTransportUpdate.Type.REFERENCE) {
                        this.ref.setContent("refs/" + c.localBranch);
                        final GitTag.TagContainer container = new GitTag.TagContainer();
                        new GitCommand.Runner(canceled, 1){

                            @Override
                            public void outputParser(String output) throws GitException {
                                CreateTagCommand.parseShowRef(output, container);
                            }
                        }.runCLI();
                        c.newID = container.id;
                    }
                    this.updates.put(c.localBranch, this.getClassFactory().createTransportUpdate(c));
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block6;
                throw new GitException(t);
            }
        }
    }

    static void parseSRef(String output, GitTag.TagContainer container) {
        for (String line : output.split("\n")) {
            String[] s = line.split(" ");
            if (s.length != 2) continue;
            String rev = s[0];
            String ref = s[1];
            int i = ref.lastIndexOf(47);
            if (i <= 0) continue;
            container.id = rev;
            container.name = ref.substring(i + 1);
            container.ref = ref;
        }
    }

    private void parseFetchOutput(String output) {
        String url = null;
        for (String line : output.split("\n")) {
            int i;
            if (line.startsWith("From")) {
                String[] s = line.split("\\s");
                url = s[s.length - 1];
                continue;
            }
            if (!line.startsWith("*") && !line.startsWith(" ")) continue;
            GitTransportUpdate.GitTransportUpdateContainer details = new GitTransportUpdate.GitTransportUpdateContainer();
            boolean bl = details.def = '*' == (line = line.trim()).charAt(0);
            if (details.def) {
                line = line.substring(1).trim();
            }
            if ((i = line.indexOf("->")) > 0) {
                details.localBranch = line.substring(i + 2).trim();
                if (details.localBranch.startsWith("refs/")) {
                    details.localBranch = details.localBranch.substring("refs/".length());
                    details.type = GitTransportUpdate.Type.REFERENCE;
                } else {
                    details.type = GitTransportUpdate.Type.BRANCH;
                }
            }
            line = line.substring(0, i).trim();
            int typeBeg = line.indexOf(91);
            int typeEnd = line.indexOf(93);
            if (typeBeg >= 0 && typeEnd > typeBeg) {
                details.operation = line.substring(typeBeg + 1, typeEnd);
                details.remoteBranch = line.substring(typeEnd + 1).trim();
            } else {
                String[] s = line.split("\\s+");
                details.remoteBranch = s[s.length - 1];
            }
            details.url = url;
            this.result.result.put(details.localBranch, details);
        }
    }

    protected static final class RefPlaceholder
    implements CharSequence {
        private String ref = "place-holder";

        protected RefPlaceholder() {
        }

        protected void setContent(String revision) {
            this.ref = revision;
        }

        @Override
        public int length() {
            return this.ref.length();
        }

        @Override
        public char charAt(int index) {
            return this.ref.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.ref.subSequence(end, end);
        }

        @Override
        public String toString() {
            return this.ref;
        }
    }
}

