/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class CatCommand
extends SvnCommand {
    private final CatType type;
    private final SVNUrl url;
    private final VCSFileProxy file;
    private final SVNRevision rev;
    private final SVNRevision pegRevision;
    private byte[] bytes;

    public CatCommand(FileSystem fileSystem, SVNUrl url, SVNRevision rev, SVNRevision pegRevision) {
        super(fileSystem);
        this.url = url;
        this.rev = rev;
        this.file = null;
        this.pegRevision = pegRevision;
        this.type = CatType.url;
    }

    public CatCommand(FileSystem fileSystem, VCSFileProxy file, SVNRevision rev) {
        super(fileSystem);
        this.file = file;
        this.rev = rev;
        this.url = null;
        this.pegRevision = null;
        this.type = CatType.file;
    }

    public InputStream getOutput() {
        return new ByteArrayInputStream(this.bytes == null ? new byte[]{} : this.bytes);
    }

    @Override
    protected boolean hasBinaryOutput() {
        return true;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    public void output(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.CAT;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("cat");
        switch (this.type) {
            case url: {
                if (this.pegRevision == null) {
                    arguments.add(this.url);
                    break;
                }
                arguments.add(this.url, this.pegRevision);
                break;
            }
            case file: {
                arguments.add(this.file);
                this.setCommandWorkingDirectory(this.file);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal cattype: " + (Object)((Object)this.type));
            }
        }
        arguments.add(this.rev);
    }

    private static enum CatType {
        url,
        file;

    }
}

