/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import org.netbeans.modules.cnd.makefile.wizard.EnterItemsPanel;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.TargetData;

public class MakefileSourcesPanel
extends EnterItemsPanel {
    private String srcFilter;
    static final long serialVersionUID = -6961895016031819992L;
    private boolean initialized;
    private int key;

    public MakefileSourcesPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = this.getString("LBL_MakefileSourcesPanel");
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.initialized = false;
    }

    private void create() {
        String msg;
        int flags;
        if (this.getMakefileData().getMakefileType() == 4) {
            flags = 189;
            msg = this.getString("LBL_SourceNamesComplex");
        } else {
            flags = 45;
            msg = this.getString("LBL_SourceNamesSimple");
        }
        this.create(msg, this.getString("MNEM_SourceNames").charAt(0), flags);
    }

    @Override
    protected String getListLabel() {
        return this.getString("LBL_SourceList");
    }

    @Override
    protected char getListMnemonic() {
        return this.getString("MNEM_SourceList").charAt(0);
    }

    @Override
    protected EnterItemsPanel.ErrorInfo getErrorInfo() {
        return new EnterItemsPanel.ErrorInfo(this.getString("DLG_NoFilesError"), this.getString("MSG_NoFilesMatched"));
    }

    @Override
    public void validateData(ArrayList<String> msgs, int key) {
        TargetData target = this.getMakefileData().getTarget(key);
        String[] slist = target.getSourcesList();
        if (slist == null) {
            this.warn(msgs, WARN_NO_SRC_FILES, target.getName());
        } else {
            int i;
            String cwd = this.getMakefileData().getBaseDirectory(true);
            ArrayList<String> dne = new ArrayList<String>();
            int absCount = 0;
            int hdrCount = 0;
            for (i = 0; i < slist.length; ++i) {
                File file;
                String srcFile = slist[i];
                if (srcFile.startsWith("/")) {
                    ++absCount;
                }
                if (srcFile.endsWith(".h")) {
                    ++hdrCount;
                }
                if ((file = srcFile.startsWith(File.separator) ? new File(srcFile) : new File(cwd, srcFile)).exists()) continue;
                dne.add("\t" + file.getPath() + "\n");
            }
            if (absCount > 0) {
                this.warn(msgs, WARN_ABSPATH_SRC_COUNT, target.getName(), String.valueOf(absCount));
            }
            if (hdrCount > 0) {
                this.warn(msgs, WARN_HDR_SRC_COUNT, target.getName(), String.valueOf(hdrCount));
            }
            if (dne.size() > 0) {
                if (dne.size() < 5) {
                    this.warn(msgs, WARN_DNE_FILES, target.getName());
                    for (i = 0; i < dne.size(); ++i) {
                        msgs.add((String)dne.get(i));
                    }
                    msgs.add("\n");
                } else {
                    this.warn(msgs, WARN_DNE_COUNT, target.getName(), String.valueOf(dne.size()));
                }
            }
        }
    }

    @Override
    public void addNotify() {
        TargetData target = this.getMakefileData().getCurrentTarget();
        this.key = target.getKey();
        if (!this.initialized) {
            this.create();
            this.srcFilter = this.getString("DFLT_SourceFilter");
            this.initialized = true;
        }
        this.getEntryText().setText(this.srcFilter);
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        model.removeAllElements();
        String[] slist = target.getSourcesList();
        if (slist != null) {
            for (int i = 0; i < slist.length; ++i) {
                model.addElement(slist[i]);
            }
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        TargetData target = this.getMakefileData().getTarget(this.key);
        String[] slist = this.getListItems();
        target.setSourcesList(slist);
    }
}

