/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.jdbc.JDBCJavaNameRenderer;
import org.netbeans.lib.profiler.ui.jdbc.JDBCView;
import org.netbeans.lib.profiler.ui.jdbc.SQLFilterPanel;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTableModel;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.McsTimeRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;

abstract class JDBCTreeTableView
extends JDBCView {
    private Set<String> commands;
    private Set<String> tables;
    private JDBCTreeTableModel treeTableModel;
    private ProfilerTreeTable treeTable;
    private JPanel bottomPanel;
    private SQLFilterPanel sqlFilter;
    private JdbcResultsSnapshot currentData;
    private HideableBarRenderer[] renderers;

    public JDBCTreeTableView(Set<ClientUtils.SourceCodeSelection> selection, boolean reverse) {
        this.initUI();
    }

    void setData(final JdbcResultsSnapshot newData, Map<Integer, ClientUtils.SourceCodeSelection> newIdMap, int aggregation, Collection<Integer> selectedThreads, boolean mergeThreads, boolean _sampled, boolean diff) {
        String[] _names = newData.getSelectNames();
        long[] _nTotalAllocObjects = newData.getInvocationsPerSelectId();
        long[] _totalAllocObjectsSize = newData.getTimePerSelectId();
        ArrayList<1> nodes = new ArrayList<1>();
        long totalObjects = 0L;
        long _totalObjects = 0L;
        long totalBytes = 0L;
        long _totalBytes = 0L;
        if (this.commands == null) {
            this.commands = new HashSet<String>();
        }
        this.commands.clear();
        if (this.tables == null) {
            this.tables = new HashSet<String>();
        }
        this.tables.clear();
        for (int i = 1; i < _names.length; ++i) {
            if (diff) {
                totalObjects = Math.max(totalObjects, _nTotalAllocObjects[i]);
                _totalObjects = Math.min(_totalObjects, _nTotalAllocObjects[i]);
                totalBytes = Math.max(totalBytes, _totalAllocObjectsSize[i]);
                _totalBytes = Math.min(_totalBytes, _totalAllocObjectsSize[i]);
            } else {
                totalObjects += _nTotalAllocObjects[i];
                totalBytes += _totalAllocObjectsSize[i];
            }
            int statementType = newData.getTypeForSelectId()[i];
            int commandType = newData.getCommandTypeForSelectId()[i];
            String commandString = JDBCTreeTableView.commandString(commandType);
            String[] sqlTables = newData.getTablesForSelectId()[i];
            this.commands.add(commandString.toUpperCase(Locale.ENGLISH));
            this.tables.addAll(Arrays.asList(sqlTables));
            if (!this.sqlFilter.passes(_names[i], commandString, sqlTables, statementType)) continue;
            final int _i = i;
            nodes.add(new SQLQueryNode(_names[i], _nTotalAllocObjects[i], _totalAllocObjectsSize[i], statementType, commandType, sqlTables){

                @Override
                PresoObjAllocCCTNode computeChildren() {
                    return newData.createPresentationCCT(_i, false);
                }
            });
        }
        long __totalBytes = !diff ? totalBytes : Math.max(Math.abs(totalBytes), Math.abs(_totalBytes));
        long __totalObjects = !diff ? totalObjects : Math.max(Math.abs(totalObjects), Math.abs(_totalObjects));
        this.renderers[0].setMaxValue(__totalBytes);
        this.renderers[1].setMaxValue(__totalObjects);
        this.renderers[0].setDiffMode(diff);
        this.renderers[1].setDiffMode(diff);
        this.treeTableModel.setRoot((TreeNode)PresoObjAllocCCTNode.rootNode((PresoObjAllocCCTNode[])nodes.toArray(new PresoObjAllocCCTNode[0])));
        this.currentData = newData;
    }

    public void resetData() {
        this.renderers[0].setMaxValue(0L);
        this.renderers[1].setMaxValue(0L);
        this.renderers[0].setDiffMode(false);
        this.renderers[1].setDiffMode(false);
        this.treeTableModel.setRoot((TreeNode)PresoObjAllocCCTNode.rootNode((PresoObjAllocCCTNode[])new PresoObjAllocCCTNode[0]));
        if (this.commands != null) {
            this.commands.clear();
        }
        if (this.tables != null) {
            this.tables.clear();
        }
        this.currentData = null;
    }

    public void showSelectionColumn() {
        this.treeTable.setColumnVisibility(0, true);
    }

    public void refreshSelection() {
        this.treeTableModel.dataChanged();
    }

    ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        String name = EXPORT_QUERIES;
        if (this.treeTable.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.treeTable);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider((ProfilerTable)this.treeTable, name);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider((ProfilerTable)this.treeTable, name);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.treeTable);
        }
        return exportProviderArray;
    }

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void initUI() {
        this.treeTableModel = new JDBCTreeTableModel((TreeNode)PrestimeCPUCCTNode.EMPTY);
        this.treeTable = new ProfilerTreeTable(this.treeTableModel, true, true, new int[]{0}){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
                return JDBCTreeTableView.this.getUserValueForRow(row);
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                JDBCTreeTableView.this.populatePopup(popup, value, (ClientUtils.SourceCodeSelection)userValue);
            }

            @Override
            protected void popupShowing() {
                JDBCTreeTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                JDBCTreeTableView.this.popupHidden();
            }
        };
        this.setToolTips();
        this.treeTable.providePopupMenu(true);
        this.installDefaultAction();
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.makeTreeAutoExpandable(2);
        this.treeTable.setMainColumn(0);
        this.treeTable.setFitWidthColumn(0);
        this.treeTable.setSortColumn(1);
        this.treeTable.setDefaultSortOrder(1, SortOrder.DESCENDING);
        this.renderers = new HideableBarRenderer[2];
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer()));
        this.renderers[1] = new HideableBarRenderer(new NumberRenderer());
        long refTime = 123456L;
        this.renderers[0].setMaxValue(refTime);
        this.renderers[1].setMaxValue(refTime);
        this.treeTable.setTreeCellRenderer(new JDBCJavaNameRenderer());
        this.treeTable.setColumnRenderer(1, this.renderers[0]);
        this.treeTable.setColumnRenderer(2, this.renderers[1]);
        this.treeTable.setDefaultColumnWidth(1, this.renderers[0].getOptimalWidth());
        this.treeTable.setDefaultColumnWidth(2, this.renderers[1].getMaxNoBarWidth());
        LabelRenderer lr = new LabelRenderer();
        lr.setHorizontalAlignment(11);
        lr.setValue("XStatement TypeX", -1);
        this.treeTable.setColumnRenderer(3, lr);
        this.treeTable.setDefaultSortOrder(3, SortOrder.ASCENDING);
        this.treeTable.setDefaultColumnWidth(3, lr.getPreferredSize().width);
        this.treeTable.setColumnVisibility(3, false);
        this.treeTable.setColumnRenderer(4, lr);
        this.treeTable.setDefaultSortOrder(4, SortOrder.ASCENDING);
        this.treeTable.setDefaultColumnWidth(4, lr.getPreferredSize().width);
        this.treeTable.setColumnVisibility(4, false);
        this.treeTable.setColumnRenderer(5, lr);
        this.treeTable.setDefaultSortOrder(5, SortOrder.ASCENDING);
        this.treeTable.setDefaultColumnWidth(5, lr.getPreferredSize().width);
        this.treeTable.setColumnVisibility(5, false);
        ProfilerTableContainer tableContainer = new ProfilerTableContainer(this.treeTable, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)tableContainer, "Center");
        this.sqlFilter = new SQLFilterPanel(){

            @Override
            Set<String> getCommands() {
                if (JDBCTreeTableView.this.commands == null) {
                    JDBCTreeTableView.this.commands = new HashSet();
                }
                return JDBCTreeTableView.this.commands;
            }

            @Override
            Set<String> getTables() {
                if (JDBCTreeTableView.this.tables == null) {
                    JDBCTreeTableView.this.tables = new HashSet();
                }
                return JDBCTreeTableView.this.tables;
            }

            @Override
            void applyFilter() {
                if (JDBCTreeTableView.this.currentData != null) {
                    JDBCTreeTableView.this.setData(JDBCTreeTableView.this.currentData, null, -1, null, false, false, false);
                }
            }
        };
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.setOpaque(false);
        this.bottomPanel.add((Component)this.sqlFilter, "North");
        this.add((Component)this.bottomPanel, "South");
    }

    @Override
    protected void addFilterFindPanel(JComponent comp) {
        this.bottomPanel.add((Component)comp, "South");
    }

    private void setToolTips() {
        this.treeTable.setColumnToolTips(new String[]{NAME_COLUMN_TOOLTIP, TOTAL_TIME_COLUMN_TOOLTIP, INVOCATIONS_COLUMN_TOOLTIP, COMMANDS_COLUMN_TOOLTIP, TABLES_COLUMN_TOOLTIP, STATEMENTS_COLUMN_TOOLTIP});
    }

    @Override
    protected RowFilter getExcludesFilter() {
        return new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)entry.getIdentifier();
                return JDBCTreeTableView.isSQL(node);
            }
        };
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.treeTable;
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
        PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)this.treeTable.getValueForRow(row);
        if (node == null || JDBCTreeTableView.isSQL(node) || node.isFiltered()) {
            return null;
        }
        String[] name = node.getMethodClassNameAndSig();
        return new ClientUtils.SourceCodeSelection(name[0], name[1], name[2]);
    }

    static boolean isSQL(PresoObjAllocCCTNode node) {
        return node instanceof SQLQueryNode;
    }

    static boolean isSelectable(PresoObjAllocCCTNode node) {
        if (JDBCTreeTableView.isSQL(node)) {
            return false;
        }
        String methodName = node.getMethodClassNameAndSig()[1];
        return methodName != null && !methodName.endsWith("[native]");
    }

    abstract class SQLQueryNode
    extends PresoObjAllocCCTNode {
        String htmlName;
        private final int statementType;
        private final int commandType;
        private final String[] tables;

        SQLQueryNode(String className, long nTotalAllocObjects, long totalAllocObjectsSize, int statementType, int commandType, String[] tables) {
            super(className, nTotalAllocObjects, totalAllocObjectsSize);
            this.statementType = statementType;
            this.commandType = commandType;
            this.tables = tables;
        }

        public CCTNode[] getChildren() {
            if (this.children == null) {
                PresoObjAllocCCTNode root = this.computeChildren();
                this.setChildren(root == null ? new PresoObjAllocCCTNode[]{} : (PresoObjAllocCCTNode[])root.getChildren());
            }
            return this.children;
        }

        public boolean isLeaf() {
            if (this.children == null) {
                return false;
            }
            return super.isLeaf();
        }

        public int getChildCount() {
            if (this.children == null) {
                this.getChildren();
            }
            return super.getChildCount();
        }

        abstract PresoObjAllocCCTNode computeChildren();

        int getStatementType() {
            return this.statementType;
        }

        int getCommandType() {
            return this.commandType;
        }

        String[] getTables() {
            return this.tables;
        }
    }

    private class JDBCTreeTableModel
    extends ProfilerTreeTableModel.Abstract {
        JDBCTreeTableModel(TreeNode root) {
            super(root);
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return JDBCView.COLUMN_NAME;
            }
            if (columnIndex == 1) {
                return JDBCView.COLUMN_TOTALTIME;
            }
            if (columnIndex == 2) {
                return JDBCView.COLUMN_INVOCATIONS;
            }
            if (columnIndex == 3) {
                return JDBCView.COLUMN_COMMANDS;
            }
            if (columnIndex == 4) {
                return JDBCView.COLUMN_TABLES;
            }
            if (columnIndex == 5) {
                return JDBCView.COLUMN_STATEMENTS;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return JTree.class;
            }
            if (columnIndex == 1) {
                return Long.class;
            }
            if (columnIndex == 2) {
                return Integer.class;
            }
            if (columnIndex == 3) {
                return String.class;
            }
            if (columnIndex == 4) {
                return String.class;
            }
            if (columnIndex == 5) {
                return String.class;
            }
            return Long.class;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public Object getValueAt(TreeNode node, int columnIndex) {
            PresoObjAllocCCTNode jdbcNode = (PresoObjAllocCCTNode)node;
            if (columnIndex == 0) {
                return jdbcNode;
            }
            if (columnIndex == 1) {
                return jdbcNode.totalObjSize;
            }
            if (columnIndex == 2) {
                return jdbcNode.nCalls;
            }
            if (columnIndex == 3) {
                if (jdbcNode instanceof SQLQueryNode) {
                    return JDBCView.commandString(((SQLQueryNode)jdbcNode).getCommandType());
                }
                return "-";
            }
            if (columnIndex == 4) {
                if (jdbcNode instanceof SQLQueryNode) {
                    return this.formatTables(((SQLQueryNode)jdbcNode).getTables());
                }
                return "-";
            }
            if (columnIndex == 5) {
                if (jdbcNode instanceof SQLQueryNode) {
                    switch (((SQLQueryNode)jdbcNode).getStatementType()) {
                        case 1: {
                            return JDBCView.STATEMENT_PREPARED;
                        }
                        case 2: {
                            return JDBCView.STATEMENT_CALLABLE;
                        }
                    }
                    return JDBCView.STATEMENT_REGULAR;
                }
                return "-";
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, TreeNode node, int columnIndex) {
        }

        @Override
        public boolean isCellEditable(TreeNode node, int columnIndex) {
            return false;
        }

        private String formatTables(String[] tables) {
            int count = tables.length - 1;
            if (count == -1) {
                return "-";
            }
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (true) {
                b.append(tables[i]);
                if (i == count) {
                    return b.toString();
                }
                b.append(", ");
                ++i;
            }
        }
    }
}

