/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.mobility.cldcplatform;

import java.util.Collections;
import java.util.List;

public final class CLDCPlatformDescriptor {
    public final String displayName;
    public final String home;
    public final String type;
    public final String srcPath;
    public final String docPath;
    public final String preverifyCmd;
    public final String runCmd;
    public final String debugCmd;
    public final List<Device> devices;

    public CLDCPlatformDescriptor(String displayName, String home, String type, String srcPath, String docPath, String preverifyCmd, String runCmd, String debugCmd, List<Device> devices) {
        assert (displayName != null);
        assert (home != null);
        assert (type != null);
        assert (devices != null);
        assert (devices.size() > 0);
        this.displayName = displayName;
        this.home = home;
        this.type = type;
        this.srcPath = srcPath;
        this.docPath = docPath;
        this.preverifyCmd = preverifyCmd;
        this.runCmd = runCmd;
        this.debugCmd = debugCmd;
        this.devices = Collections.unmodifiableList(devices);
    }

    public static final class Screen {
        public final int width;
        public final int height;
        public final int bitDepth;
        public final boolean color;
        public final boolean touch;

        public Screen(int width, int height, int bitDepth, boolean color, boolean touch) {
            this.width = width;
            this.height = height;
            this.bitDepth = bitDepth;
            this.color = color;
            this.touch = touch;
        }
    }

    public static final class Profile {
        public final String name;
        public final String version;
        public final String displayName;
        public final String dependencies;
        public final String classPath;
        public final ProfileType type;
        public final boolean def;

        public Profile(String name, String version, String displayName, ProfileType type, String dependencies, String classPath, boolean def) {
            assert (name != null);
            assert (version != null);
            assert (type != null);
            this.name = name;
            this.version = version;
            this.displayName = displayName;
            this.type = type;
            this.dependencies = dependencies;
            this.classPath = classPath;
            this.def = def;
        }
    }

    public static final class Device {
        public final String name;
        public final String description;
        public final List<String> securityDomains;
        public final List<Profile> profiles;
        public final Screen screen;

        public Device(String name, String description, List<String> securityDomains, List<Profile> profiles, Screen screen) {
            assert (name != null);
            assert (profiles != null);
            this.name = name;
            this.description = description;
            this.securityDomains = securityDomains;
            this.profiles = profiles;
            this.screen = screen;
        }
    }

    public static enum ProfileType {
        Configuration,
        Profile,
        Optional;

    }
}

